/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.mosaic;

import javax.swing.JTabbedPane;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.mosaic.MosaicExpressionsPanel;
import org.esa.snap.core.gpf.ui.mosaic.MosaicFormModel;
import org.esa.snap.core.gpf.ui.mosaic.MosaicIOPanel;
import org.esa.snap.core.gpf.ui.mosaic.MosaicMapProjectionPanel;
import org.esa.snap.ui.AppContext;

public class MosaicForm
extends JTabbedPane {
    private final AppContext appContext;
    private final MosaicFormModel mosaicModel;
    private MosaicIOPanel ioPanel;
    private MosaicMapProjectionPanel mapProjectionPanel;

    public MosaicForm(TargetProductSelector targetProductSelector, AppContext appContext) {
        this.appContext = appContext;
        this.mosaicModel = new MosaicFormModel();
        this.createUI(targetProductSelector);
    }

    private void createUI(TargetProductSelector selector) {
        this.ioPanel = new MosaicIOPanel(this.appContext, this.mosaicModel, selector);
        this.mapProjectionPanel = new MosaicMapProjectionPanel(this.appContext, this.mosaicModel);
        MosaicExpressionsPanel expressionsPanel = new MosaicExpressionsPanel(this.appContext, this.mosaicModel);
        this.addTab("I/O Parameters", this.ioPanel);
        this.addTab("Map Projection Definition", this.mapProjectionPanel);
        this.addTab("Variables & Conditions", expressionsPanel);
    }

    MosaicFormModel getFormModel() {
        return this.mosaicModel;
    }

    void prepareShow() {
        this.ioPanel.prepareShow();
        this.mapProjectionPanel.prepareShow();
    }

    void prepareHide() {
        this.mapProjectionPanel.prepareHide();
        this.ioPanel.prepareHide();
    }
}

