/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.mosaic;

import java.util.Map;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.MosaicOp;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.mosaic.MosaicForm;
import org.esa.snap.core.gpf.ui.mosaic.MosaicFormModel;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.AppContext;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class MosaicDialog
extends SingleTargetProductDialog {
    private final MosaicForm form;

    MosaicDialog(String title, String helpID, AppContext appContext) {
        super(appContext, title, 24, helpID);
        TargetProductSelector selector = this.getTargetProductSelector();
        selector.getModel().setSaveToFileSelected(true);
        selector.getModel().setProductName("mosaic");
        selector.getSaveToFileCheckBox().setEnabled(false);
        this.form = new MosaicForm(selector, appContext);
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi("Mosaic");
        MosaicFormModel formModel = this.form.getFormModel();
        OperatorParameterSupport parameterSupport = new OperatorParameterSupport(operatorSpi.getOperatorDescriptor(), formModel.getPropertySet(), formModel.getParameterMap(), null);
        OperatorMenu operatorMenu = new OperatorMenu(this.getJDialog(), operatorSpi.getOperatorDescriptor(), parameterSupport, appContext, helpID);
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
    }

    protected boolean verifyUserInput() {
        boolean condsNotSpecified;
        MosaicFormModel mosaicModel = this.form.getFormModel();
        if (!this.verifySourceProducts(mosaicModel)) {
            return false;
        }
        if (!this.verifyTargetCrs(mosaicModel)) {
            return false;
        }
        if (!this.verifyVariablesAndConditions(mosaicModel)) {
            return false;
        }
        if (mosaicModel.isUpdateMode() && mosaicModel.getUpdateProduct() == null) {
            this.showErrorDialog("No product to update specified.");
            return false;
        }
        String productName = this.getTargetProductSelector().getModel().getProductName();
        if (!mosaicModel.isUpdateMode() && StringUtils.isNullOrEmpty((String)productName)) {
            this.showErrorDialog("No name for the target product specified.");
            return false;
        }
        boolean varsNotSpecified = mosaicModel.getVariables() == null || mosaicModel.getVariables().length == 0;
        boolean bl = condsNotSpecified = mosaicModel.getConditions() == null || mosaicModel.getConditions().length == 0;
        if (varsNotSpecified && condsNotSpecified) {
            this.showErrorDialog("No variables or conditions specified.");
            return false;
        }
        return this.verifyDEM(mosaicModel);
    }

    @Override
    protected Product createTargetProduct() throws Exception {
        MosaicFormModel formModel = this.form.getFormModel();
        return GPF.createProduct((String)"Mosaic", formModel.getParameterMap(), formModel.getSourceProductMap());
    }

    public int show() {
        this.form.prepareShow();
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.form.prepareHide();
        super.hide();
    }

    private boolean verifyVariablesAndConditions(MosaicFormModel mosaicModel) {
        Map<String, Product> sourceProductMap = mosaicModel.getSourceProductMap();
        MosaicOp.Variable[] variables = mosaicModel.getVariables();
        MosaicOp.Condition[] conditions = mosaicModel.getConditions();
        for (Map.Entry<String, Product> entry : sourceProductMap.entrySet()) {
            String productIdentifier = entry.getKey();
            Product product = entry.getValue();
            if (variables != null) {
                for (MosaicOp.Variable variable : variables) {
                    if (this.isExpressionValidForProduct(variable.getName(), variable.getExpression(), productIdentifier, product)) continue;
                    return false;
                }
            }
            if (conditions == null) continue;
            for (MosaicOp.Variable variable : conditions) {
                if (this.isExpressionValidForProduct(variable.getName(), variable.getExpression(), productIdentifier, product)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isExpressionValidForProduct(String expressionName, String expression, String productIdentifier, Product product) {
        try {
            BandArithmetic.parseExpression((String)expression, (Product[])new Product[]{product}, (int)0);
            return true;
        }
        catch (ParseException e) {
            String msg = String.format("Expression '%s' is invalid for product '%s'.\n%s", expressionName, productIdentifier, e.getMessage());
            this.showErrorDialog(msg);
            e.printStackTrace();
            return false;
        }
    }

    private boolean verifyTargetCrs(MosaicFormModel formModel) {
        try {
            CoordinateReferenceSystem crs = formModel.getTargetCRS();
            if (crs == null) {
                this.showErrorDialog("No 'Coordinate Reference System' selected.");
                return false;
            }
        }
        catch (FactoryException e) {
            e.printStackTrace();
            this.showErrorDialog("No 'Coordinate Reference System' selected.\n" + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean verifySourceProducts(MosaicFormModel formModel) {
        Map<String, Product> sourceProductMap = formModel.getSourceProductMap();
        if (sourceProductMap == null || sourceProductMap.isEmpty()) {
            this.showErrorDialog("No source products specified.");
            return false;
        }
        for (Map.Entry<String, Product> productEntry : sourceProductMap.entrySet()) {
            if (!productEntry.getValue().isMultiSizeProduct()) continue;
            this.showErrorDialog(String.format("Product '%s'contains bands of different sizes. Currently it is not possible to use it for mosaicking.", productEntry.getKey()));
            return false;
        }
        return true;
    }

    private boolean verifyDEM(MosaicFormModel formModel) {
        ElevationModelRegistry elevationModelRegistry;
        ElevationModelDescriptor demDescriptor;
        String externalDemName = formModel.getElevationModelName();
        if (externalDemName != null && (demDescriptor = (elevationModelRegistry = ElevationModelRegistry.getInstance()).getDescriptor(externalDemName)) == null) {
            this.showErrorDialog("The DEM '" + externalDemName + "' is not supported.");
            return false;
        }
        return true;
    }
}

