/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.mosaic;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.common.MosaicOp;
import org.esa.snap.core.gpf.ui.mosaic.ConditionsTableAdapter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConditionsTableAdapterTest {
    private BindingContext bindingContext;

    @Before
    public void before() {
        PropertyContainer pc = ParameterDescriptorFactory.createMapBackedOperatorPropertyContainer((String)"Mosaic");
        this.bindingContext = new BindingContext((PropertySet)pc);
    }

    @Test
    public void variablesProperty() {
        JTable table = new JTable();
        this.bindingContext.bind("conditions", (ComponentAdapter)new ConditionsTableAdapter(table));
        Assert.assertTrue((boolean)(table.getModel() instanceof DefaultTableModel));
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        tableModel.addRow((Object[])null);
        tableModel.addRow((Object[])null);
        Assert.assertEquals((long)2L, (long)table.getRowCount());
        table.setValueAt("a", 0, 0);
        Assert.assertEquals((Object)"a", (Object)table.getValueAt(0, 0));
        table.setValueAt("A", 0, 1);
        Assert.assertEquals((Object)"A", (Object)table.getValueAt(0, 1));
        table.setValueAt(true, 0, 2);
        Assert.assertEquals((Object)true, (Object)table.getValueAt(0, 2));
        table.setValueAt("b", 1, 0);
        Assert.assertEquals((Object)"b", (Object)table.getValueAt(1, 0));
        table.setValueAt("B", 1, 1);
        Assert.assertEquals((Object)"B", (Object)table.getValueAt(1, 1));
        table.setValueAt(false, 1, 2);
        Assert.assertEquals((Object)false, (Object)table.getValueAt(1, 2));
        this.bindingContext.getPropertySet().setValue("conditions", (Object)new MosaicOp.Condition[]{new MosaicOp.Condition("d", "D", true)});
        Assert.assertEquals((long)1L, (long)table.getRowCount());
        Assert.assertEquals((Object)"d", (Object)table.getValueAt(0, 0));
        Assert.assertEquals((Object)"D", (Object)table.getValueAt(0, 1));
        Assert.assertEquals((Object)true, (Object)table.getValueAt(0, 2));
    }
}

