/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TargetProductSelectorModelTest {
    private TargetProductSelectorModel model;
    private DummyTestProductWriterPlugIn writerPlugIn;

    @Before
    public void setUp() throws Exception {
        this.writerPlugIn = new DummyTestProductWriterPlugIn();
        ProductIOPlugInManager.getInstance().addWriterPlugIn((ProductWriterPlugIn)this.writerPlugIn);
        this.model = new TargetProductSelectorModel();
    }

    @Test
    public void testSetGetProductName() {
        this.model.setProductName("Obelix");
        Assert.assertEquals((Object)"Obelix", (Object)this.model.getProductName());
    }

    @Test
    public void testSetGetInvalidProductName() {
        Assert.assertNull((Object)this.model.getProductName());
        try {
            this.model.setProductName("Obel/x");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("The product name 'Obel/x' is not valid"));
        }
        Assert.assertNull((Object)this.model.getProductName());
    }

    @Test
    public void testSetGetFormatName() {
        this.model.setFormatName("Majestix");
        Assert.assertEquals((Object)"Majestix", (Object)this.model.getFormatName());
    }

    @Test
    public void testGetFileName() {
        this.model.setProductName("Obelix");
        Assert.assertEquals((Object)"Obelix", (Object)this.model.getProductName());
        Assert.assertEquals((Object)"Obelix.dim", (Object)this.model.getProductFileName());
        this.model.setFormatName(this.writerPlugIn.getFormatNames()[0]);
        Assert.assertEquals((Object)"Obelix.x", (Object)this.model.getProductFileName());
        this.model.setProductName("Idefix.dim");
        Assert.assertEquals((Object)"Idefix.dim.x", (Object)this.model.getProductFileName());
        this.model.setProductName("Idefix.x");
        Assert.assertEquals((Object)"Idefix.x", (Object)this.model.getProductFileName());
    }

    @Test
    public void testSetGetDirectory() {
        File directory = new File("Gallien");
        this.model.setProductDir(directory);
        Assert.assertEquals((Object)directory, (Object)this.model.getProductDir());
        this.model.setProductName("Obelix");
        Assert.assertEquals((Object)new File("Gallien", "Obelix.dim"), (Object)this.model.getProductFile());
        this.model.setFormatName(this.writerPlugIn.getFormatNames()[0]);
        Assert.assertEquals((Object)new File("Gallien", "Obelix.x"), (Object)this.model.getProductFile());
    }

    @Test
    public void testSelections() {
        Assert.assertTrue((boolean)this.model.isSaveToFileSelected());
        Assert.assertTrue((boolean)this.model.isOpenInAppSelected());
        this.model.setOpenInAppSelected(false);
        Assert.assertFalse((boolean)this.model.isOpenInAppSelected());
        Assert.assertTrue((boolean)this.model.isSaveToFileSelected());
        this.model.setSaveToFileSelected(false);
        Assert.assertFalse((boolean)this.model.isSaveToFileSelected());
        Assert.assertTrue((boolean)this.model.isOpenInAppSelected());
        this.model.setOpenInAppSelected(false);
        Assert.assertFalse((boolean)this.model.isOpenInAppSelected());
        Assert.assertTrue((boolean)this.model.isSaveToFileSelected());
    }

    private class DummyTestProductWriterPlugIn
    implements ProductWriterPlugIn {
        private DummyTestProductWriterPlugIn() {
        }

        public EncodeQualification getEncodeQualification(Product product) {
            return EncodeQualification.FULL;
        }

        public Class[] getOutputTypes() {
            return new Class[]{String.class};
        }

        public ProductWriter createWriterInstance() {
            return new DummyTestProductWriter(this);
        }

        public String[] getFormatNames() {
            return new String[]{"Dummy"};
        }

        public String[] getDefaultFileExtensions() {
            return new String[]{".x"};
        }

        public String getDescription(Locale locale) {
            return "";
        }

        public SnapFileFilter getProductFileFilter() {
            return new SnapFileFilter();
        }
    }

    private class DummyTestProductWriter
    extends AbstractProductWriter {
        public DummyTestProductWriter(ProductWriterPlugIn writerPlugIn) {
            super(writerPlugIn);
        }

        protected void writeProductNodesImpl() throws IOException {
        }

        public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void deleteOutput() throws IOException {
        }
    }
}

