/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.core.ProgressMonitor;
import javax.swing.UIManager;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.ui.DefaultSingleTargetProductDialog;
import org.esa.snap.core.util.converters.GeneralExpressionConverter;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.DefaultAppContext;

public class DefaultSingleTargetProductDialogTest {
    private static final TestOp.Spi SPI = new TestOp.Spi();

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)SPI);
        try {
            DefaultAppContext app = new DefaultAppContext("Killer App");
            app.getApplicationWindow().setSize(200, 200);
            DefaultSingleTargetProductDialog dialog = (DefaultSingleTargetProductDialog)DefaultSingleTargetProductDialog.createDefaultDialog((String)TestOp.Spi.class.getName(), (AppContext)app);
            dialog.setTargetProductNameSuffix("_test");
            dialog.getJDialog().setTitle("TestOp GUI");
            dialog.show();
        }
        finally {
            GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)SPI);
        }
    }

    public static class TestOp
    extends Operator {
        @SourceProduct
        Product masterProduct;
        @SourceProduct
        Product slaveProduct;
        @TargetProduct
        Product target;
        @Parameter(defaultValue="true")
        boolean copyTiePointGrids;
        @Parameter(defaultValue="false")
        Boolean copyMetadata;
        @Parameter(interval="[-1,+1]", defaultValue="-0.1")
        double threshold;
        @Parameter(valueSet={"ME-203", "ME-208", "ME-002"}, defaultValue="ME-208")
        String method;
        @Parameter(description="Mask expression", label="Mask expression", converter=GeneralExpressionConverter.class)
        String validExpression;

        public void initialize() throws OperatorException {
            Product product = new Product("N", "T", 16, 16);
            product.addBand("B1", 30);
            product.addBand("B2", 30);
            product.setPreferredTileSize(4, 4);
            this.target = product;
        }

        public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(TestOp.class);
            }
        }
    }
}

