/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import com.bc.ceres.glevel.support.GenericMultiLevelSource;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import junit.framework.TestCase;

public class GenericMultiLevelSourceTest
extends TestCase {
    final double GEOPHYS_SCALING = 2.5;
    final int GEOPHYS_DATATYPE = 5;

    public void testIt() {
        PlanarImage src = GenericMultiLevelSourceTest.createSourceImage(256, 128);
        GenericMultiLevelSource mls = this.createGeophysicalSourceImage(src, 5);
        GenericMultiLevelSourceTest.assertEquals((int)5, (int)mls.getModel().getLevelCount());
        GenericMultiLevelSourceTest.assertEquals((double)0.0, (double)mls.getImage(0).getData().getSampleDouble(0, 0, 0), (double)1.0E-10);
        GenericMultiLevelSourceTest.assertEquals((double)2.5, (double)mls.getImage(0).getData().getSampleDouble(1, 0, 0), (double)1.0E-10);
        GenericMultiLevelSourceTest.assertEquals((double)5.0, (double)mls.getImage(0).getData().getSampleDouble(0, 1, 0), (double)1.0E-10);
        GenericMultiLevelSourceTest.assertEquals((double)7.5, (double)mls.getImage(0).getData().getSampleDouble(1, 1, 0), (double)1.0E-10);
        this.testLevelImage((MultiLevelSource)mls, 0, 256, 128);
        this.testLevelImage((MultiLevelSource)mls, 1, 128, 64);
        this.testLevelImage((MultiLevelSource)mls, 2, 64, 32);
        this.testLevelImage((MultiLevelSource)mls, 3, 32, 16);
        this.testLevelImage((MultiLevelSource)mls, 4, 16, 8);
    }

    private void testLevelImage(MultiLevelSource mls, int level, int ew, int eh) {
        RenderedImage image = mls.getImage(level);
        GenericMultiLevelSourceTest.assertSame((Object)image, (Object)mls.getImage(level));
        GenericMultiLevelSourceTest.assertEquals((int)5, (int)image.getSampleModel().getDataType());
        GenericMultiLevelSourceTest.assertEquals((int)1, (int)image.getSampleModel().getNumBands());
        GenericMultiLevelSourceTest.assertEquals((int)ew, (int)image.getWidth());
        GenericMultiLevelSourceTest.assertEquals((int)eh, (int)image.getHeight());
    }

    private GenericMultiLevelSource createGeophysicalSourceImage(PlanarImage src, int levelCount) {
        return new GeophysicalMultiLevelSource(src, levelCount);
    }

    static PlanarImage createSourceImage(int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 10);
        bi.getRaster().setSample(0, 0, 0, 0);
        bi.getRaster().setSample(1, 0, 0, 1);
        bi.getRaster().setSample(0, 1, 0, 2);
        bi.getRaster().setSample(1, 1, 0, 3);
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }

    private class GeophysicalMultiLevelSource
    extends GenericMultiLevelSource {
        public GeophysicalMultiLevelSource(PlanarImage src, int levelCount) {
            super((MultiLevelSource)new DefaultMultiLevelSource((RenderedImage)src, levelCount));
        }

        protected RenderedImage createImage(RenderedImage[] sourceImages, int level) {
            RenderedOp op = FormatDescriptor.create((RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)sourceImages[0]), (Integer)5, null);
            return MultiplyConstDescriptor.create((RenderedImage)op, (double[])new double[]{2.5}, null);
        }
    }
}

