/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import junit.framework.TestCase;

public class DefaultMultiLevelModelTest
extends TestCase {
    final double TX0 = -50.0;
    final double TY0 = 150.0;
    final double S0 = 10.0;
    final int W = 800;
    final int H = 600;
    final double[] ES = new double[]{1.0, 2.0, 4.0, 8.0};

    public void testAllProperties() {
        AffineTransform i2m0 = new AffineTransform();
        i2m0.translate(-50.0, 150.0);
        i2m0.scale(10.0, 10.0);
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(4, i2m0, 800, 600);
        DefaultMultiLevelModelTest.assertEquals((int)4, (int)model.getLevelCount());
        DefaultMultiLevelModelTest.assertEquals((Object)new Rectangle2D.Double(-50.0, 150.0, 8000.0, 6000.0), (Object)model.getModelBounds());
        DefaultMultiLevelModelTest.assertEquals((Object)i2m0, (Object)model.getImageToModelTransform(0));
        this.testLevel(model, 0);
        this.testLevel(model, 1);
        this.testLevel(model, 2);
        this.testLevel(model, 3);
    }

    private void testLevel(DefaultMultiLevelModel model, int level) {
        AffineTransform i2m = model.getImageToModelTransform(level);
        double scale = model.getScale(level);
        String msg = "at level " + level + ", ";
        DefaultMultiLevelModelTest.assertEquals((String)msg, (double)this.ES[level], (double)scale, (double)1.0E-10);
        DefaultMultiLevelModelTest.assertEquals((String)msg, (int)level, (int)model.getLevel(scale));
        DefaultMultiLevelModelTest.assertEquals((String)msg, (Object)new Point2D.Double(-50.0, 150.0), (Object)i2m.transform(new Point2D.Double(0.0, 0.0), null));
        DefaultMultiLevelModelTest.assertEquals((String)msg, (Object)new Point2D.Double(10.0 * scale + -50.0, 10.0 * scale + 150.0), (Object)i2m.transform(new Point2D.Double(1.0, 1.0), null));
    }
}

