/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.getasse30;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.dataio.getasse30.GETASSE30Reader;
import org.esa.snap.dataio.getasse30.GETASSE30ReaderPlugIn;

public class GETASSE30ReaderPlugInTest
extends TestCase {
    private GETASSE30ReaderPlugIn _plugIn;

    protected void setUp() throws Exception {
        this._plugIn = new GETASSE30ReaderPlugIn();
    }

    protected void tearDown() throws Exception {
        this._plugIn = null;
    }

    public void testValidInputs() {
        this.testValidInput("./GETASSE30/00N015W.getasse30");
        this.testValidInput("./GETASSE30/00N015W.GETASSE30");
        this.testValidInput("./GETASSE30/00N015W.GETaSSe30");
    }

    private void testValidInput(String s) {
        GETASSE30ReaderPlugInTest.assertTrue((this._plugIn.getDecodeQualification((Object)s) == DecodeQualification.INTENDED ? 1 : 0) != 0);
        GETASSE30ReaderPlugInTest.assertTrue((this._plugIn.getDecodeQualification((Object)new File(s)) == DecodeQualification.INTENDED ? 1 : 0) != 0);
    }

    public void testInvalidInputs() {
        this.testInvalidInput("10n143w.GETASSE30.zip");
        this.testInvalidInput("./GETASSE30/00N015W.getasse30.zip");
        this.testInvalidInput("./GETASSE30/00N015W.GETASSE30.zip");
        this.testInvalidInput("./GETASSE30/readme.txt");
        this.testInvalidInput("./GETASSE30/readme.txt.zip");
        this.testInvalidInput("./GETASSE30/readme");
        this.testInvalidInput("./GETASSE30/");
        this.testInvalidInput("./");
        this.testInvalidInput(".");
        this.testInvalidInput("");
        this.testInvalidInput("./GETASSE30/.hgt");
        this.testInvalidInput("./GETASSE30/.hgt.zip");
        this.testInvalidInput("./GETASSE30/.hgt");
        this.testInvalidInput("./GETASSE30/.hgt.zip");
    }

    private void testInvalidInput(String s) {
        GETASSE30ReaderPlugInTest.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification((Object)s));
        GETASSE30ReaderPlugInTest.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification((Object)new File(s)));
    }

    public void testThatOtherTypesCannotBeDecoded() throws MalformedURLException {
        GETASSE30ReaderPlugInTest.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification(null));
        URL url = new File("./GETASSE30/readme.txt").toURL();
        GETASSE30ReaderPlugInTest.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification((Object)url));
        Object object = new Object();
        GETASSE30ReaderPlugInTest.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification(object));
    }

    public void testCreateReaderInstance() {
        ProductReader reader = this._plugIn.createReaderInstance();
        GETASSE30ReaderPlugInTest.assertTrue((boolean)(reader instanceof GETASSE30Reader));
    }

    public void testGetInputTypes() {
        Class[] inputTypes = this._plugIn.getInputTypes();
        GETASSE30ReaderPlugInTest.assertNotNull((Object)inputTypes);
        GETASSE30ReaderPlugInTest.assertTrue((inputTypes.length == 2 ? 1 : 0) != 0);
        GETASSE30ReaderPlugInTest.assertEquals(String.class, (Object)inputTypes[0]);
        GETASSE30ReaderPlugInTest.assertEquals(File.class, (Object)inputTypes[1]);
    }

    public void testGetFormatNames() {
        String[] formatNames = this._plugIn.getFormatNames();
        GETASSE30ReaderPlugInTest.assertNotNull((Object)formatNames);
        GETASSE30ReaderPlugInTest.assertTrue((formatNames.length == 1 ? 1 : 0) != 0);
        GETASSE30ReaderPlugInTest.assertEquals((String)"GETASSE30", (String)formatNames[0]);
    }

    public void testGetDefaultFileExtensions() {
        String[] defaultFileExtensions = this._plugIn.getDefaultFileExtensions();
        GETASSE30ReaderPlugInTest.assertNotNull((Object)defaultFileExtensions);
        GETASSE30ReaderPlugInTest.assertTrue((defaultFileExtensions.length == 1 ? 1 : 0) != 0);
        GETASSE30ReaderPlugInTest.assertEquals((String)".getasse30", (String)defaultFileExtensions[0]);
    }
}

