/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.getasse30;

import java.text.ParseException;
import junit.framework.TestCase;
import org.esa.snap.dataio.getasse30.GETASSE30FileInfo;

public class GETASSE30FileInfoTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testValidFileSize() {
        GETASSE30FileInfoTest.assertTrue((boolean)GETASSE30FileInfo.isValidFileSize((long)2L));
        GETASSE30FileInfoTest.assertTrue((boolean)GETASSE30FileInfo.isValidFileSize((long)8L));
        GETASSE30FileInfoTest.assertTrue((boolean)GETASSE30FileInfo.isValidFileSize((long)18L));
        GETASSE30FileInfoTest.assertTrue((boolean)GETASSE30FileInfo.isValidFileSize((long)32L));
        GETASSE30FileInfoTest.assertTrue((boolean)GETASSE30FileInfo.isValidFileSize((long)50L));
        GETASSE30FileInfoTest.assertTrue((boolean)GETASSE30FileInfo.isValidFileSize((long)2004002L));
        GETASSE30FileInfoTest.assertTrue((boolean)GETASSE30FileInfo.isValidFileSize((long)93680672L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)-2L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)-1L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)0L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)1L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)3L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)4L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)5L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)6L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)7L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)9L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)87565L));
        GETASSE30FileInfoTest.assertFalse((boolean)GETASSE30FileInfo.isValidFileSize((long)-76L));
    }

    public void testExtractEastingNorthingWithValidStrings() throws ParseException {
        int[] values = GETASSE30FileInfo.parseEastingNorthing((String)"00N015W.GETASSE30");
        GETASSE30FileInfoTest.assertNotNull((Object)values);
        GETASSE30FileInfoTest.assertEquals((int)2, (int)values.length);
        GETASSE30FileInfoTest.assertEquals((int)-15, (int)values[0]);
        GETASSE30FileInfoTest.assertEquals((int)0, (int)values[1]);
        values = GETASSE30FileInfo.parseEastingNorthing((String)"75S135E.GETASSE30");
        GETASSE30FileInfoTest.assertNotNull((Object)values);
        GETASSE30FileInfoTest.assertEquals((int)2, (int)values.length);
        GETASSE30FileInfoTest.assertEquals((int)135, (int)values[0]);
        GETASSE30FileInfoTest.assertEquals((int)-75, (int)values[1]);
    }

    public void testExtractEastingNorthingWithInvalidStrings() {
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"020n10w");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the string not ends with '\\..+' ");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Illegal string format.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)7, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"005n104w");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the string not ends with '\\..+' ");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Illegal string format.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)8, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"05S104E");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the string not ends with '\\..+' ");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Illegal string format.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)7, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing(null);
            GETASSE30FileInfoTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (ParseException e) {
            GETASSE30FileInfoTest.fail((String)"IllegalArgumentException expected");
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"");
        }
        catch (IllegalArgumentException expected) {
            GETASSE30FileInfoTest.assertTrue((expected.getMessage().indexOf("empty") > -1 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            GETASSE30FileInfoTest.fail((String)"IllegalArgumentException expected");
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"020n10aw");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because illegal 'a' character");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Illegal direction character.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)6, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"w0a0n10.GETASSE30");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the string starts with no digit.");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Digit character expected.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)0, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"100n10w.GETASSE30");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the value for north direction is out of bounds.");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"The value '100' for north direction is out of the range 0 ... 90.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)3, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"100s10w.GETASSE30");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the value for south direction is out of bounds.");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"The value '-100' for south direction is out of the range -90 ... 0.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)3, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"80n190e.GETASSE30");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the value for east direction is out of bounds.");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"The value '190' for east direction is out of the range 0 ... 180.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)6, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"80s190w.GETASSE30");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the value for west direction is out of bounds.");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"The value '-190' for west direction is out of the range -180 ... 0.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)6, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"80s80s.GETASSE30");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because value for easting is not available");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Easting value not available.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)-1, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"80e80e.GETASSE30");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because value for northing is not available");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Northing value not available.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)-1, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"80e80sGETASSE30");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because northing easting values are not followed by a dot");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Illegal string format.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)6, (int)expected.getErrorOffset());
        }
        try {
            GETASSE30FileInfo.parseEastingNorthing((String)"80e80s.");
            GETASSE30FileInfoTest.fail((String)"ParseException expected because the dot is not followed by at least one character");
        }
        catch (ParseException expected) {
            GETASSE30FileInfoTest.assertEquals((String)"Illegal string format.", (String)expected.getMessage());
            GETASSE30FileInfoTest.assertEquals((int)6, (int)expected.getErrorOffset());
        }
    }
}

