/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.snap.dataio.geotiff.internal.TiffRational;

public class TiffRationalTest
extends TestCase {
    private static final long _TIFFRATIONAL_MAX = 0xFFFFFFFFL;
    private static final long _TIFFRATIONAL_MIN = 1L;

    public void testCreation() {
        new TiffRational(0xFFFFFFFFL, 0xFFFFFFFFL);
        new TiffRational(0xFFFFFFFFL, 1L);
        new TiffRational(1L, 1L);
        new TiffRational(1L, 0xFFFFFFFFL);
    }

    public void testCreation_WithIllegalValueRanges() {
        int legalValue = 22689356;
        long[][] values = new long[][]{{0x100000000L, 22689356L}, {22689356L, 0x100000000L}, {0x100000000L, 0x100000000L}, {0L, 22689356L}, {22689356L, 0L}, {0L, 0L}};
        for (int i = 0; i < values.length; ++i) {
            long[] longs = values[i];
            try {
                new TiffRational(longs[0], longs[1]);
                TiffRationalTest.fail((String)("IllegalArgumentException expected at index " + i));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (Exception notExpected) {
                TiffRationalTest.fail((String)("IllegalArgumentException expected at index " + i));
            }
        }
    }

    public void testGetNumeratorAndGetDenominator() {
        int legalValue = 22689356;
        long[][] values = new long[][]{{0xFFFFFFFFL, 0xFFFFFFFFL}, {0xFFFFFFFFL, 1L}, {1L, 1L}, {1L, 0xFFFFFFFFL}, {22689356L, 22689356L}};
        for (int i = 0; i < values.length; ++i) {
            long[] longs = values[i];
            TiffRational tiffRational = new TiffRational(longs[0], longs[1]);
            TiffRationalTest.assertEquals((String)("failure at index " + i), (long)longs[0], (long)tiffRational.getNumerator());
            TiffRationalTest.assertEquals((String)("failure at index " + i), (long)longs[1], (long)tiffRational.getDenominator());
        }
    }

    public void testWriteToStream() throws IOException {
        long numerator = 0xFFFFFFFFL;
        long denominator = 0xFFFFFFFCL;
        TiffRational tiffRational = new TiffRational(0xFFFFFFFFL, 0xFFFFFFFCL);
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        tiffRational.write((ImageOutputStream)stream);
        TiffRationalTest.assertEquals((long)8L, (long)stream.length());
        stream.seek(0L);
        TiffRationalTest.assertEquals((int)-1, (int)stream.readInt());
        TiffRationalTest.assertEquals((int)-4, (int)stream.readInt());
    }

    public void testGetSizeInBytes() {
        TiffRational tiffRational = new TiffRational(234L, 23478L);
        TiffRationalTest.assertEquals((int)8, (int)tiffRational.getSizeInBytes());
    }
}

