/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.dataio.geotiff.internal.TiffIFD;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TiffIFD_DataTypeTest {
    private static Band int8Band;
    private static Band uint8Band;
    private static Band int16Band;
    private static Band uint16Band;
    private static Band int32Band;
    private static Band uint32Band;
    private static Band float32Band;
    private static Band float64Band;

    @BeforeClass
    public static void setup() {
        int8Band = new Band("b1", 10, 1, 1);
        uint8Band = new Band("b1", 20, 1, 1);
        int16Band = new Band("b1", 11, 1, 1);
        uint16Band = new Band("b1", 21, 1, 1);
        int32Band = new Band("b1", 12, 1, 1);
        uint32Band = new Band("b1", 22, 1, 1);
        float32Band = new Band("b1", 30, 1, 1);
        float64Band = new Band("b1", 31, 1, 1);
    }

    @Test
    public void testSingleDataType() {
        Assert.assertEquals((long)10L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int8Band}));
        Assert.assertEquals((long)11L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int16Band}));
        Assert.assertEquals((long)12L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int32Band}));
        Assert.assertEquals((long)20L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint8Band}));
        Assert.assertEquals((long)21L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint16Band}));
        Assert.assertEquals((long)22L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint32Band}));
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{float32Band}));
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{float64Band}));
    }

    @Test
    public void testGreatestSignedInt() {
        Assert.assertEquals((long)10L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int8Band, int8Band}));
        Assert.assertEquals((long)11L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int8Band, int16Band}));
        Assert.assertEquals((long)12L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int32Band, int8Band, int16Band}));
    }

    @Test
    public void testGreatestUnsignedInt() {
        Assert.assertEquals((long)20L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint8Band, uint8Band}));
        Assert.assertEquals((long)21L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint8Band, uint16Band}));
        Assert.assertEquals((long)22L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint32Band, uint8Band, uint16Band}));
    }

    @Test
    public void testReturnShort_If_Int8_and_Uint8() {
        Assert.assertEquals((long)11L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int8Band, uint8Band}));
    }

    @Test
    public void testReturnInt_If_Int16_and_Uint16() {
        Assert.assertEquals((long)12L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int16Band, uint16Band}));
    }

    @Test
    public void testReturnDouble_If_Int32_and_Uint32() {
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int32Band, uint32Band}));
    }

    @Test
    public void testGreatestFloat() {
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{float64Band, float32Band}));
    }

    @Test
    public void testReturnFloat_If_Float32_And_any_int16_or_any_int8() {
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int8Band, float32Band}));
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint8Band, float32Band}));
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int16Band, float32Band}));
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint16Band, float32Band}));
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint16Band, int16Band, float32Band}));
    }

    @Test
    public void testReturnDoubleIfFloat32TypeAndInt32() {
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int32Band, float32Band}));
        Assert.assertEquals((long)30L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{uint32Band, float32Band}));
    }

    @Test
    public void testReturnTheMaxSignedIntType_IfTheUnsignedTypesLessThanTheSignedType() {
        Assert.assertEquals((long)11L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int16Band, uint8Band}));
        Assert.assertEquals((long)12L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int32Band, uint8Band}));
        Assert.assertEquals((long)12L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int32Band, uint16Band}));
        Assert.assertEquals((long)12L, (long)TiffIFD.getMaxElemSizeBandDataType((Band[])new Band[]{int32Band, uint16Band, uint8Band}));
    }
}

