/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.UTM;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.esa.snap.dataio.geotiff.GeoTiffProductWriter;
import org.esa.snap.dataio.geotiff.GeoTiffProductWriterPlugIn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoTiffProductReaderPlugInTest {
    private GeoTiffProductReaderPlugIn plugIn;

    @Before
    public void setup() {
        this.plugIn = new GeoTiffProductReaderPlugIn();
    }

    @Test
    public void testDecodeQualificationForTIFFWithoutGeoInformation() throws IOException {
        Product product = new Product("p", "t", 20, 10);
        Band band = product.addBand("band1", 10);
        band.ensureRasterData();
        ImageInputStream inputStream = GeoTiffProductReaderPlugInTest.writeToInputStream(product);
        DecodeQualification decodeQualification = GeoTiffProductReaderPlugIn.getDecodeQualificationImpl((ImageInputStream)inputStream);
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)decodeQualification);
    }

    @Test
    public void testDecodeQualificationForTIFFWithGeoInformation() throws IOException {
        Product product = new Product("p", "t", 20, 10);
        Band band = product.addBand("band1", 10);
        band.ensureRasterData();
        MapInfo mapInfo = new MapInfo((MapProjection)UTM.createProjection((int)26, (boolean)true), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, Datum.WGS_84);
        mapInfo.setSceneWidth(product.getSceneRasterWidth());
        mapInfo.setSceneHeight(product.getSceneRasterHeight());
        product.setSceneGeoCoding((GeoCoding)new MapGeoCoding(mapInfo));
        ImageInputStream inputStream = GeoTiffProductReaderPlugInTest.writeToInputStream(product);
        DecodeQualification decodeQualification = GeoTiffProductReaderPlugIn.getDecodeQualificationImpl((ImageInputStream)inputStream);
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)decodeQualification);
    }

    @Test
    public void testDecodeQualification() throws URISyntaxException {
        File tifInDirInZip;
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugIn.getDecodeQualification((Object)"file.zip"));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugIn.getDecodeQualification((Object)"file"));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)"file.tif"));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)"file.tiff"));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)"file.btf"));
        File zippedgeoTiff = new File(this.getClass().getResource("nearGreenwichMeridian.zip").toURI());
        if (zippedgeoTiff.exists()) {
            Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)zippedgeoTiff));
        }
        if ((tifInDirInZip = new File(this.getClass().getResource("tifInDirInZip.zip").toURI())).exists()) {
            Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugIn.getDecodeQualification((Object)tifInDirInZip));
        }
    }

    @Test
    public void testFileExtensions() {
        String[] fileExtensions = this.plugIn.getDefaultFileExtensions();
        Assert.assertNotNull((Object)fileExtensions);
        List<String> extensionList = Arrays.asList(fileExtensions);
        Assert.assertEquals((long)4L, (long)extensionList.size());
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".tif"));
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".tiff"));
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".zip"));
    }

    @Test
    public void testFormatNames() {
        String[] formatNames = this.plugIn.getFormatNames();
        Assert.assertNotNull((Object)formatNames);
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"GeoTIFF", (Object)formatNames[0]);
    }

    @Test
    public void testInputTypes() {
        Class[] classes = this.plugIn.getInputTypes();
        Assert.assertNotNull((Object)classes);
        Assert.assertEquals((long)3L, (long)classes.length);
        List<Class> list = Arrays.asList(classes);
        Assert.assertEquals((Object)true, (Object)list.contains(File.class));
        Assert.assertEquals((Object)true, (Object)list.contains(String.class));
        Assert.assertEquals((Object)true, (Object)list.contains(InputStream.class));
    }

    @Test
    public void testProductFileFilter() {
        SnapFileFilter snapFileFilter = this.plugIn.getProductFileFilter();
        Assert.assertNotNull((Object)snapFileFilter);
        Assert.assertArrayEquals((Object[])this.plugIn.getDefaultFileExtensions(), (Object[])snapFileFilter.getExtensions());
        Assert.assertEquals((Object)this.plugIn.getFormatNames()[0], (Object)snapFileFilter.getFormatName());
        Assert.assertEquals((Object)true, (Object)snapFileFilter.getDescription().contains(this.plugIn.getDescription(Locale.getDefault())));
    }

    private static ImageInputStream writeToInputStream(Product product) throws IOException {
        Band[] bands;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream outputStream = new MemoryCacheImageOutputStream(byteStream);
        GeoTiffProductWriter writer = (GeoTiffProductWriter)new GeoTiffProductWriterPlugIn().createWriterInstance();
        product.setProductWriter((ProductWriter)writer);
        writer.writeGeoTIFFProduct((ImageOutputStream)outputStream, product);
        for (Band band : bands = product.getBands()) {
            band.writeRasterDataFully(ProgressMonitor.NULL);
        }
        outputStream.flush();
        return new MemoryCacheImageInputStream((InputStream)new ByteArraySeekableStream(byteStream.toByteArray()));
    }
}

