/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import junit.framework.TestCase;
import org.esa.snap.dataio.geotiff.internal.GeoTiffAscii;
import org.esa.snap.dataio.geotiff.internal.TiffDouble;
import org.esa.snap.dataio.geotiff.internal.TiffLong;
import org.esa.snap.dataio.geotiff.internal.TiffRational;
import org.esa.snap.dataio.geotiff.internal.TiffShort;
import org.esa.snap.dataio.geotiff.internal.TiffType;
import org.esa.snap.dataio.geotiff.internal.TiffValue;

public class TiffTypeTest
extends TestCase {
    public void testGetBytesForType() {
        TiffTypeTest.assertEquals((int)1, (int)TiffType.getBytesForType((TiffShort)TiffType.BYTE));
        TiffTypeTest.assertEquals((int)1, (int)TiffType.getBytesForType((TiffShort)TiffType.ASCII));
        TiffTypeTest.assertEquals((int)1, (int)TiffType.getBytesForType((TiffShort)TiffType.SBYTE));
        TiffTypeTest.assertEquals((int)1, (int)TiffType.getBytesForType((TiffShort)TiffType.UNDEFINED));
        TiffTypeTest.assertEquals((int)2, (int)TiffType.getBytesForType((TiffShort)TiffType.SHORT));
        TiffTypeTest.assertEquals((int)2, (int)TiffType.getBytesForType((TiffShort)TiffType.SSHORT));
        TiffTypeTest.assertEquals((int)4, (int)TiffType.getBytesForType((TiffShort)TiffType.LONG));
        TiffTypeTest.assertEquals((int)4, (int)TiffType.getBytesForType((TiffShort)TiffType.SLONG));
        TiffTypeTest.assertEquals((int)4, (int)TiffType.getBytesForType((TiffShort)TiffType.FLOAT));
        TiffTypeTest.assertEquals((int)8, (int)TiffType.getBytesForType((TiffShort)TiffType.DOUBLE));
        TiffTypeTest.assertEquals((int)8, (int)TiffType.getBytesForType((TiffShort)TiffType.RATIONAL));
        TiffTypeTest.assertEquals((int)8, (int)TiffType.getBytesForType((TiffShort)TiffType.SRATIONAL));
    }

    public void testGetBytesForType_WithIllegalArgument() {
        try {
            TiffType.getBytesForType((TiffShort)new TiffShort(3849));
            TiffTypeTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception notExpected) {
            TiffTypeTest.fail((String)("IllegalArgumentException expected, but was  " + notExpected.getClass().getName()));
        }
    }

    public void testGetType() {
        TiffValue[] values = new TiffValue[]{new TiffRational(1L, 2L), new TiffRational(12L, 1L)};
        TiffTypeTest.assertEquals((int)TiffType.RATIONAL.getValue(), (int)TiffType.getType((TiffValue[])values).getValue());
        values = new TiffValue[]{new TiffLong(35486L), new TiffLong(0L)};
        TiffTypeTest.assertEquals((int)TiffType.LONG.getValue(), (int)TiffType.getType((TiffValue[])values).getValue());
        values = new TiffValue[]{new TiffShort(5486), new TiffShort(86)};
        TiffTypeTest.assertEquals((int)TiffType.SHORT.getValue(), (int)TiffType.getType((TiffValue[])values).getValue());
        values = new TiffValue[]{new GeoTiffAscii(new String[]{"548"}), new GeoTiffAscii(new String[]{"fdsd"})};
        TiffTypeTest.assertEquals((int)TiffType.ASCII.getValue(), (int)TiffType.getType((TiffValue[])values).getValue());
        values = new TiffValue[]{new TiffDouble(5486.0), new TiffDouble(86.0)};
        TiffTypeTest.assertEquals((int)TiffType.DOUBLE.getValue(), (int)TiffType.getType((TiffValue[])values).getValue());
    }

    public void testGetType_WithValueNotSupported() {
        TiffValue[] values = new TiffValue[]{new TiffValueNotSupported()};
        try {
            TiffType.getType((TiffValue[])values).getValue();
            TiffTypeTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            TiffTypeTest.assertTrue((expected.getMessage().indexOf("not supported") != -1 ? 1 : 0) != 0);
        }
        catch (Exception notExpected) {
            TiffTypeTest.fail((String)("IllegalArgumentException expected, but was " + notExpected.getClass().getName()));
        }
    }

    public void testGetType_WithDifferingValueTypes() {
        TiffValue[] values = new TiffValue[]{new TiffRational(1L, 1L), new TiffLong(12345L)};
        try {
            TiffType.getType((TiffValue[])values).getValue();
            TiffTypeTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            TiffTypeTest.assertTrue((expected.getMessage().indexOf("same type") != -1 ? 1 : 0) != 0);
        }
        catch (Exception notExpected) {
            TiffTypeTest.fail((String)("IllegalArgumentException expected, but was " + notExpected.getClass().getName()));
        }
    }

    private static class TiffValueNotSupported
    extends TiffValue {
        private TiffValueNotSupported() {
        }
    }
}

