/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.snap.dataio.geotiff.internal.TiffAscii;
import org.esa.snap.dataio.geotiff.internal.TiffDirectoryEntry;
import org.esa.snap.dataio.geotiff.internal.TiffLong;
import org.esa.snap.dataio.geotiff.internal.TiffRational;
import org.esa.snap.dataio.geotiff.internal.TiffShort;
import org.esa.snap.dataio.geotiff.internal.TiffTag;
import org.esa.snap.dataio.geotiff.internal.TiffType;
import org.esa.snap.dataio.geotiff.internal.TiffValue;

public class TiffDirectoryEntryTest
extends TestCase {
    public void testCreation_WithOneValue() {
        TiffShort tag = new TiffShort(3);
        int expValue = 7643;
        TiffLong value = new TiffLong(7643L);
        TiffDirectoryEntry entry = new TiffDirectoryEntry(tag, (TiffValue)value);
        TiffDirectoryEntryTest.assertEquals((int)tag.getValue(), (int)entry.getTag().getValue());
        TiffDirectoryEntryTest.assertEquals((int)TiffType.LONG.getValue(), (int)entry.getType().getValue());
        TiffDirectoryEntryTest.assertEquals((long)1L, (long)entry.getCount().getValue());
        TiffDirectoryEntryTest.assertEquals((long)7643L, (long)((TiffLong)entry.getValues()[0]).getValue());
    }

    public void testCreation_WithValueArray() {
        TiffShort tag = new TiffShort(3);
        int[] values = new int[]{7643, 974646};
        TiffValue[] tiffValues = this.createTiffLongValues(values);
        TiffDirectoryEntry entry = new TiffDirectoryEntry(tag, tiffValues);
        TiffDirectoryEntryTest.assertEquals((int)tag.getValue(), (int)entry.getTag().getValue());
        TiffDirectoryEntryTest.assertEquals((int)TiffType.LONG.getValue(), (int)entry.getType().getValue());
        TiffDirectoryEntryTest.assertEquals((long)values.length, (long)entry.getCount().getValue());
        TiffValue[] actualValues = entry.getValues();
        for (int i = 0; i < actualValues.length; ++i) {
            TiffLong tiffLong = (TiffLong)actualValues[i];
            TiffDirectoryEntryTest.assertEquals((String)("failure at index " + i), (long)values[i], (long)tiffLong.getValue());
        }
    }

    public void testCreation_ValueTypesAreMixed() {
        TiffShort tag = new TiffShort(3);
        TiffValue[] mixedValueTypes = new TiffValue[]{new TiffLong(23445L), new TiffShort(123)};
        try {
            new TiffDirectoryEntry(tag, mixedValueTypes);
            TiffDirectoryEntryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            TiffDirectoryEntryTest.fail((String)"IllegalArgumentException expected");
        }
    }

    public void testWriteToStream() throws IOException {
        TiffValue[] values = new TiffValue[]{new TiffShort(23), new TiffShort(24), new TiffShort(25), new TiffShort(26), new TiffShort(27), new TiffShort(28)};
        TiffShort tag = new TiffShort(3);
        TiffDirectoryEntry entry = new TiffDirectoryEntry(tag, values);
        int entryOffset = 23;
        long valuesOffset = 100L;
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        stream.seek(23L);
        entry.setValuesOffset(100L);
        entry.write((ImageOutputStream)stream);
        TiffDirectoryEntryTest.assertEquals((long)this.getExpectedStreamLength(values, 100L), (long)stream.length());
        stream.seek(23L);
        TiffShort type = TiffType.getType((TiffValue[])values);
        TiffDirectoryEntryTest.assertEquals((int)tag.getValue(), (int)stream.readShort());
        TiffDirectoryEntryTest.assertEquals((int)type.getValue(), (int)stream.readShort());
        TiffDirectoryEntryTest.assertEquals((int)values.length, (int)stream.readInt());
        TiffDirectoryEntryTest.assertEquals((long)100L, (long)stream.readInt());
        stream.seek(100L);
        for (int i = 0; i < values.length; ++i) {
            TiffShort value = (TiffShort)values[i];
            TiffDirectoryEntryTest.assertEquals((String)("failure at index " + i), (int)value.getValue(), (int)stream.readShort());
        }
    }

    public void testWriteToStream_OneTiffShortValue() throws IOException {
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(232), (TiffValue)new TiffShort(28));
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        entry.write((ImageOutputStream)ios);
        TiffDirectoryEntryTest.assertEquals((long)12L, (long)ios.length());
        ios.seek(0L);
        TiffDirectoryEntryTest.assertEquals((int)232, (int)ios.readShort());
        TiffDirectoryEntryTest.assertEquals((short)3, (short)ios.readShort());
        TiffDirectoryEntryTest.assertEquals((int)1, (int)ios.readInt());
        TiffDirectoryEntryTest.assertEquals((int)28, (int)ios.readShort());
        TiffDirectoryEntryTest.assertEquals((int)0, (int)ios.readShort());
    }

    public void testWriteToStream_TwoTiffShortValue() throws IOException {
        TiffShort[] values = new TiffShort[]{new TiffShort(28), new TiffShort(235)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(232), (TiffValue[])values);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        entry.write((ImageOutputStream)ios);
        TiffDirectoryEntryTest.assertEquals((long)12L, (long)ios.length());
        ios.seek(0L);
        TiffDirectoryEntryTest.assertEquals((int)232, (int)ios.readShort());
        TiffDirectoryEntryTest.assertEquals((short)3, (short)ios.readShort());
        TiffDirectoryEntryTest.assertEquals((int)values.length, (int)ios.readInt());
        for (int i = 0; i < values.length; ++i) {
            TiffDirectoryEntryTest.assertEquals((String)("at index [" + i + "] "), (int)values[i].getValue(), (int)ios.readShort());
        }
    }

    public void testWrite_ValuesSizeInBytesIsBiggerThanFour_ValueOffsetIsNull() {
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(3), (TiffValue)new TiffRational(12L, 6L));
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        try {
            entry.write((ImageOutputStream)stream);
            TiffDirectoryEntryTest.fail((String)"IllegalStateException expected because offset for values are not applied");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception notExpected) {
            TiffDirectoryEntryTest.fail((String)("IllegalStateException expected, but was " + notExpected.getClass().getName()));
        }
    }

    public void testGetSize_TiffShort_OneValue() {
        TiffValue[] values = new TiffValue[]{new TiffShort(30)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        TiffDirectoryEntryTest.assertEquals((long)12L, (long)entry.getSize());
    }

    public void testGetSize_TiffShort_TwoValues() {
        TiffValue[] values = new TiffValue[]{new TiffShort(30), new TiffShort(20)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        TiffDirectoryEntryTest.assertEquals((long)12L, (long)entry.getSize());
    }

    public void testGetSize_TiffShort_MoreThanTwoValues() {
        TiffValue[] values = new TiffValue[]{new TiffShort(1), new TiffShort(5), new TiffShort(10)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        int expectedSize = 18;
        TiffDirectoryEntryTest.assertEquals((long)18L, (long)entry.getSize());
    }

    public void testGetSize_TiffLong_OneValue() {
        TiffValue[] values = new TiffValue[]{new TiffLong(30L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        TiffDirectoryEntryTest.assertEquals((long)12L, (long)entry.getSize());
    }

    public void testGetSize_TiffLong_ValueArray() {
        TiffValue[] values = new TiffValue[]{new TiffLong(1L), new TiffLong(5L), new TiffLong(10L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        int expectedSize = 24;
        TiffDirectoryEntryTest.assertEquals((long)24L, (long)entry.getSize());
    }

    public void testGetSize_TiffRational_OneValue() {
        TiffValue[] values = new TiffValue[]{new TiffRational(20L, 30L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        int expectedSize = 20;
        TiffDirectoryEntryTest.assertEquals((long)20L, (long)entry.getSize());
    }

    public void testGetSize_TiffRational_ValueArray() {
        TiffValue[] values = new TiffValue[]{new TiffRational(4L, 1L), new TiffRational(7L, 5L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        int expectedSize = 28;
        TiffDirectoryEntryTest.assertEquals((long)28L, (long)entry.getSize());
    }

    public void testGetValueSizeInBytes_TiffShort() {
        TiffValue[] values = new TiffValue[]{new TiffShort(30), new TiffShort(430), new TiffShort(50), new TiffShort(370)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        TiffDirectoryEntryTest.assertEquals((long)8L, (long)entry.getValuesSizeInBytes());
    }

    public void testGetValueSizeInBytes_TiffLong() {
        TiffValue[] values = new TiffValue[]{new TiffLong(30L), new TiffLong(430L), new TiffLong(50L), new TiffLong(370L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        TiffDirectoryEntryTest.assertEquals((long)16L, (long)entry.getValuesSizeInBytes());
    }

    public void testGetValueSizeInBytes_TiffRational() {
        TiffValue[] values = new TiffValue[]{new TiffRational(30L, 10L), new TiffRational(430L, 20L), new TiffRational(50L, 34L), new TiffRational(370L, 32L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(12), values);
        TiffDirectoryEntryTest.assertEquals((long)32L, (long)entry.getValuesSizeInBytes());
    }

    public void testGetValueSizeInBytes_TiffAscii() {
        TiffValue[] values = new TiffValue[]{new TiffAscii(new String[]{"ab"}), new TiffAscii(new String[]{"kls"}), new TiffAscii(new String[]{"50."}), new TiffAscii(new String[]{"1"})};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(TiffTag.COMPRESSION, values);
        TiffDirectoryEntryTest.assertEquals((long)13L, (long)entry.getValuesSizeInBytes());
    }

    public void testMustValuesBeReferenced_TiffShort_OneValue() {
        TiffValue[] values = new TiffValue[]{new TiffShort(12)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(23), values);
        TiffDirectoryEntryTest.assertFalse((boolean)entry.mustValuesBeReferenced());
    }

    public void testMustValuesBeReferenced_TiffShort_TwoValues() {
        TiffValue[] values = new TiffValue[]{new TiffShort(12), new TiffShort(14)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(23), values);
        TiffDirectoryEntryTest.assertFalse((boolean)entry.mustValuesBeReferenced());
    }

    public void testMustValuesBeReferenced_TiffShort_MoreThanTwoValues() {
        TiffValue[] values = new TiffValue[]{new TiffShort(12), new TiffShort(14), new TiffShort(16)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(23), values);
        TiffDirectoryEntryTest.assertTrue((boolean)entry.mustValuesBeReferenced());
    }

    public void testMustValuesBeReferenced_TiffLong_OneValue() {
        TiffValue[] values = new TiffValue[]{new TiffLong(12L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(23), values);
        TiffDirectoryEntryTest.assertFalse((boolean)entry.mustValuesBeReferenced());
    }

    public void testMustValuesBeReferenced_TiffLong_MoreThanOneValue() {
        TiffValue[] values = new TiffValue[]{new TiffLong(12L), new TiffLong(14L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(23), values);
        TiffDirectoryEntryTest.assertTrue((boolean)entry.mustValuesBeReferenced());
    }

    public void testMustValuesBeReferenced_TiffRational_OneValue() {
        TiffValue[] values = new TiffValue[]{new TiffRational(12L, 14L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(23), values);
        TiffDirectoryEntryTest.assertTrue((boolean)entry.mustValuesBeReferenced());
    }

    public void testMustValuesBeReferenced_TiffRational_MoreThanOneValue() {
        TiffValue[] values = new TiffValue[]{new TiffRational(12L, 6L), new TiffRational(14L, 5L)};
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(23), values);
        TiffDirectoryEntryTest.assertTrue((boolean)entry.mustValuesBeReferenced());
    }

    private long getExpectedStreamLength(TiffValue[] values, long valuesOffset) {
        TiffShort type = TiffType.getType((TiffValue[])values);
        short bytesForType = TiffType.getBytesForType((TiffShort)type);
        return (long)(values.length * bytesForType) + valuesOffset;
    }

    private TiffValue[] createTiffLongValues(int[] ints) {
        TiffValue[] values = new TiffValue[ints.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new TiffLong((long)ints[i]);
        }
        return values;
    }
}

