/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.sun.media.jai.codec.TIFFField;
import java.util.Arrays;
import java.util.List;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.esa.snap.dataio.geotiff.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Utils_CreateGeoTiffFieldsTest {
    private GeoTIFFMetadata metadata;

    @Before
    public void setup() {
        this.metadata = new GeoTIFFMetadata(1, 1, 2);
    }

    @Test
    public void testVersionOnly() {
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)4L, (long)dirField.getCount());
        char[] expected = new char[]{'\u0001', '\u0001', '\u0002', '\u0000'};
        Assert.assertArrayEquals((char[])expected, (char[])dirField.getAsChars());
    }

    @Test
    public void testThreeGeoTIFFShortTags() {
        this.metadata.addGeoShortParam(2300, 4576);
        this.metadata.addGeoShortParam(2400, 12);
        this.metadata.addGeoShortParam(2401, 3456);
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)16L, (long)dirField.getCount());
        char[] expected = new char[]{'\u0001', '\u0001', '\u0002', '\u0003', '\u08fc', '\u0000', '\u0001', '\u11e0', '\u0960', '\u0000', '\u0001', '\f', '\u0961', '\u0000', '\u0001', '\u0d80'};
        Assert.assertArrayEquals((char[])expected, (char[])dirField.getAsChars());
    }

    @Test
    public void testThreeGeoTIFFTagsWithOneAscii() {
        this.metadata.addGeoShortParam(2300, 4576);
        this.metadata.addGeoAscii(2400, "String");
        this.metadata.addGeoShortParam(2401, 3456);
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        TIFFField asciiField = (TIFFField)list.get(1);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)34737L, (long)asciiField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)2L, (long)asciiField.getType());
        Assert.assertEquals((long)16L, (long)dirField.getCount());
        Assert.assertEquals((long)1L, (long)asciiField.getCount());
        char[] expected = new char[]{'\u0001', '\u0001', '\u0002', '\u0003', '\u08fc', '\u0000', '\u0001', '\u11e0', '\u0960', '\u87b1', '\u0007', '\u0000', '\u0961', '\u0000', '\u0001', '\u0d80'};
        Assert.assertArrayEquals((char[])expected, (char[])dirField.getAsChars());
        Assert.assertEquals((Object)"String|", (Object)asciiField.getAsString(0));
    }

    @Test
    public void testThreeGeoTIFFTagsWithOneDouble() {
        this.metadata.addGeoShortParam(2300, 4576);
        this.metadata.addGeoDoubleParam(2400, 4.5);
        this.metadata.addGeoShortParam(2401, 3456);
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        TIFFField doubleField = (TIFFField)list.get(1);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)34736L, (long)doubleField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)12L, (long)doubleField.getType());
        Assert.assertEquals((long)16L, (long)dirField.getCount());
        Assert.assertEquals((long)1L, (long)doubleField.getCount());
        char[] expected = new char[]{'\u0001', '\u0001', '\u0002', '\u0003', '\u08fc', '\u0000', '\u0001', '\u11e0', '\u0960', '\u87b0', '\u0001', '\u0000', '\u0961', '\u0000', '\u0001', '\u0d80'};
        Assert.assertArrayEquals((char[])expected, (char[])dirField.getAsChars());
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new double[]{4.5}, doubleField.getAsDoubles()));
    }

    @Test
    public void testThreeGeoTIFFTagsWithOneDoubleAndOneString() {
        this.metadata.addGeoShortParam(2300, 4576);
        this.metadata.addGeoDoubleParam(2400, 4.5);
        this.metadata.addGeoAscii(2401, "dlkjfg");
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)3L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        TIFFField doubleField = (TIFFField)list.get(1);
        TIFFField asciiField = (TIFFField)list.get(2);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)34736L, (long)doubleField.getTag());
        Assert.assertEquals((long)34737L, (long)asciiField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)12L, (long)doubleField.getType());
        Assert.assertEquals((long)2L, (long)asciiField.getType());
        Assert.assertEquals((long)16L, (long)dirField.getCount());
        Assert.assertEquals((long)1L, (long)doubleField.getCount());
        Assert.assertEquals((long)1L, (long)asciiField.getCount());
        char[] expected = new char[]{'\u0001', '\u0001', '\u0002', '\u0003', '\u08fc', '\u0000', '\u0001', '\u11e0', '\u0960', '\u87b0', '\u0001', '\u0000', '\u0961', '\u87b1', '\u0007', '\u0000'};
        Assert.assertArrayEquals((char[])expected, (char[])dirField.getAsChars());
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new double[]{4.5}, doubleField.getAsDoubles()));
        Assert.assertEquals((Object)"dlkjfg|", (Object)asciiField.getAsString(0));
    }

    @Test
    public void testThreeGeoTIFFStringTags() {
        this.metadata.addGeoAscii(2300, "4576");
        this.metadata.addGeoAscii(2400, "aaaaaaaa");
        this.metadata.addGeoAscii(2401, "bbbb");
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        TIFFField asciiField = (TIFFField)list.get(1);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)34737L, (long)asciiField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)2L, (long)asciiField.getType());
        Assert.assertEquals((long)16L, (long)dirField.getCount());
        Assert.assertEquals((long)3L, (long)asciiField.getCount());
        char[] expected = new char[]{'\u0001', '\u0001', '\u0002', '\u0003', '\u08fc', '\u87b1', '\u0005', '\u0000', '\u0960', '\u87b1', '\t', '\u0005', '\u0961', '\u87b1', '\u0005', '\u000e'};
        Assert.assertArrayEquals((char[])expected, (char[])dirField.getAsChars());
        Assert.assertEquals((Object)"4576|", (Object)asciiField.getAsString(0));
        Assert.assertEquals((Object)"aaaaaaaa|", (Object)asciiField.getAsString(1));
        Assert.assertEquals((Object)"bbbb|", (Object)asciiField.getAsString(2));
    }

    @Test
    public void testVersionAndModelPixelScale() {
        this.metadata.setModelPixelScale(1.0, 2.0, 3.0);
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)4L, (long)dirField.getCount());
        Assert.assertArrayEquals((char[])new char[]{'\u0001', '\u0001', '\u0002', '\u0000'}, (char[])dirField.getAsChars());
        TIFFField scaleField = (TIFFField)list.get(1);
        Assert.assertEquals((long)33550L, (long)scaleField.getTag());
        Assert.assertEquals((long)12L, (long)scaleField.getType());
        Assert.assertEquals((long)3L, (long)scaleField.getCount());
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new double[]{1.0, 2.0, 3.0}, scaleField.getAsDoubles()));
    }

    @Test
    public void testVersionAndModelTiePoint() {
        this.metadata.addModelTiePoint(1.0, 2.0, 3.0, 4.0, 5.0, 6.0);
        this.metadata.addModelTiePoint(2.0, 3.0, 4.0, 5.0, 6.0, 7.0);
        this.metadata.addModelTiePoint(3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)4L, (long)dirField.getCount());
        Assert.assertArrayEquals((char[])new char[]{'\u0001', '\u0001', '\u0002', '\u0000'}, (char[])dirField.getAsChars());
        TIFFField tiePointField = (TIFFField)list.get(1);
        Assert.assertEquals((long)33922L, (long)tiePointField.getTag());
        Assert.assertEquals((long)12L, (long)tiePointField.getType());
        Assert.assertEquals((long)18L, (long)tiePointField.getCount());
        double[] expected = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        Assert.assertEquals((Object)true, (Object)Arrays.equals(expected, tiePointField.getAsDoubles()));
    }

    @Test
    public void testVersionAndModelTransformation() {
        this.metadata.setModelTransformation(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0});
        List list = Utils.createGeoTIFFFields((GeoTIFFMetadata)this.metadata);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        TIFFField dirField = (TIFFField)list.get(0);
        Assert.assertEquals((long)34735L, (long)dirField.getTag());
        Assert.assertEquals((long)3L, (long)dirField.getType());
        Assert.assertEquals((long)4L, (long)dirField.getCount());
        Assert.assertArrayEquals((char[])new char[]{'\u0001', '\u0001', '\u0002', '\u0000'}, (char[])dirField.getAsChars());
        TIFFField transformField = (TIFFField)list.get(1);
        Assert.assertEquals((long)34264L, (long)transformField.getTag());
        Assert.assertEquals((long)12L, (long)transformField.getType());
        Assert.assertEquals((long)16L, (long)transformField.getCount());
        double[] expected = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0};
        Assert.assertEquals((Object)true, (Object)Arrays.equals(expected, transformField.getAsDoubles()));
    }
}

