/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import java.io.ByteArrayOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.geotiff.internal.TiffHeader;
import org.esa.snap.dataio.geotiff.internal.TiffIFD;

public class TiffHeaderTest
extends TestCase {
    private TiffHeader _tiffHeader;

    public void setUp() throws Exception {
        Product product = new Product("name", "type", 10, 15);
        product.addBand("b1", 21);
        this._tiffHeader = new TiffHeader(new Product[]{product});
    }

    public void tearDown() throws Exception {
    }

    public void testCreation_WithNull() {
        try {
            new TiffHeader(null);
            TiffHeaderTest.fail((String)"IllegalArgumentException expected because a null parameter is given");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception notExpected) {
            TiffHeaderTest.fail((String)("IllegalArgumentException expected: but was [" + notExpected.getClass().getName() + "]"));
        }
    }

    public void testCreation_WithZeroSizedArray() {
        try {
            new TiffHeader(new Product[0]);
            TiffHeaderTest.fail((String)"IllegalArgumentException expected because the parameter is a zero sized array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception notExpected) {
            TiffHeaderTest.fail((String)("IllegalArgumentException expected: but was [" + notExpected.getClass().getName() + "]"));
        }
    }

    public void testCreation() {
        Product product = new Product("name", "type", 10, 15);
        product.addBand("b1", 21);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{product});
        TiffHeaderTest.assertNotNull((Object)tiffHeader.getIfdAt(0));
    }

    public void testGetIfdAt() {
        TiffHeaderTest.assertNotNull((Object)this._tiffHeader.getIfdAt(0));
        try {
            this._tiffHeader.getIfdAt(-1);
            TiffHeaderTest.fail((String)"IllegalArgumentException expected because index is less than zero");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception notExpected) {
            TiffHeaderTest.fail((String)("IllegalArgumentException expected: but was [" + notExpected.getClass().getName() + "]"));
        }
        try {
            this._tiffHeader.getIfdAt(1);
            TiffHeaderTest.fail((String)"IllegalArgumentException expected because index ist greater than number of ifd's");
        }
        catch (IllegalArgumentException notExpected) {
        }
        catch (Exception notExpected) {
            TiffHeaderTest.fail((String)("IllegalArgumentException expected: but was [" + notExpected.getClass().getName() + "]"));
        }
    }

    public void testWrite_withOneProduct() throws Exception {
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        this._tiffHeader.write((ImageOutputStream)ios);
        long ifdSize = this._tiffHeader.getIfdAt(0).getRequiredIfdSize();
        long valuesSize = this._tiffHeader.getIfdAt(0).getRequiredReferencedValuesSize();
        long startIfd = TiffHeader.FIRST_IFD_OFFSET.getValue();
        long expectedStreamLength = startIfd + ifdSize + valuesSize;
        long expectedNextIFDOffset = 0L;
        TiffHeaderTest.assertEquals((long)expectedStreamLength, (long)ios.length());
        ios.seek(startIfd + ifdSize - 4L);
        TiffHeaderTest.assertEquals((long)0L, (long)ios.readInt());
    }

    public void testWrite_withTwoProducts() throws Exception {
        Product p1 = new Product("p1", "type", 10, 12);
        Product p2 = new Product("p2", "type", 8, 6);
        p1.addBand("b1", 11);
        p2.addBand("b1", 21);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{p1, p2});
        TiffIFD ifd1 = tiffHeader.getIfdAt(0);
        TiffIFD ifd2 = tiffHeader.getIfdAt(1);
        TiffHeaderTest.assertNotNull((Object)ifd1);
        TiffHeaderTest.assertNotNull((Object)ifd2);
        long startFirstIfd = TiffHeader.FIRST_IFD_OFFSET.getValue();
        long firstIfdEntireSize = ifd1.getRequiredEntireSize();
        long secondIfdSize = ifd2.getRequiredIfdSize();
        long secondIfdValuesSize = ifd2.getRequiredReferencedValuesSize();
        long expectedStreamLength = startFirstIfd + firstIfdEntireSize + secondIfdSize + secondIfdValuesSize;
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        tiffHeader.write((ImageOutputStream)ios);
        TiffHeaderTest.assertEquals((long)expectedStreamLength, (long)ios.length());
    }

    public void testSetBigEndianOrder_littleEndian() throws Exception {
        this._tiffHeader.setBigEndianOrder(false);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(stream);
        this._tiffHeader.write((ImageOutputStream)ios);
        ios.close();
        byte[] bytes = stream.toByteArray();
        TiffHeaderTest.assertEquals((int)73, (int)bytes[0]);
        TiffHeaderTest.assertEquals((int)73, (int)bytes[1]);
    }

    public void testSetBigEndianOrder_bigEndian() throws Exception {
        this._tiffHeader.setBigEndianOrder(true);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(stream);
        this._tiffHeader.write((ImageOutputStream)ios);
        ios.close();
        byte[] bytes = stream.toByteArray();
        TiffHeaderTest.assertEquals((int)77, (int)bytes[0]);
        TiffHeaderTest.assertEquals((int)77, (int)bytes[1]);
    }

    public void testMagicNumber_littleEndian() throws Exception {
        this._tiffHeader.setBigEndianOrder(false);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(stream);
        this._tiffHeader.write((ImageOutputStream)ios);
        ios.close();
        byte[] bytes = stream.toByteArray();
        TiffHeaderTest.assertEquals((int)42, (int)bytes[2]);
        TiffHeaderTest.assertEquals((int)0, (int)bytes[3]);
    }

    public void testMagicNumber_bigEndian() throws Exception {
        this._tiffHeader.setBigEndianOrder(true);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(stream);
        this._tiffHeader.write((ImageOutputStream)ios);
        ios.close();
        byte[] bytes = stream.toByteArray();
        TiffHeaderTest.assertEquals((int)0, (int)bytes[2]);
        TiffHeaderTest.assertEquals((int)42, (int)bytes[3]);
    }

    public void testFirstIfdOffset_littleEndian() throws Exception {
        this._tiffHeader.setBigEndianOrder(false);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(stream);
        this._tiffHeader.write((ImageOutputStream)ios);
        ios.close();
        byte[] bytes = stream.toByteArray();
        TiffHeaderTest.assertEquals((int)10, (int)bytes[4]);
        TiffHeaderTest.assertEquals((int)0, (int)bytes[5]);
        TiffHeaderTest.assertEquals((int)0, (int)bytes[6]);
        TiffHeaderTest.assertEquals((int)0, (int)bytes[7]);
    }

    public void testFirstIfdOffset_bigEndian() throws Exception {
        this._tiffHeader.setBigEndianOrder(true);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(stream);
        this._tiffHeader.write((ImageOutputStream)ios);
        ios.close();
        byte[] bytes = stream.toByteArray();
        TiffHeaderTest.assertEquals((int)0, (int)bytes[4]);
        TiffHeaderTest.assertEquals((int)0, (int)bytes[5]);
        TiffHeaderTest.assertEquals((int)0, (int)bytes[6]);
        TiffHeaderTest.assertEquals((int)10, (int)bytes[7]);
    }
}

