/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFRenderedImage;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapProjectionRegistry;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.dataio.geotiff.GeoTiffProductReader;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.esa.snap.dataio.geotiff.GeoTiffProductWriter;
import org.esa.snap.dataio.geotiff.GeoTiffProductWriterPlugIn;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public class GeoTiffWriteReadTest {
    private static final String WGS_84 = "EPSG:4326";
    private static final String WGS_72 = "EPSG:4322";
    private static final String WGS_84_UTM_ZONE_28S = "EPSG:32728";
    private static final String NEW_ZEALAND_TRANSVERSE_MERCATOR_2000 = "EPSG:2193";
    private static final String WGS84_ARCTIC_POLAR_STEREOGRAPHIC = "EPSG:3995";
    private static final String LAMBERT_CONIC_CONFORMAL_1SP = "EPSG:9801";
    private static final String ALBERS_CONIC_EQUAL_AREA = "Albers_Conic_Equal_Area";
    private Product outProduct;
    private ByteArrayOutputStream outputStream;
    private GeoTiffProductReader reader;
    private File location;

    @Before
    public void setup() {
        this.reader = (GeoTiffProductReader)new GeoTiffProductReaderPlugIn().createReaderInstance();
        this.outputStream = new ByteArrayOutputStream();
        this.location = new File("memory.tif");
        int width = 14;
        int height = 14;
        this.outProduct = new Product("P", "T", 14, 14);
        Band bandInt16 = this.outProduct.addBand("int16", 11);
        bandInt16.setDataElems((Object)GeoTiffWriteReadTest.createShortData(this.getProductSize(), 23));
        ImageManager.getInstance().getSourceImage((RasterDataNode)bandInt16, 0);
    }

    @Test
    public void testWriteReadBeamMetadata() throws IOException {
        Band expectedBand = this.outProduct.getBand("int16");
        expectedBand.setDescription("Danger");
        expectedBand.setUnit("Voltage");
        expectedBand.setScalingFactor(0.7);
        expectedBand.setScalingOffset(100.0);
        expectedBand.setLog10Scaled(true);
        expectedBand.setNoDataValue(12.5);
        expectedBand.setNoDataValueUsed(true);
        Product inProduct = this.writeReadProduct();
        Assert.assertEquals((Object)this.outProduct.getName(), (Object)inProduct.getName());
        Assert.assertEquals((Object)this.outProduct.getProductType(), (Object)inProduct.getProductType());
        Assert.assertEquals((long)this.outProduct.getNumBands(), (long)inProduct.getNumBands());
        Band actualBand = inProduct.getBandAt(0);
        Assert.assertEquals((Object)expectedBand.getName(), (Object)actualBand.getName());
        Assert.assertEquals((Object)expectedBand.getDescription(), (Object)actualBand.getDescription());
        Assert.assertEquals((Object)expectedBand.getUnit(), (Object)actualBand.getUnit());
        Assert.assertEquals((long)expectedBand.getDataType(), (long)actualBand.getDataType());
        Assert.assertEquals((double)expectedBand.getScalingFactor(), (double)actualBand.getScalingFactor(), (double)1.0E-6);
        Assert.assertEquals((double)expectedBand.getScalingOffset(), (double)actualBand.getScalingOffset(), (double)1.0E-6);
        Assert.assertEquals((Object)expectedBand.isLog10Scaled(), (Object)actualBand.isLog10Scaled());
        Assert.assertEquals((double)expectedBand.getNoDataValue(), (double)actualBand.getNoDataValue(), (double)1.0E-6);
        Assert.assertEquals((Object)expectedBand.isNoDataValueUsed(), (Object)actualBand.isNoDataValueUsed());
    }

    @Test
    public void testWriteReadVirtualBandIsNotExcludedInProduct() throws IOException {
        VirtualBand virtualBand = new VirtualBand("VB", 30, this.outProduct.getSceneRasterWidth(), this.outProduct.getSceneRasterHeight(), "X * Y");
        this.outProduct.addBand((Band)virtualBand);
        Product inProduct = this.writeReadProduct();
        Assert.assertEquals((long)2L, (long)inProduct.getNumBands());
        Assert.assertNotNull((Object)inProduct.getBand("VB"));
    }

    @Test
    public void testWriteReadVirtualBandIsExcludedInImageFile() throws IOException {
        Band[] bands;
        VirtualBand virtualBand = new VirtualBand("VB", 30, this.outProduct.getSceneRasterWidth(), this.outProduct.getSceneRasterHeight(), "X * Y");
        this.outProduct.addBand((Band)virtualBand);
        GeoTiffProductWriter writer = (GeoTiffProductWriter)new GeoTiffProductWriterPlugIn().createWriterInstance();
        this.outProduct.setProductWriter((ProductWriter)writer);
        writer.writeGeoTIFFProduct((ImageOutputStream)new MemoryCacheImageOutputStream(this.outputStream), this.outProduct);
        for (Band band : bands = this.outProduct.getBands()) {
            if (!writer.shouldWrite((ProductNode)band)) continue;
            band.readRasterDataFully(ProgressMonitor.NULL);
            writer.writeBandRasterData(band, 0, 0, band.getRasterWidth(), band.getRasterHeight(), band.getData(), ProgressMonitor.NULL);
        }
        writer.flush();
        ByteArraySeekableStream inputStream = new ByteArraySeekableStream(this.outputStream.toByteArray());
        MemoryCacheImageInputStream imageStream = new MemoryCacheImageInputStream((InputStream)inputStream);
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageStream);
        TIFFImageReader imageReader = null;
        while (imageReaders.hasNext()) {
            ImageReader nextReader = imageReaders.next();
            if (!(nextReader instanceof TIFFImageReader)) continue;
            imageReader = (TIFFImageReader)nextReader;
        }
        if (imageReader == null) {
            throw new IllegalStateException("No TIFFImageReader found");
        }
        imageReader.setInput((Object)imageStream);
        Assert.assertEquals((long)1L, (long)imageReader.getNumImages(true));
        ImageReadParam readParam = imageReader.getDefaultReadParam();
        TIFFRenderedImage image = (TIFFRenderedImage)imageReader.readAsRenderedImage(0, readParam);
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getNumBands());
        inputStream.close();
    }

    @Test
    public void testWriteReadIndexCodingSingle8BitBand() throws IOException {
        this.outProduct.removeBand(this.outProduct.getBandAt(0));
        Band bandUInt8 = this.outProduct.addBand("uint8", 20);
        bandUInt8.setDataElems((Object)GeoTiffWriteReadTest.createByteData(this.getProductSize(), 23));
        ImageManager.getInstance().getSourceImage((RasterDataNode)bandUInt8, 0);
        GeoTiffWriteReadTest.setTiePointGeoCoding(this.outProduct);
        IndexCoding indexCoding = new IndexCoding("color_map");
        indexCoding.addIndex("i1", 23, "");
        indexCoding.addIndex("i2", 24, "");
        indexCoding.addIndex("i3", 27, "");
        indexCoding.addIndex("i4", 30, "");
        this.outProduct.getBandAt(0).setSampleCoding((SampleCoding)indexCoding);
        this.outProduct.getIndexCodingGroup().add((ProductNode)indexCoding);
        Product inProduct = this.writeReadProduct();
        Assert.assertEquals((long)1L, (long)inProduct.getIndexCodingGroup().getNodeCount());
        Band indexBand = inProduct.getBandAt(0);
        this.testIndexCoding(indexBand, 4);
    }

    @Test
    public void testWriteReadIndexCodingWith2BandsBand() throws IOException {
        Band bandUInt8 = this.outProduct.addBand("uint8", 20);
        bandUInt8.setDataElems((Object)GeoTiffWriteReadTest.createByteData(this.getProductSize(), 20));
        ImageManager.getInstance().getSourceImage((RasterDataNode)bandUInt8, 0);
        GeoTiffWriteReadTest.setTiePointGeoCoding(this.outProduct);
        IndexCoding indexCoding = new IndexCoding("color_map");
        indexCoding.addIndex("i1", 23, "");
        indexCoding.addIndex("i2", 24, "");
        indexCoding.addIndex("i3", 27, "");
        indexCoding.addIndex("i4", 30, "");
        this.outProduct.getIndexCodingGroup().add((ProductNode)indexCoding);
        this.outProduct.getBandAt(0).setSampleCoding((SampleCoding)indexCoding);
        this.outProduct.getBandAt(1).setSampleCoding((SampleCoding)indexCoding);
        Product inProduct = this.writeReadProduct();
        Assert.assertEquals((long)1L, (long)inProduct.getIndexCodingGroup().getNodeCount());
        this.testIndexCoding(inProduct.getBandAt(0), 4);
        this.testIndexCoding(inProduct.getBandAt(1), 4);
    }

    private void testIndexCoding(Band indexBand, int expectedIndices) {
        Assert.assertTrue((boolean)indexBand.isIndexBand());
        Assert.assertEquals((long)expectedIndices, (long)indexBand.getIndexCoding().getNumAttributes());
        ColorPaletteDef paletteDef = indexBand.getImageInfo(ProgressMonitor.NULL).getColorPaletteDef();
        Assert.assertEquals((long)expectedIndices, (long)paletteDef.getNumColors());
        Color[] colors = paletteDef.getColors();
        Assert.assertNotSame((Object)0, (Object)(colors[0].getRed() | colors[0].getGreen() | colors[0].getBlue()));
        Assert.assertNotSame((Object)0, (Object)(colors[1].getRed() | colors[1].getGreen() | colors[1].getBlue()));
        Assert.assertNotSame((Object)0, (Object)(colors[2].getRed() | colors[2].getGreen() | colors[2].getBlue()));
        Assert.assertNotSame((Object)0, (Object)(colors[3].getRed() | colors[3].getGreen() | colors[3].getBlue()));
    }

    @Test
    public void testWriteReadUTMProjection() throws IOException, TransformException, FactoryException {
        GeoTiffWriteReadTest.setGeoCoding(this.outProduct, WGS_84_UTM_ZONE_28S);
        Product inProduct = this.writeReadProduct();
        Assert.assertEquals((Object)this.outProduct.getName(), (Object)inProduct.getName());
        Assert.assertEquals((Object)this.outProduct.getProductType(), (Object)inProduct.getProductType());
        Assert.assertEquals((long)this.outProduct.getNumBands(), (long)inProduct.getNumBands());
        Assert.assertEquals((Object)this.outProduct.getBandAt(0).getName(), (Object)inProduct.getBandAt(0).getName());
        Assert.assertEquals((long)this.outProduct.getBandAt(0).getDataType(), (long)inProduct.getBandAt(0).getDataType());
        Assert.assertEquals((double)this.outProduct.getBandAt(0).getScalingFactor(), (double)inProduct.getBandAt(0).getScalingFactor(), (double)1.0E-6);
        Assert.assertEquals((double)this.outProduct.getBandAt(0).getScalingOffset(), (double)inProduct.getBandAt(0).getScalingOffset(), (double)1.0E-6);
        Assert.assertEquals((Object)this.location, (Object)inProduct.getFileLocation());
        Assert.assertNotNull((Object)inProduct.getSceneGeoCoding());
        this.assertEquality(this.outProduct.getSceneGeoCoding(), inProduct.getSceneGeoCoding(), 2.0E-5f);
    }

    @Test
    public void testWriteReadLatLonGeocoding() throws IOException, TransformException, FactoryException {
        GeoTiffWriteReadTest.setGeoCoding(this.outProduct, WGS_84);
        Product inProduct = this.writeReadProduct();
        Assert.assertEquals((Object)this.outProduct.getName(), (Object)inProduct.getName());
        Assert.assertEquals((Object)this.outProduct.getProductType(), (Object)inProduct.getProductType());
        Assert.assertEquals((long)this.outProduct.getNumBands(), (long)inProduct.getNumBands());
        Assert.assertEquals((Object)this.outProduct.getBandAt(0).getName(), (Object)inProduct.getBandAt(0).getName());
        Assert.assertEquals((long)this.outProduct.getBandAt(0).getDataType(), (long)inProduct.getBandAt(0).getDataType());
        Assert.assertEquals((double)this.outProduct.getBandAt(0).getScalingFactor(), (double)inProduct.getBandAt(0).getScalingFactor(), (double)1.0E-6);
        Assert.assertEquals((double)this.outProduct.getBandAt(0).getScalingOffset(), (double)inProduct.getBandAt(0).getScalingOffset(), (double)1.0E-6);
        Assert.assertEquals((Object)this.location, (Object)inProduct.getFileLocation());
        Assert.assertNotNull((Object)inProduct.getSceneGeoCoding());
        this.assertEquality(this.outProduct.getSceneGeoCoding(), inProduct.getSceneGeoCoding(), 2.0E-5f);
    }

    @Test
    public void testWriteReadTiePointGeoCoding() throws IOException {
        GeoTiffWriteReadTest.setTiePointGeoCoding(this.outProduct);
        Band bandFloat32 = this.outProduct.addBand("float32", 30);
        bandFloat32.setDataElems((Object)GeoTiffWriteReadTest.createFloats(this.getProductSize(), 2.343f));
        this.performTest(2.0E-5f);
    }

    @Test
    public void testWriteReadTransverseMercator() throws IOException, TransformException, FactoryException {
        GeoTiffWriteReadTest.setGeoCoding(this.outProduct, NEW_ZEALAND_TRANSVERSE_MERCATOR_2000);
        this.performTest(2.0E-5f);
    }

    @Test
    public void testWriteReadLambertConformalConic() throws IOException, TransformException, FactoryException {
        GeoTiffWriteReadTest.setLambertConformalConicGeoCoding(this.outProduct);
        this.performTest(2.0E-5f);
    }

    @Test
    public void testWriteReadLambertConformalConic_MapGeoCoding() throws IOException, TransformException, FactoryException {
        GeoTiffWriteReadTest.setLambertConformalConicGeoCoding_MapGeoCoding(this.outProduct);
        this.performTest(2.0E-4f);
    }

    @Test
    public void testWriteReadStereographic() throws IOException, TransformException, FactoryException {
        GeoTiffWriteReadTest.setGeoCoding(this.outProduct, WGS84_ARCTIC_POLAR_STEREOGRAPHIC);
        this.performTest(2.0E-5f);
    }

    @Test
    public void testWriteReadAlbersEqualArea() throws IOException, TransformException, FactoryException {
        GeoTiffWriteReadTest.setAlbersEqualAreaGeoCoding(this.outProduct);
        this.performTest(2.0E-5f);
    }

    private void performTest(float accuracy) throws IOException {
        Product inProduct = this.writeReadProduct();
        Assert.assertEquals((Object)this.outProduct.getName(), (Object)inProduct.getName());
        Assert.assertEquals((Object)this.outProduct.getProductType(), (Object)inProduct.getProductType());
        Assert.assertEquals((long)this.outProduct.getNumBands(), (long)inProduct.getNumBands());
        for (int i = 0; i < this.outProduct.getNumBands(); ++i) {
            GeoTiffWriteReadTest.assertEquality(this.outProduct.getBandAt(i), inProduct.getBandAt(i));
        }
        Assert.assertEquals((Object)this.location, (Object)inProduct.getFileLocation());
        Assert.assertNotNull((Object)inProduct.getSceneGeoCoding());
        this.assertEquality(this.outProduct.getSceneGeoCoding(), inProduct.getSceneGeoCoding(), accuracy);
    }

    private int getProductSize() {
        int w = this.outProduct.getSceneRasterWidth();
        int h = this.outProduct.getSceneRasterHeight();
        return w * h;
    }

    private static void assertEquality(Band band1, Band band2) throws IOException {
        Assert.assertEquals((Object)band1.getName(), (Object)band2.getName());
        Assert.assertEquals((long)band1.getDataType(), (long)band2.getDataType());
        Assert.assertEquals((double)band1.getScalingFactor(), (double)band2.getScalingFactor(), (double)1.0E-6);
        Assert.assertEquals((double)band1.getScalingOffset(), (double)band2.getScalingOffset(), (double)1.0E-6);
        int width = band1.getRasterWidth();
        int height = band1.getRasterHeight();
        band2.readRasterDataFully(ProgressMonitor.NULL);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                Assert.assertEquals((double)band1.getPixelDouble(i, j), (double)band2.getPixelDouble(i, j), (double)1.0E-13);
            }
        }
    }

    private void assertEquality(GeoCoding gc1, GeoCoding gc2, float accuracy) {
        Assert.assertNotNull((Object)gc2);
        Assert.assertEquals((Object)gc1.canGetGeoPos(), (Object)gc2.canGetGeoPos());
        Assert.assertEquals((Object)gc1.canGetPixelPos(), (Object)gc2.canGetPixelPos());
        Assert.assertEquals((Object)gc1.isCrossingMeridianAt180(), (Object)gc2.isCrossingMeridianAt180());
        if (gc1 instanceof CrsGeoCoding) {
            Assert.assertEquals(CrsGeoCoding.class, gc2.getClass());
            CRS.equalsIgnoreMetadata((Object)gc1, (Object)gc2);
        } else if (gc1 instanceof TiePointGeoCoding) {
            Assert.assertEquals(TiePointGeoCoding.class, gc2.getClass());
        }
        int width = this.outProduct.getSceneRasterWidth();
        int height = this.outProduct.getSceneRasterHeight();
        GeoPos geoPos1 = null;
        GeoPos geoPos2 = null;
        String msgPattern = "%s at [%d,%d] is not equal:";
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                PixelPos pixelPos = new PixelPos((double)i, (double)j);
                geoPos1 = gc1.getGeoPos(pixelPos, geoPos1);
                geoPos2 = gc2.getGeoPos(pixelPos, geoPos2);
                Assert.assertEquals((String)String.format("%s at [%d,%d] is not equal:", "Latitude", i, j), (double)geoPos1.lat, (double)geoPos2.lat, (double)accuracy);
                Assert.assertEquals((String)String.format("%s at [%d,%d] is not equal:", "Longitude", i, j), (double)geoPos1.lon, (double)geoPos2.lon, (double)accuracy);
            }
        }
    }

    private static short[] createShortData(int size, int offset) {
        short[] shorts = new short[size];
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = (short)(i + offset);
        }
        return shorts;
    }

    private static byte[] createByteData(int size, int offset) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(i + offset);
        }
        return bytes;
    }

    private static float[] createFloats(int size, float offset) {
        float[] floats = new float[size];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = (float)i * 6.3243f + offset;
        }
        return floats;
    }

    private static void setGeoCoding(Product product, String epsgCode) throws FactoryException, TransformException {
        CoordinateReferenceSystem crs = CRS.decode((String)epsgCode, (boolean)true);
        Rectangle imageBounds = new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight());
        AffineTransform imageToMap = new AffineTransform();
        imageToMap.translate(0.7, 0.8);
        imageToMap.scale(0.9, -0.8);
        imageToMap.translate(-0.5, -0.6);
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding(crs, imageBounds, imageToMap));
    }

    private static void setLambertConformalConicGeoCoding_MapGeoCoding(Product product) {
        MapTransformDescriptor descriptor = MapProjectionRegistry.getDescriptor((String)"Lambert_Conformal_Conic");
        double[] values = descriptor.getParameterDefaultValues();
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i] - 0.001;
        }
        MapTransform transform = descriptor.createTransform(values);
        MapProjection mapProjection = new MapProjection(descriptor.getTypeID(), transform);
        MapInfo mapInfo = new MapInfo(mapProjection, 0.5f, 0.6f, 0.7f, 0.8f, 0.09f, 0.08f, Datum.WGS_84);
        mapInfo.setSceneWidth(product.getSceneRasterWidth());
        mapInfo.setSceneHeight(product.getSceneRasterHeight());
        product.setSceneGeoCoding((GeoCoding)new MapGeoCoding(mapInfo));
    }

    private static void setLambertConformalConicGeoCoding(Product product) throws FactoryException, TransformException {
        MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup parameters = transformFactory.getDefaultParameters(LAMBERT_CONIC_CONFORMAL_1SP);
        Ellipsoid ellipsoid = DefaultGeodeticDatum.WGS84.getEllipsoid();
        parameters.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis());
        parameters.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis());
        parameters.parameter("central_meridian").setValue(0.0);
        parameters.parameter("latitude_of_origin").setValue(90.0);
        parameters.parameter("scale_factor").setValue(1.0);
        MathTransform transform1 = transformFactory.createParameterizedTransform(parameters);
        DefaultProjectedCRS crs = new DefaultProjectedCRS(parameters.getDescriptor().getName().getCode(), (GeographicCRS)CRS.decode((String)WGS_72, (boolean)true), transform1, (CartesianCS)DefaultCartesianCS.PROJECTED);
        AffineTransform imageToMap = new AffineTransform();
        imageToMap.translate(0.7, 0.8);
        imageToMap.scale(0.9, -0.8);
        imageToMap.translate(-0.5, -0.6);
        Rectangle imageBounds = new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight());
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)crs, imageBounds, imageToMap));
    }

    private static void setAlbersEqualAreaGeoCoding(Product product) throws FactoryException, TransformException {
        MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup parameters = transformFactory.getDefaultParameters(ALBERS_CONIC_EQUAL_AREA);
        Ellipsoid ellipsoid = DefaultGeodeticDatum.WGS84.getEllipsoid();
        parameters.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis());
        parameters.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis());
        parameters.parameter("latitude_of_origin").setValue(50.0);
        parameters.parameter("central_meridian").setValue(99.0);
        parameters.parameter("standard_parallel_1").setValue(56.0);
        parameters.parameter("false_easting").setValue(1000000.0);
        parameters.parameter("false_northing").setValue(0.0);
        MathTransform transform1 = transformFactory.createParameterizedTransform(parameters);
        DefaultProjectedCRS crs = new DefaultProjectedCRS(parameters.getDescriptor().getName().getCode(), (GeographicCRS)CRS.decode((String)WGS_72, (boolean)true), transform1, (CartesianCS)DefaultCartesianCS.PROJECTED);
        AffineTransform imageToMap = new AffineTransform();
        imageToMap.translate(0.7, 0.8);
        imageToMap.scale(0.9, -0.8);
        imageToMap.translate(-0.5, -0.6);
        Rectangle imageBounds = new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight());
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)crs, imageBounds, imageToMap));
    }

    private static void setTiePointGeoCoding(Product product) {
        TiePointGrid latGrid = new TiePointGrid("lat", 3, 3, 0.5, 0.5, 5.0, 5.0, new float[]{85.0f, 84.0f, 83.0f, 75.0f, 74.0f, 73.0f, 65.0f, 64.0f, 63.0f});
        TiePointGrid lonGrid = new TiePointGrid("lon", 3, 3, 0.5, 0.5, 5.0, 5.0, new float[]{-15.0f, -5.0f, 5.0f, -16.0f, -6.0f, 4.0f, -17.0f, -7.0f, 3.0f});
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid));
    }

    private Product writeReadProduct() throws IOException {
        Band[] bands;
        GeoTiffProductWriter writer = (GeoTiffProductWriter)new GeoTiffProductWriterPlugIn().createWriterInstance();
        this.outProduct.setProductWriter((ProductWriter)writer);
        writer.writeGeoTIFFProduct((ImageOutputStream)new MemoryCacheImageOutputStream(this.outputStream), this.outProduct);
        for (Band band : bands = this.outProduct.getBands()) {
            if (!writer.shouldWrite((ProductNode)band)) continue;
            band.readRasterDataFully(ProgressMonitor.NULL);
            writer.writeBandRasterData(band, 0, 0, band.getRasterWidth(), band.getRasterHeight(), band.getData(), ProgressMonitor.NULL);
        }
        writer.flush();
        ByteArraySeekableStream inputStream = new ByteArraySeekableStream(this.outputStream.toByteArray());
        Product product = this.reader.readGeoTIFFProduct((ImageInputStream)new MemoryCacheImageInputStream((InputStream)inputStream), this.location);
        product.setProductReader((ProductReader)this.reader);
        return product;
    }
}

