/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.geotiff.GeoTiffProductWriter;
import org.esa.snap.dataio.geotiff.GeoTiffProductWriterPlugIn;
import org.esa.snap.dataio.geotiff.internal.TiffHeader;
import org.esa.snap.dataio.geotiff.internal.TiffIFD;

public class GeoTiffProductWriterTest
extends TestCase {
    private static final String FILENAME = "temp.tif";
    private GeoTiffProductWriter _productWriter;
    private Product _product;

    protected void setUp() throws Exception {
        new File(FILENAME).delete();
        this._productWriter = new GeoTiffProductWriter((ProductWriterPlugIn)new GeoTiffProductWriterPlugIn());
        this._product = new Product("temp", "type", 10, 20);
        this._product.addBand("b1", 22);
        this.fillBandWithData(this._product.getBand("b1"), 1);
    }

    protected void tearDown() throws Exception {
        this._productWriter.close();
        new File(FILENAME).delete();
    }

    public void testGeoTIFFProductWriterCreation() {
        GeoTiffProductWriter productWriter = new GeoTiffProductWriter((ProductWriterPlugIn)new GeoTiffProductWriterPlugIn());
        GeoTiffProductWriterTest.assertNotNull((Object)productWriter.getWriterPlugIn());
    }

    public void testThatStringIsAValidOutput() throws IOException {
        this._productWriter.writeProductNodes(this._product, (Object)FILENAME);
    }

    public void testThatFileIsAValidOutput() throws IOException {
        this._productWriter.writeProductNodes(this._product, (Object)new File(FILENAME));
    }

    public void testWriteProductNodesAreWritten() throws IOException {
        this._productWriter.writeProductNodes(this._product, (Object)FILENAME);
        this._productWriter.close();
        GeoTiffProductWriterTest.assertTrue((new File(FILENAME).length() > 0L ? 1 : 0) != 0);
    }

    public void testWriteProductNodes_CropFileSize() throws IOException {
        long expectedSize = this.computeExpectedSize(this._product);
        this.createBiggerFile(expectedSize);
        this._productWriter.writeProductNodes(this._product, (Object)FILENAME);
        this.writeAllBands(this._product);
        this._productWriter.close();
        GeoTiffProductWriterTest.assertEquals((long)expectedSize, (long)new File(FILENAME).length());
    }

    private void writeAllBands(Product product) throws IOException {
        Band[] bands;
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        for (Band band : bands = product.getBands()) {
            this._productWriter.writeBandRasterData(band, 0, 0, width, height, band.getData(), ProgressMonitor.NULL);
        }
    }

    private void createBiggerFile(long expectedSize) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(FILENAME, "rw");
        raf.setLength(expectedSize + 10L);
        raf.close();
    }

    private long computeExpectedSize(Product product) {
        TiffIFD tiffIFD = new TiffIFD(product);
        return tiffIFD.getRequiredEntireSize() + TiffHeader.FIRST_IFD_OFFSET.getValue();
    }

    private void fillBandWithData(Band band, int start) {
        ProductData data = band.createCompatibleRasterData();
        for (int i = 0; i < band.getRasterWidth() * band.getRasterHeight(); ++i) {
            data.setElemIntAt(i, start + i);
        }
        band.setData(data);
    }
}

