/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.geotiff.GeoTiffProductWriterPlugIn;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoTiffProductWriterPlugInTest {
    private GeoTiffProductWriterPlugIn plugIn;

    @Before
    public void setup() {
        this.plugIn = new GeoTiffProductWriterPlugIn();
    }

    @Test
    public void testFileExtensions() {
        String[] fileExtensions = this.plugIn.getDefaultFileExtensions();
        Assert.assertNotNull((Object)fileExtensions);
        List<String> extensionList = Arrays.asList(fileExtensions);
        Assert.assertEquals((long)2L, (long)extensionList.size());
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".tif"));
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".tiff"));
    }

    @Test
    public void testFormatNames() {
        String[] formatNames = this.plugIn.getFormatNames();
        Assert.assertNotNull((Object)formatNames);
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"GeoTIFF", (Object)formatNames[0]);
    }

    @Test
    public void testOutputTypes() {
        Class[] classes = this.plugIn.getOutputTypes();
        Assert.assertNotNull((Object)classes);
        Assert.assertEquals((long)2L, (long)classes.length);
        List<Class> list = Arrays.asList(classes);
        Assert.assertEquals((Object)true, (Object)list.contains(File.class));
        Assert.assertEquals((Object)true, (Object)list.contains(String.class));
    }

    @Test
    public void testProductFileFilter() {
        SnapFileFilter snapFileFilter = this.plugIn.getProductFileFilter();
        Assert.assertNotNull((Object)snapFileFilter);
        Assert.assertArrayEquals((Object[])this.plugIn.getDefaultFileExtensions(), (Object[])snapFileFilter.getExtensions());
        Assert.assertEquals((Object)this.plugIn.getFormatNames()[0], (Object)snapFileFilter.getFormatName());
        Assert.assertEquals((Object)true, (Object)snapFileFilter.getDescription().contains(this.plugIn.getDescription(Locale.getDefault())));
    }

    @Test
    public void testEncodingQualification() throws Exception {
        Product product = new Product("N", "T", 2, 2);
        EncodeQualification encodeQualification = this.plugIn.getEncodeQualification(product);
        Assert.assertNotNull((Object)encodeQualification);
        Assert.assertEquals((Object)EncodeQualification.Preservation.PARTIAL, (Object)encodeQualification.getPreservation());
        Assert.assertNotNull((Object)encodeQualification.getInfoString());
        TiePointGrid lat = new TiePointGrid("lat", 2, 2, 0.0, 0.0, 1.0, 1.0, new float[4]);
        TiePointGrid lon = new TiePointGrid("lon", 2, 2, 0.0, 0.0, 1.0, 1.0, new float[4]);
        product.addTiePointGrid(lat);
        product.addTiePointGrid(lon);
        product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(lat, lon));
        encodeQualification = this.plugIn.getEncodeQualification(product);
        Assert.assertEquals((Object)EncodeQualification.Preservation.PARTIAL, (Object)encodeQualification.getPreservation());
        Assert.assertNotNull((Object)encodeQualification.getInfoString());
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 2, 2, 0.0, 0.0, 1.0, 1.0));
        encodeQualification = this.plugIn.getEncodeQualification(product);
        Assert.assertEquals((Object)EncodeQualification.Preservation.FULL, (Object)encodeQualification.getPreservation());
    }
}

