/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.snap.core.datamodel.AngularDirection;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Pointing;
import org.esa.snap.core.datamodel.PointingFactory;
import org.esa.snap.core.datamodel.PointingFactoryRegistry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;

public class PointingTest
extends TestCase {
    public PointingTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(PointingTest.class);
    }

    public void testPointingForMerisLikeProduct() {
        Product product = this.createMerisLikeProduct();
        this.testMerisPointingAt00(product, product.getBand("radiance_7").getPointing());
        this.testMerisPointingAt00(product, product.getBand("radiance_13").getPointing());
        this.testMerisPointingAt00(product, product.getBand("l1_flags").getPointing());
    }

    public void testPointingForAatsrLikeProduct() {
        Product product = this.createAatsrLikeProduct();
        this.testAatsrPointingAt00Fward(product, product.getBand("reflec_fward_0670").getPointing());
        this.testAatsrPointingAt00Nadir(product, product.getBand("reflec_nadir_0670").getPointing());
        this.testAatsrPointingAt00Fward(product, product.getBand("confid_flags_fward").getPointing());
        this.testAatsrPointingAt00Nadir(product, product.getBand("confid_flags_nadir").getPointing());
    }

    private Product createMerisLikeProduct() {
        Product product = new Product("Tatutata", "MER_RR__1P", 16, 16);
        TiePointGrid latGrid = new TiePointGrid("latitude", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        TiePointGrid lonGrid = new TiePointGrid("longitude", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        TiePointGrid saGrid = new TiePointGrid("sun_azimuth", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{2.0f, 3.0f, 4.0f, 5.0f});
        TiePointGrid szGrid = new TiePointGrid("sun_zenith", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        TiePointGrid vaGrid = new TiePointGrid("view_azimuth", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{10.0f, 20.0f, 30.0f, 40.0f});
        TiePointGrid vzGrid = new TiePointGrid("view_zenith", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{0.0f, 1.0f, 2.0f, 3.0f});
        TiePointGrid elGrid = new TiePointGrid("dem_alt", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{20.0f, 30.0f, 40.0f, 50.0f});
        Band band7 = new Band("radiance_7", 21, 16, 16);
        Band band13 = new Band("radiance_13", 21, 16, 16);
        Band flags = new Band("l1_flags", 20, 16, 16);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.addTiePointGrid(szGrid);
        product.addTiePointGrid(saGrid);
        product.addTiePointGrid(vzGrid);
        product.addTiePointGrid(vaGrid);
        product.addTiePointGrid(elGrid);
        product.addBand(band7);
        product.addBand(band13);
        product.addBand(flags);
        product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid));
        PointingFactoryRegistry registry = PointingFactoryRegistry.getInstance();
        PointingFactory pointingFactory = registry.getPointingFactory(product.getProductType());
        product.setPointingFactory(pointingFactory);
        return product;
    }

    private void testMerisPointingAt00(Product product, Pointing pointing) {
        PointingTest.assertNotNull((Object)pointing);
        PointingTest.assertSame((Object)product.getSceneGeoCoding(), (Object)pointing.getGeoCoding());
        PixelPos pixel00 = new PixelPos(0.0, 0.0);
        Assert.assertEquals((Object)new AngularDirection(2.0, 1.0), (Object)pointing.getSunDir(pixel00, null));
        PointingTest.assertEquals((Object)new AngularDirection(10.0, 0.0), (Object)pointing.getViewDir(pixel00, null));
        PointingTest.assertEquals((double)20.0, (double)pointing.getElevation(pixel00), (double)1.0E-10f);
    }

    private Product createAatsrLikeProduct() {
        Product product = new Product("FischersFritz", "ATS_TOA_1P", 16, 16);
        TiePointGrid latGrid = new TiePointGrid("latitude", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        TiePointGrid lonGrid = new TiePointGrid("longitude", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        TiePointGrid saGridF = new TiePointGrid("sun_azimuth_fward", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{22.0f, 32.0f, 42.0f, 52.0f});
        TiePointGrid seGridF = new TiePointGrid("sun_elev_fward", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{15.0f, 25.0f, 35.0f, 45.0f});
        TiePointGrid vaGridF = new TiePointGrid("view_azimuth_fward", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{72.0f, 73.0f, 74.0f, 75.0f});
        TiePointGrid veGridF = new TiePointGrid("view_elev_fward", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{61.0f, 62.0f, 63.0f, 64.0f});
        TiePointGrid saGridN = new TiePointGrid("sun_azimuth_nadir", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{10.0f, 20.0f, 30.0f, 40.0f});
        TiePointGrid seGridN = new TiePointGrid("sun_elev_nadir", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{0.0f, 1.0f, 2.0f, 3.0f});
        TiePointGrid vaGridN = new TiePointGrid("view_azimuth_nadir", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{-2.0f, -3.0f, -4.0f, -5.0f});
        TiePointGrid veGridN = new TiePointGrid("view_elev_nadir", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{17.0f, 27.0f, 37.0f, 47.0f});
        TiePointGrid elGrid = new TiePointGrid("altitude", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{207.0f, 307.0f, 407.0f, 507.0f});
        Band band670F = new Band("reflec_fward_0670", 21, 16, 16);
        Band band670N = new Band("reflec_nadir_0670", 21, 16, 16);
        Band flagsF = new Band("confid_flags_fward", 20, 16, 16);
        Band flagsN = new Band("confid_flags_nadir", 20, 16, 16);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.addTiePointGrid(saGridF);
        product.addTiePointGrid(seGridF);
        product.addTiePointGrid(vaGridF);
        product.addTiePointGrid(veGridF);
        product.addTiePointGrid(saGridN);
        product.addTiePointGrid(seGridN);
        product.addTiePointGrid(vaGridN);
        product.addTiePointGrid(veGridN);
        product.addTiePointGrid(elGrid);
        product.addBand(band670F);
        product.addBand(band670N);
        product.addBand(flagsF);
        product.addBand(flagsN);
        product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid));
        PointingFactoryRegistry registry = PointingFactoryRegistry.getInstance();
        PointingFactory pointingFactory = registry.getPointingFactory(product.getProductType());
        product.setPointingFactory(pointingFactory);
        return product;
    }

    private void testAatsrPointingAt00Fward(Product product, Pointing pointing) {
        PointingTest.assertNotNull((Object)pointing);
        PointingTest.assertSame((Object)product.getSceneGeoCoding(), (Object)pointing.getGeoCoding());
        PixelPos pixel00 = new PixelPos(0.0, 0.0);
        PointingTest.assertEquals((Object)new AngularDirection(22.0, 75.0), (Object)pointing.getSunDir(pixel00, null));
        PointingTest.assertEquals((Object)new AngularDirection(72.0, 29.0), (Object)pointing.getViewDir(pixel00, null));
        PointingTest.assertEquals((double)207.0, (double)pointing.getElevation(pixel00), (double)1.0E-10f);
    }

    private void testAatsrPointingAt00Nadir(Product product, Pointing pointing) {
        PointingTest.assertNotNull((Object)pointing);
        PointingTest.assertSame((Object)product.getSceneGeoCoding(), (Object)pointing.getGeoCoding());
        PixelPos pixel00 = new PixelPos(0.0, 0.0);
        PointingTest.assertEquals((Object)new AngularDirection(10.0, 90.0), (Object)pointing.getSunDir(pixel00, null));
        PointingTest.assertEquals((Object)new AngularDirection(-2.0, 73.0), (Object)pointing.getViewDir(pixel00, null));
        PointingTest.assertEquals((double)207.0, (double)pointing.getElevation(pixel00), (double)1.0E-10f);
    }
}

