/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.IOException;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.envisat.EnvisatAuxReader;
import org.junit.Assert;
import org.junit.Test;

public class EnvisatAuxReaderTest {
    String ers1XCAFilePath = "org/esa/snap/dataio/testdata/ER1_XCA_AXNXXX20050321_000000_19910101_000000_20100101_000000.txt";
    String ers2XCAFilePath = "org/esa/snap/dataio/testdata/ER2_XCA_AXNXXX20050321_000000_19950101_000000_20100101_000000.txt";
    String envisatXCAFilePath = "org/esa/snap/dataio/testdata/ASA_XCA_AXVIEC20070517_153558_20070204_165113_20071231_000000";
    String envisatXCAZipFilePath = "org/esa/snap/dataio/testdata/ASA_XCA_AXVIEC20070517_153558_20070204_165113_20071231_000000.zip";
    String envisatXCAZipFilePath2 = "org/esa/snap/dataio/testdata/ASA_XCA_AXVIEC20070517_153558_20070204_165113_20071231_000000_2";
    String envisatXCAGZFilePath = "org/esa/snap/dataio/testdata/ASA_XCA_AXVIEC20070517_153558_20070204_165113_20071231_000000.gz";

    @Test
    public void testAutoLookupZIP() throws IOException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        reader.readProduct((Object)this.envisatXCAZipFilePath2);
        EnvisatAuxReaderTest.testAuxDataFromGADS(reader);
    }

    @Test
    public void testUncompressed() throws IOException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        reader.readProduct((Object)this.envisatXCAFilePath);
        EnvisatAuxReaderTest.testAuxDataFromGADS(reader);
    }

    @Test
    public void testERS1() throws IOException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        reader.readProduct((Object)this.ers1XCAFilePath);
    }

    @Test
    public void testERS2() throws IOException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        reader.readProduct((Object)this.ers2XCAFilePath);
    }

    @Test
    public void testGZIP() throws IOException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        reader.readProduct((Object)this.envisatXCAGZFilePath);
        EnvisatAuxReaderTest.testAuxDataFromGADS(reader);
    }

    @Test
    public void testZIP() throws IOException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        reader.readProduct((Object)this.envisatXCAZipFilePath);
        EnvisatAuxReaderTest.testAuxDataFromGADS(reader);
    }

    static void testAuxDataFromGADS(EnvisatAuxReader reader) throws ProductIOException {
        ProductData extCalImVvData = reader.getAuxData("ext_cal_im_vv");
        Assert.assertNotNull((Object)extCalImVvData);
        float[] extCalImVv = (float[])extCalImVvData.getElems();
        Assert.assertEquals((long)7L, (long)extCalImVv.length);
        Assert.assertEquals((float)34994.516f, (float)extCalImVv[0], (float)1.0E-6f);
        Assert.assertEquals((float)32284.941f, (float)extCalImVv[1], (float)1.0E-5f);
        Assert.assertEquals((float)39084.09f, (float)extCalImVv[2], (float)1.0E-5f);
        Assert.assertEquals((float)33113.11f, (float)extCalImVv[3], (float)1.0E-5f);
        Assert.assertEquals((float)34994.516f, (float)extCalImVv[4], (float)1.0E-5f);
        Assert.assertEquals((float)34994.516f, (float)extCalImVv[5], (float)1.0E-5f);
        ProductData elevAngleData = reader.getAuxData("elev_ang_is1");
        float elevAngle1 = elevAngleData.getElemFloat();
        Assert.assertEquals((double)16.628, (double)elevAngle1, (double)1.0E-5);
        ProductData patData = reader.getAuxData("pattern_is1");
        float[] pattern1 = (float[])patData.getElems();
        Assert.assertEquals((long)804L, (long)pattern1.length);
        Assert.assertEquals((float)-18.6224f, (float)pattern1[0], (float)1.0E-5f);
        Assert.assertEquals((float)-17.4271f, (float)pattern1[1], (float)1.0E-5f);
        Assert.assertEquals((float)-16.3024f, (float)pattern1[2], (float)1.0E-5f);
        Assert.assertEquals((float)-18.7799f, (float)pattern1[801], (float)1.0E-5f);
        Assert.assertEquals((float)-19.5464f, (float)pattern1[802], (float)1.0E-5f);
        Assert.assertEquals((float)-20.3164f, (float)pattern1[803], (float)1.0E-5f);
        Assert.assertEquals((Object)"-18.6224", (Object)patData.getElemStringAt(0));
    }
}

