/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.envisat.EnvisatProductReader;
import org.esa.snap.dataio.envisat.HeaderEntryNotFoundException;
import org.esa.snap.dataio.envisat.HeaderParseException;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.RecordReader;

public class AatsrL0ProductFile
extends ProductFile {
    private static final String PARSE_SPH_ERR_MSG = "Failed to parse main header parameter '%s': %s";
    private static final String DS_NAME_AATSR_SOURCE_PACKETS = "AATSR_SOURCE_PACKETS";

    AatsrL0ProductFile(File file, ImageInputStream dataInputStream) throws IOException {
        super(file, dataInputStream);
    }

    @Override
    public ProductData.UTC getSceneRasterStartTime() {
        try {
            return this.getMPH().getParamUTC("SENSING_START");
        }
        catch (HeaderEntryNotFoundException | HeaderParseException e) {
            this.getLogger().warning(String.format(PARSE_SPH_ERR_MSG, "SENSING_START", ((Throwable)e).getMessage()));
            return null;
        }
    }

    @Override
    public ProductData.UTC getSceneRasterStopTime() {
        try {
            return this.getMPH().getParamUTC("SENSING_STOP");
        }
        catch (HeaderEntryNotFoundException | HeaderParseException e) {
            this.getLogger().warning(String.format(PARSE_SPH_ERR_MSG, "SENSING_STOP", ((Throwable)e).getMessage()));
            return null;
        }
    }

    @Override
    public int getSceneRasterWidth() {
        return 0;
    }

    @Override
    public int getSceneRasterHeight() {
        return 0;
    }

    @Override
    public float getTiePointGridOffsetX(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointGridOffsetY(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointSubSamplingX(int gridWidth) {
        return 1.0f;
    }

    @Override
    public float getTiePointSubSamplingY(int gridWidth) {
        return 1.0f;
    }

    @Override
    public boolean storesPixelsInChronologicalOrder() {
        return true;
    }

    @Override
    public String getGADSName() {
        return null;
    }

    @Override
    protected void postProcessSPH(Map parameters) throws IOException {
    }

    @Override
    void setInvalidPixelExpression(Band band) {
    }

    @Override
    public float[] getSpectralBandWavelengths() {
        return new float[0];
    }

    @Override
    public float[] getSpectralBandBandwidths() {
        return new float[0];
    }

    @Override
    public float[] getSpectralBandSolarFluxes() {
        return new float[0];
    }

    @Override
    public Mask[] createDefaultMasks(String dsName) {
        return new Mask[0];
    }

    @Override
    protected void addCustomMetadata(Product product) throws IOException {
        MetadataElement root = product.getMetadataRoot();
        String datasetName = DS_NAME_AATSR_SOURCE_PACKETS;
        RecordReader recordReader = this.getRecordReader(datasetName);
        root.addElement(EnvisatProductReader.createMetadataElement(datasetName, recordReader));
    }
}

