/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.snap.dataio.envisat.FieldInfo;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordInfo;

public class RecordInfoTest
extends TestCase {
    public RecordInfoTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(RecordInfoTest.class);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testRecordInfo() {
        try {
            new RecordInfo("TEST");
        }
        catch (IllegalArgumentException e) {
            RecordInfoTest.fail((String)"IllegalArgumentException should not occur");
        }
        try {
            new RecordInfo(null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RecordInfo("");
            RecordInfoTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAdd() {
        RecordInfo recordInfo = new RecordInfo("test");
        try {
            recordInfo.add(null, 20, 4, null, null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected: name must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            recordInfo.add(null, 12349685, 4, null, null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected: illegal data type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            recordInfo.add(null, 20, -4, null, null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected: illegal num elements");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            recordInfo.add((FieldInfo)null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected: field must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            recordInfo.add((RecordInfo)null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected: field must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            recordInfo.add("alpha", 20, 4, null, null);
        }
        catch (IllegalArgumentException e) {
            RecordInfoTest.fail((String)"IllegalArgumentException should not occur");
        }
        try {
            recordInfo.add("ALPHA", 20, 4, null, null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected: name already exists");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetFieldInfo() {
        RecordInfo recordInfo = new RecordInfo("test");
        recordInfo.add("ABC", 10, 4, null, null);
        RecordInfoTest.assertNotNull((Object)recordInfo.getFieldInfo("ABC"));
        RecordInfoTest.assertEquals((String)"ABC", (String)recordInfo.getFieldInfo("abc").getName());
        RecordInfoTest.assertNotNull((Object)recordInfo.getFieldInfo("abc"));
        RecordInfoTest.assertNotNull((Object)recordInfo.getFieldInfo("AbC"));
        RecordInfoTest.assertNull((Object)recordInfo.getFieldInfo("CBA"));
        try {
            recordInfo.getFieldInfo(null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected: name must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetFieldInfoAt() {
        RecordInfo recordInfo = new RecordInfo("test");
        recordInfo.add("ABC", 10, 4, null, null);
        RecordInfoTest.assertNotNull((Object)recordInfo.getFieldInfoAt(0));
        RecordInfoTest.assertEquals((String)"ABC", (String)recordInfo.getFieldInfoAt(0).getName());
        try {
            recordInfo.getFieldInfoAt(1);
            RecordInfoTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetFieldInfoIndex() {
        RecordInfo recordInfo = new RecordInfo("test");
        recordInfo.add("ABC", 10, 4, null, null);
        RecordInfoTest.assertEquals((int)0, (int)recordInfo.getFieldInfoIndex("ABC"));
        RecordInfoTest.assertEquals((int)0, (int)recordInfo.getFieldInfoIndex("abc"));
        RecordInfoTest.assertEquals((int)0, (int)recordInfo.getFieldInfoIndex("AbC"));
        RecordInfoTest.assertEquals((int)-1, (int)recordInfo.getFieldInfoIndex("CBA"));
        try {
            recordInfo.getFieldInfoIndex(null);
            RecordInfoTest.fail((String)"IllegalArgumentException expected: name must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetNumFieldInfos() {
        RecordInfo recordInfo = new RecordInfo("test");
        RecordInfoTest.assertEquals((int)0, (int)recordInfo.getNumFieldInfos());
        recordInfo.add("f1", 10, 4, null, null);
        RecordInfoTest.assertEquals((int)1, (int)recordInfo.getNumFieldInfos());
        recordInfo.add("f2", 10, 4, null, null);
        RecordInfoTest.assertEquals((int)2, (int)recordInfo.getNumFieldInfos());
        recordInfo.add("f3", 10, 4, null, null);
        RecordInfoTest.assertEquals((int)3, (int)recordInfo.getNumFieldInfos());
    }

    public void testGetSizeInBytes() {
        RecordInfo recordInfo = new RecordInfo("test");
        int sib = 0;
        RecordInfoTest.assertEquals((int)sib, (int)recordInfo.getSizeInBytes());
        recordInfo.add("f1", 10, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 4), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f2", 20, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 4), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f3", 11, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 8), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f4", 21, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 8), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f5", 12, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 16), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f6", 22, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 16), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f7", 30, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 16), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f8", 31, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 32), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f9", 51, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 48), (int)recordInfo.getSizeInBytes());
        recordInfo.add("f10", 41, 4, null, null);
        RecordInfoTest.assertEquals((int)(sib += 4), (int)recordInfo.getSizeInBytes());
    }

    public void testCreateRecord() {
        RecordInfo recordInfo = new RecordInfo("test");
        recordInfo.add("f1", 10, 4, null, null);
        recordInfo.add("f2", 20, 4, null, null);
        recordInfo.add("f3", 11, 4, null, null);
        recordInfo.add("f4", 21, 4, null, null);
        recordInfo.add("f5", 12, 4, null, null);
        recordInfo.add("f6", 22, 4, null, null);
        recordInfo.add("f7", 30, 4, null, null);
        recordInfo.add("f8", 31, 4, null, null);
        recordInfo.add("f9", 51, 4, null, null);
        recordInfo.add("f10", 41, 4, null, null);
        Record record = recordInfo.createRecord();
        RecordInfoTest.assertSame((Object)recordInfo, (Object)record.getInfo());
        RecordInfoTest.assertEquals((int)10, (int)record.getNumFields());
        RecordInfoTest.assertEquals((int)156, (int)record.getSizeInBytes());
    }
}

