/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.snap.dataio.envisat.FieldRef;

public class FieldRefTest
extends TestCase {
    public FieldRefTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(FieldRefTest.class);
    }

    public void testParseAndFormat() {
        String fieldRefStr = null;
        FieldRef fieldRef = null;
        fieldRefStr = "Tie_point_GADS.5";
        try {
            fieldRef = FieldRef.parse((String)fieldRefStr);
            FieldRefTest.assertEquals((String)"Tie_point_GADS", (String)fieldRef.getDatasetName());
            FieldRefTest.assertEquals((int)4, (int)fieldRef.getFieldIndex());
            FieldRefTest.assertEquals((int)-1, (int)fieldRef.getElemIndex());
        }
        catch (NumberFormatException e) {
            FieldRefTest.fail((String)e.getMessage());
        }
        FieldRefTest.assertEquals((String)fieldRefStr, (String)fieldRef.format());
        fieldRefStr = "Scaling_factor_GADS.12.9";
        try {
            fieldRef = FieldRef.parse((String)fieldRefStr);
            FieldRefTest.assertEquals((String)"Scaling_factor_GADS", (String)fieldRef.getDatasetName());
            FieldRefTest.assertEquals((int)11, (int)fieldRef.getFieldIndex());
            FieldRefTest.assertEquals((int)8, (int)fieldRef.getElemIndex());
        }
        catch (NumberFormatException e) {
            FieldRefTest.fail((String)e.getMessage());
        }
        FieldRefTest.assertEquals((String)fieldRefStr, (String)fieldRef.format());
        try {
            fieldRef = FieldRef.parse((String)"Scaling_factor_GADS .  12 .  9  ");
            FieldRefTest.assertEquals((String)"Scaling_factor_GADS", (String)fieldRef.getDatasetName());
            FieldRefTest.assertEquals((int)11, (int)fieldRef.getFieldIndex());
            FieldRefTest.assertEquals((int)8, (int)fieldRef.getElemIndex());
            FieldRefTest.assertEquals((String)fieldRefStr, (String)fieldRef.format());
        }
        catch (NumberFormatException e) {
            FieldRefTest.fail((String)e.getMessage());
        }
        FieldRefTest.assertEquals((String)fieldRefStr, (String)fieldRef.format());
        fieldRefStr = "Scaling_factor.GADS.84.152";
        try {
            fieldRef = FieldRef.parse((String)fieldRefStr);
            FieldRefTest.assertEquals((String)"Scaling_factor.GADS", (String)fieldRef.getDatasetName());
            FieldRefTest.assertEquals((int)83, (int)fieldRef.getFieldIndex());
            FieldRefTest.assertEquals((int)151, (int)fieldRef.getElemIndex());
            FieldRefTest.assertEquals((String)fieldRefStr, (String)fieldRef.format());
        }
        catch (NumberFormatException e) {
            FieldRefTest.fail((String)e.getMessage());
        }
        fieldRefStr = "Scaling_factor.GADS.84";
        try {
            fieldRef = FieldRef.parse((String)fieldRefStr);
            FieldRefTest.assertEquals((String)"Scaling_factor.GADS", (String)fieldRef.getDatasetName());
            FieldRefTest.assertEquals((int)83, (int)fieldRef.getFieldIndex());
            FieldRefTest.assertEquals((int)-1, (int)fieldRef.getElemIndex());
            FieldRefTest.assertEquals((String)fieldRefStr, (String)fieldRef.format());
        }
        catch (NumberFormatException e) {
            FieldRefTest.fail((String)e.getMessage());
        }
        String[] malformed = new String[]{".3.4", "x.3a", "x..", "x.0", "x.0.-1"};
        for (int i = 0; i < malformed.length; ++i) {
            try {
                fieldRef = FieldRef.parse((String)malformed[i]);
                FieldRefTest.fail((String)("NumberFormatException expected for '" + malformed[i] + "'"));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

