/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Scanner;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.dataio.envisat.EnvisatProductReader;
import org.esa.snap.dataio.envisat.EnvisatProductReaderPlugIn;
import org.esa.snap.dataio.envisat.ProductFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class EnvisatProductReaderTest {
    private EnvisatProductReaderPlugIn readerPlugIn;

    @Before
    public void setUp() {
        this.readerPlugIn = new EnvisatProductReaderPlugIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testAatsrGeoLocation_UpperRightCorner() throws IOException, URISyntaxException {
        try (EnvisatProductReader reader = (EnvisatProductReader)this.readerPlugIn.createReaderInstance();){
            Product product = reader.readProductNodes((Object)new File(this.getClass().getResource("ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.N1").toURI()), null);
            Assert.assertEquals((long)512L, (long)product.getSceneRasterWidth());
            Assert.assertEquals((long)320L, (long)product.getSceneRasterHeight());
            TiePointGrid latGrid = product.getTiePointGrid("latitude");
            TiePointGrid lonGrid = product.getTiePointGrid("longitude");
            Assert.assertNotNull((Object)latGrid);
            Assert.assertNotNull((Object)lonGrid);
            ProductFile productFile = reader.getProductFile();
            Assert.assertTrue((boolean)productFile.storesPixelsInChronologicalOrder());
            int colCount = 512;
            int rowCount = 320;
            float[] lats = new float[163840];
            float[] lons = new float[163840];
            this.readFloats("image_latgrid_ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.txt", lats);
            this.readFloats("image_longrid_ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.txt", lons);
            GeoPos geoPos = new GeoPos();
            product.getSceneGeoCoding().getGeoPos(new PixelPos(1.0, 0.0), geoPos);
            Assert.assertEquals((double)44.550716400146484, (double)geoPos.getLat(), (double)1.0E-5f);
            Assert.assertEquals((double)32.87879180908203, (double)geoPos.getLon(), (double)1.0E-5f);
            product.getSceneGeoCoding().getGeoPos(new PixelPos(6.0, 0.0), geoPos);
            Assert.assertEquals((double)44.54100799560547, (double)geoPos.getLat(), (double)1.0E-5f);
            Assert.assertEquals((double)32.94025f, (double)geoPos.getLon(), (double)1.0E-5f);
            for (int i = 0; i < 320; ++i) {
                int j = 0;
                int k = 511;
                while (j < 512) {
                    product.getSceneGeoCoding().getGeoPos(new PixelPos((double)((float)j + 1.0f), (double)((float)i + 0.0f)), geoPos);
                    Assert.assertEquals((double)lats[i * 512 + k], (double)geoPos.getLat(), (double)1.2E-5f);
                    Assert.assertEquals((double)lons[i * 512 + k], (double)geoPos.getLon(), (double)1.2E-5f);
                    ++j;
                    --k;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testAatsrGeoLocation_Center() throws IOException, URISyntaxException {
        try (EnvisatProductReader reader = (EnvisatProductReader)this.readerPlugIn.createReaderInstance();){
            Product product = reader.readProductNodes((Object)new File(this.getClass().getResource("ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.N1").toURI()), null);
            Assert.assertEquals((long)512L, (long)product.getSceneRasterWidth());
            Assert.assertEquals((long)320L, (long)product.getSceneRasterHeight());
            TiePointGrid latGrid = product.getTiePointGrid("latitude");
            TiePointGrid lonGrid = product.getTiePointGrid("longitude");
            Assert.assertNotNull((Object)latGrid);
            Assert.assertNotNull((Object)lonGrid);
            ProductFile productFile = reader.getProductFile();
            Assert.assertTrue((boolean)productFile.storesPixelsInChronologicalOrder());
            int colCount = 512;
            int rowCount = 320;
            float[] lats = new float[163840];
            float[] lons = new float[163840];
            this.readFloats("image_latgrid_centre_ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.txt", lats);
            this.readFloats("image_longrid_centre_ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.txt", lons);
            GeoPos geoPos = new GeoPos();
            for (int i = 0; i < 320; ++i) {
                int j = 0;
                int k = 511;
                while (j < 512) {
                    product.getSceneGeoCoding().getGeoPos(new PixelPos((double)((float)j + 0.5f), (double)((float)i + 0.5f)), geoPos);
                    Assert.assertEquals((double)lats[i * 512 + k], (double)geoPos.getLat(), (double)1.2E-5f);
                    Assert.assertEquals((double)lons[i * 512 + k], (double)geoPos.getLon(), (double)1.2E-5f);
                    ++j;
                    --k;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFloats(String resourceName, float[] floats) {
        Scanner scanner = new Scanner(this.getClass().getResourceAsStream(resourceName), "US-ASCII");
        scanner.useLocale(Locale.ENGLISH);
        try {
            for (int i = 0; i < floats.length; ++i) {
                floats[i] = scanner.nextFloat();
            }
        }
        finally {
            scanner.close();
        }
    }
}

