/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import java.util.List;
import org.esa.snap.dataio.envi.EnviCrsFactory;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnviCrsFactoryTest {
    @Test(expected=IllegalArgumentException.class)
    public void testThrowsIllegalArgumentExceptionOnUnregisteredProjection() {
        EnviCrsFactory.createCrs((int)-11, (double[])new double[0], (String)"WGS-84", (String)"Meters");
    }

    @Test
    public void testCreateAlbersEqualAreaConic() {
        double[] parameter = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        CoordinateReferenceSystem crs = EnviCrsFactory.createCrs((int)9, (double[])parameter, (String)"WGS-84", (String)"Meters");
        ParameterValueGroup parameterValues = CRS.getMapProjection((CoordinateReferenceSystem)crs).getParameterValues();
        List valueList = parameterValues.values();
        double[] actualValues = new double[8];
        for (int i = 0; i < valueList.size(); ++i) {
            GeneralParameterValue gPValue = (GeneralParameterValue)valueList.get(i);
            ParameterValue param = parameterValues.parameter(gPValue.getDescriptor().getName().getCode());
            actualValues[i] = param.doubleValue();
        }
        ParameterValue param = parameterValues.parameter("semi_major");
        Assert.assertEquals((double)1.0, (double)param.doubleValue(), (double)1.0E-6);
        param = parameterValues.parameter("semi_minor");
        Assert.assertEquals((double)2.0, (double)param.doubleValue(), (double)1.0E-6);
        param = parameterValues.parameter("latitude_of_origin");
        Assert.assertEquals((double)3.0, (double)param.doubleValue(), (double)1.0E-6);
        param = parameterValues.parameter("central_meridian");
        Assert.assertEquals((double)4.0, (double)param.doubleValue(), (double)1.0E-6);
        param = parameterValues.parameter("false_easting");
        Assert.assertEquals((double)5.0, (double)param.doubleValue(), (double)1.0E-6);
        param = parameterValues.parameter("false_northing");
        Assert.assertEquals((double)6.0, (double)param.doubleValue(), (double)1.0E-6);
        param = parameterValues.parameter("standard_parallel_1");
        Assert.assertEquals((double)7.0, (double)param.doubleValue(), (double)1.0E-6);
        param = parameterValues.parameter("standard_parallel_2");
        Assert.assertEquals((double)8.0, (double)param.doubleValue(), (double)1.0E-6);
    }
}

