/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.Locale;
import org.esa.snap.dataio.envi.EnviMapInfo;
import org.esa.snap.dataio.envi.EnviProjectionInfo;
import org.esa.snap.dataio.envi.Header;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HeaderTest {
    @Before
    public void setUp() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
    }

    @Test
    public void testParseNumSamples() throws IOException {
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader());
        Header header = new Header(in);
        Assert.assertEquals((long)56L, (long)header.getNumSamples());
    }

    @Test
    public void testParseNumLines() throws IOException {
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader());
        Header header = new Header(in);
        Assert.assertEquals((long)105L, (long)header.getNumLines());
    }

    @Test
    public void testParseNumBands() throws IOException {
        int bands = 4;
        String line = "bands =   4\n";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "bands =   4\n");
        Header header = new Header(in);
        Assert.assertEquals((long)4L, (long)header.getNumBands());
    }

    @Test
    public void testParseHeaderOffset() throws IOException {
        int offset = 19523;
        String line = "header offset =   19523\n";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "header offset =   19523\n");
        Header header = new Header(in);
        Assert.assertEquals((long)19523L, (long)header.getHeaderOffset());
    }

    @Test
    public void testParseFileType() throws IOException {
        String type = "toms test type";
        String line = "file type =   toms test type\n";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "file type =   toms test type\n");
        Header header = new Header(in);
        Assert.assertEquals((Object)"toms test type", (Object)header.getFileType());
    }

    @Test
    public void testParseDataType() throws IOException {
        int dataType = 5;
        String line = "data type =   5\n";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "data type =   5\n");
        Header header = new Header(in);
        Assert.assertEquals((long)5L, (long)header.getDataType());
    }

    @Test
    public void testParseInterleave() throws IOException {
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader());
        Header header = new Header(in);
        Assert.assertEquals((Object)"bsq", (Object)header.getInterleave());
    }

    @Test
    public void testParseSensorType() throws IOException {
        String sensorType = "blaberzupp";
        String line = "sensor type =   blaberzupp\n";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "sensor type =   blaberzupp\n");
        Header header = new Header(in);
        Assert.assertEquals((Object)"blaberzupp", (Object)header.getSensorType());
    }

    @Test
    public void testParseSensorType_NoSensorTypeDefined() throws IOException {
        String mandatoryHeader = HeaderTest.createMandatoryHeader();
        BufferedReader in = this.createReader(mandatoryHeader);
        Header header = new Header(in);
        Assert.assertEquals((Object)"Unknown Sensor Type", (Object)header.getSensorType());
    }

    @Test
    public void testParseBigEndianByteOrder() throws IOException {
        boolean bigEndianByteOrder = true;
        String line = "byte order =   1\n";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "byte order =   1\n");
        Header header = new Header(in);
        Assert.assertEquals((long)1L, (long)header.getByteOrder());
        Assert.assertSame((Object)ByteOrder.BIG_ENDIAN, (Object)header.getJavaByteOrder());
    }

    @Test
    public void testParseLittleEndianByteOrder() throws IOException {
        boolean littleEndianByteOrder = false;
        String line = "byte order =   0\n";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "byte order =   0\n");
        Header header = new Header(in);
        Assert.assertEquals((long)0L, (long)header.getByteOrder());
        Assert.assertSame((Object)ByteOrder.LITTLE_ENDIAN, (Object)header.getJavaByteOrder());
    }

    @Test
    public void testParseMapInfo() throws IOException {
        String mapInfoLine = "map info = {testName, 1.0000, 2.0000, 3.0, 4.0, 5.0, 6.0, WGS-62, units=micrometer}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "map info = {testName, 1.0000, 2.0000, 3.0, 4.0, 5.0, 6.0, WGS-62, units=micrometer}");
        Header header = new Header(in);
        EnviMapInfo mapInfo = header.getMapInfo();
        Assert.assertEquals((Object)"testName", (Object)mapInfo.getProjectionName());
        Assert.assertEquals((double)1.0, (double)mapInfo.getReferencePixelX(), (double)1.0E-8);
        Assert.assertEquals((double)2.0, (double)mapInfo.getReferencePixelY(), (double)1.0E-8);
        Assert.assertEquals((double)3.0, (double)mapInfo.getEasting(), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)mapInfo.getNorthing(), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)mapInfo.getPixelSizeX(), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)mapInfo.getPixelSizeY(), (double)1.0E-8);
        Assert.assertEquals((Object)"WGS-62", (Object)mapInfo.getDatum());
        Assert.assertEquals((Object)"micrometer", (Object)mapInfo.getUnit());
        Assert.assertEquals((double)0.0, (double)mapInfo.getOrientation(), (double)1.0E-5);
    }

    @Test
    public void testParseMapInfo_UTM() throws IOException {
        String mapInfoLine = "map info = {UTM, 1.000, 1.000, 691415.705, 5974743.844, 9.3500000000e+01, 9.3500000000e+01, 32, North, WGS-84, units=Meters, rotation=-86.00000000}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "map info = {UTM, 1.000, 1.000, 691415.705, 5974743.844, 9.3500000000e+01, 9.3500000000e+01, 32, North, WGS-84, units=Meters, rotation=-86.00000000}");
        Header header = new Header(in);
        EnviMapInfo mapInfo = header.getMapInfo();
        Assert.assertEquals((Object)"UTM", (Object)mapInfo.getProjectionName());
        Assert.assertEquals((double)1.0, (double)mapInfo.getReferencePixelX(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)mapInfo.getReferencePixelY(), (double)1.0E-8);
        Assert.assertEquals((double)691415.705, (double)mapInfo.getEasting(), (double)1.0E-8);
        Assert.assertEquals((double)5974743.844, (double)mapInfo.getNorthing(), (double)1.0E-8);
        Assert.assertEquals((double)93.5, (double)mapInfo.getPixelSizeX(), (double)1.0E-8);
        Assert.assertEquals((double)93.5, (double)mapInfo.getPixelSizeY(), (double)1.0E-8);
        Assert.assertEquals((long)32L, (long)mapInfo.getUtmZone());
        Assert.assertEquals((Object)"North", (Object)mapInfo.getUtmHemisphere());
        Assert.assertEquals((Object)"WGS-84", (Object)mapInfo.getDatum());
        Assert.assertEquals((Object)"Meters", (Object)mapInfo.getUnit());
        Assert.assertEquals((double)-86.0, (double)mapInfo.getOrientation(), (double)1.0E-5);
    }

    @Test
    public void testParseMapInfo_multipleLines() throws IOException {
        String lines = "map info = {testName, 1.0000, 2.0000,\n 3.0, 4.0, 5.0, 6.0, \nWGS-62, units=micrometer}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "map info = {testName, 1.0000, 2.0000,\n 3.0, 4.0, 5.0, 6.0, \nWGS-62, units=micrometer}");
        Header header = new Header(in);
        EnviMapInfo mapInfo = header.getMapInfo();
        Assert.assertEquals((Object)"testName", (Object)mapInfo.getProjectionName());
        Assert.assertEquals((double)1.0, (double)mapInfo.getReferencePixelX(), (double)1.0E-8);
        Assert.assertEquals((double)2.0, (double)mapInfo.getReferencePixelY(), (double)1.0E-8);
        Assert.assertEquals((double)3.0, (double)mapInfo.getEasting(), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)mapInfo.getNorthing(), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)mapInfo.getPixelSizeX(), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)mapInfo.getPixelSizeY(), (double)1.0E-8);
        Assert.assertEquals((Object)"WGS-62", (Object)mapInfo.getDatum());
        Assert.assertEquals((Object)"micrometer", (Object)mapInfo.getUnit());
    }

    @Test
    public void testParseProjectionInfo() throws IOException {
        String line = "projection info = {9, 6378137.0, 6356752.3, -17.500000, -63.500000, 0.0, 0.0, -32.500000, -2.500000, WGS-84, SamerAlbers, units=Meters}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "projection info = {9, 6378137.0, 6356752.3, -17.500000, -63.500000, 0.0, 0.0, -32.500000, -2.500000, WGS-84, SamerAlbers, units=Meters}");
        Header header = new Header(in);
        EnviProjectionInfo projectionInfo = header.getProjectionInfo();
        Assert.assertEquals((long)9L, (long)projectionInfo.getProjectionNumber());
        double[] parameter = projectionInfo.getParameter();
        Assert.assertEquals((long)8L, (long)parameter.length);
        Assert.assertEquals((double)6378137.0, (double)parameter[0], (double)1.0E-8);
        Assert.assertEquals((double)6356752.3, (double)parameter[1], (double)1.0E-8);
        Assert.assertEquals((double)-17.5, (double)parameter[2], (double)1.0E-8);
        Assert.assertEquals((double)-63.5, (double)parameter[3], (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)parameter[4], (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)parameter[5], (double)1.0E-8);
        Assert.assertEquals((double)-32.5, (double)parameter[6], (double)1.0E-8);
        Assert.assertEquals((double)-2.5, (double)parameter[7], (double)1.0E-8);
        Assert.assertEquals((Object)"WGS-84", (Object)projectionInfo.getDatum());
        Assert.assertEquals((Object)"SamerAlbers", (Object)projectionInfo.getName());
    }

    @Test
    public void testParseProjectionInfo_multipleLines() throws IOException {
        String lines = "projection info = {9, 6378137.0, 6356752.3, \n-17.500000, -63.500000, 0.0, 0.0, \n-32.500000, -2.500000, \nWGS-84, SamerAlbers, units=Meters}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "projection info = {9, 6378137.0, 6356752.3, \n-17.500000, -63.500000, 0.0, 0.0, \n-32.500000, -2.500000, \nWGS-84, SamerAlbers, units=Meters}");
        Header header = new Header(in);
        EnviProjectionInfo projectionInfo = header.getProjectionInfo();
        Assert.assertEquals((long)9L, (long)projectionInfo.getProjectionNumber());
        double[] parameter = projectionInfo.getParameter();
        Assert.assertEquals((long)8L, (long)parameter.length);
        Assert.assertEquals((double)6378137.0, (double)parameter[0], (double)1.0E-8);
        Assert.assertEquals((double)6356752.3, (double)parameter[1], (double)1.0E-8);
        Assert.assertEquals((double)-17.5, (double)parameter[2], (double)1.0E-8);
        Assert.assertEquals((double)-63.5, (double)parameter[3], (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)parameter[4], (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)parameter[5], (double)1.0E-8);
        Assert.assertEquals((double)-32.5, (double)parameter[6], (double)1.0E-8);
        Assert.assertEquals((double)-2.5, (double)parameter[7], (double)1.0E-8);
        Assert.assertEquals((Object)"WGS-84", (Object)projectionInfo.getDatum());
        Assert.assertEquals((Object)"SamerAlbers", (Object)projectionInfo.getName());
    }

    @Test
    public void testParseOffsetValues() throws IOException {
        double[] expectedOffsetValues = new double[]{0.01, 1.45, 0.0367654321};
        String line = String.format("data offset values = {%f,%f,\n%.10f}", expectedOffsetValues[0], expectedOffsetValues[1], expectedOffsetValues[2]);
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + line);
        Header header = new Header(in);
        double[] actualOffsetValues = header.getDataOffsetValues();
        Assert.assertArrayEquals((double[])expectedOffsetValues, (double[])actualOffsetValues, (double)1.0E-10);
    }

    @Test
    public void testParseGainValues() throws IOException {
        double[] expectedOffsetValues = new double[]{10.0, 0.0045, 1.987654321};
        String line = String.format("data gain values = {%f\n,%f,%.10f}", expectedOffsetValues[0], expectedOffsetValues[1], expectedOffsetValues[2]);
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + line);
        Header header = new Header(in);
        double[] actualOffsetValues = header.getDataGainValues();
        Assert.assertArrayEquals((double[])expectedOffsetValues, (double[])actualOffsetValues, (double)1.0E-10);
    }

    @Test
    public void testParseBandNames_empty() throws IOException {
        String line = "band names = {}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "band names = {}");
        Header header = new Header(in);
        String[] bandNames = header.getBandNames();
        Assert.assertEquals((long)0L, (long)bandNames.length);
    }

    @Test
    public void testParseBandNames_noBandnameProperty() throws IOException {
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader());
        Header header = new Header(in);
        String[] bandNames = header.getBandNames();
        Assert.assertNotNull((Object)bandNames);
        Assert.assertEquals((long)0L, (long)bandNames.length);
    }

    @Test
    public void testParseBandNames() throws IOException {
        String line = "band names = {Karl, Fritzi, Petra}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "band names = {Karl, Fritzi, Petra}");
        Header header = new Header(in);
        String[] bandNames = header.getBandNames();
        Assert.assertEquals((long)3L, (long)bandNames.length);
        Assert.assertEquals((Object)"Karl", (Object)bandNames[0]);
        Assert.assertEquals((Object)"Fritzi", (Object)bandNames[1]);
        Assert.assertEquals((Object)"Petra", (Object)bandNames[2]);
    }

    @Test
    public void testParseBandNames_multipleLines() throws IOException {
        String line = "band names = {Hugh, \nGrant, \nJulia, \n Roberts\n}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "band names = {Hugh, \nGrant, \nJulia, \n Roberts\n}");
        Header header = new Header(in);
        String[] bandNames = header.getBandNames();
        Assert.assertEquals((long)4L, (long)bandNames.length);
        Assert.assertEquals((Object)"Hugh", (Object)bandNames[0]);
        Assert.assertEquals((Object)"Grant", (Object)bandNames[1]);
        Assert.assertEquals((Object)"Julia", (Object)bandNames[2]);
        Assert.assertEquals((Object)"Roberts", (Object)bandNames[3]);
    }

    @Test
    public void testParseDescription_WithBeamProperties_SensingStartStop() throws IOException {
        String beamProps = "beamProperties = [sensingStart = 12324, sensingStop = 438976]";
        String description = "any Description\tbeamProperties = [sensingStart = 12324, sensingStop = 438976]\tany other Description";
        String line = "description = {any Description\tbeamProperties = [sensingStart = 12324, sensingStop = 438976]\tany other Description}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "description = {any Description\tbeamProperties = [sensingStart = 12324, sensingStop = 438976]\tany other Description}");
        Header header = new Header(in);
        Assert.assertEquals((Object)"any Description\tbeamProperties = [sensingStart = 12324, sensingStop = 438976]\tany other Description", (Object)header.getDescription());
        Header.BeamProperties beamProperties = header.getBeamProperties();
        Assert.assertNotNull((Object)beamProperties);
        Assert.assertEquals((Object)"12324", (Object)beamProperties.getSensingStart());
        Assert.assertEquals((Object)"438976", (Object)beamProperties.getSensingStop());
    }

    @Test
    public void testParseDescription_WithoutSensingStartStop() throws IOException {
        String noStartStop = "[else other one = 12324; else other two = 438976]";
        String description = "any Description [else other one = 12324; else other two = 438976] any other Description";
        String line = "description = {any Description [else other one = 12324; else other two = 438976] any other Description}";
        BufferedReader in = this.createReader(HeaderTest.createMandatoryHeader() + "description = {any Description [else other one = 12324; else other two = 438976] any other Description}");
        Header header = new Header(in);
        Assert.assertEquals((Object)"any Description [else other one = 12324; else other two = 438976] any other Description", (Object)header.getDescription());
        Assert.assertEquals(null, (Object)header.getBeamProperties());
    }

    static String createMandatoryHeader() {
        int samples = 56;
        int lines = 105;
        int dataType = 5;
        String interleave = "bsq";
        return HeaderTest.createMandatoryHeader(56, 105, 5, "bsq");
    }

    static String createMandatoryHeader(int samples, int lines, int dataType, String interleave) {
        StringBuilder sb = new StringBuilder();
        sb.append("samples = ").append(samples).append("\n");
        sb.append("lines = ").append(lines).append("\n");
        sb.append("data type = ").append(dataType).append("\n");
        sb.append("interleave = ").append(interleave).append("\n");
        return sb.toString();
    }

    private BufferedReader createReader(String line) {
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(line.getBytes())));
    }
}

