/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.envi.EnviProductReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnviProductReaderTest_WithFileIO {
    private File tempDir;

    @Before
    public void setUp() throws Exception {
        String ioTempDir = System.getProperty("java.io.tmpdir");
        this.tempDir = new File(ioTempDir, "tempEnviProductReaderTest");
        if (this.tempDir.exists()) {
            Assert.assertTrue((boolean)FileUtils.deleteTree((File)this.tempDir));
        }
        Assert.assertTrue((boolean)this.tempDir.mkdir());
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertTrue((boolean)FileUtils.deleteTree((File)this.tempDir));
    }

    @Test
    public void testCreateEnviImageFile() throws IOException {
        this.doTest("envifile.hdr", "envifile.img");
        this.doTest("envifile.img.hdr", "envifile.img");
        this.doTest("envifile.hdr", "envifile.IMG");
        this.doTest("envifile.HDR", "envifile.img");
        this.doTest("envifile.HDR", "envifile.IMG");
        this.doTest("envifile.hdr", "envifile.bin");
        this.doTest("envifile.img.hdr", "envifile.bin");
        this.doTest("envifile.bin.hdr", "envifile.bin");
        this.doTest("envifile.hdr", "envifile.bil");
        this.doTest("envifile.bil.hdr", "envifile.bil");
        this.doTest("envifile.hdr", "envifile.bsq");
        this.doTest("envifile.bsq.hdr", "envifile.bsq");
    }

    @Test
    public void testCreateEnviImageFile_mixedCaseExtension() throws IOException {
        this.doTest("envifile.hdr", "envifile.iMg");
        this.doTest("envifile.img.hdr", "envifile.ImG");
    }

    @Test
    public void testCreateEnviImageFile_missingImageFile() throws IOException {
        File hdrFile = new File(this.tempDir, "envi.hdr");
        Assert.assertTrue((boolean)hdrFile.createNewFile());
        try {
            EnviProductReader.getEnviImageFile((File)hdrFile);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("No matching ENVI image file found for header file:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(String hdrFilename, String imgFilename) throws IOException {
        File hdrFile = new File(this.tempDir, hdrFilename);
        Assert.assertTrue((boolean)hdrFile.createNewFile());
        File imgFile = new File(this.tempDir, imgFilename);
        Assert.assertTrue((boolean)imgFile.createNewFile());
        try {
            Assert.assertEquals((Object)imgFile.getCanonicalFile(), (Object)EnviProductReader.getEnviImageFile((File)hdrFile).getCanonicalFile());
        }
        finally {
            imgFile.delete();
            hdrFile.delete();
        }
    }
}

