/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.envi.EnviProductReaderPlugIn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnviProductReaderAcceptanceTest {
    private File headerFile;
    private File imageFile;

    public void not_____testReadCorrectHeaderImgPair() throws IOException {
        StringBuffer headerContent = new StringBuffer();
        headerContent.append("ENVI\n");
        headerContent.append("sensor type = Unknown\n");
        this.writeHeaderFile(headerContent);
        byte[] imageContent = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4};
        this.writeImageFile(imageContent);
        EnviProductReaderPlugIn plugIn = new EnviProductReaderPlugIn();
        ProductReader productReader = plugIn.createReaderInstance();
        Product product = productReader.readProductNodes((Object)this.headerFile, null);
    }

    @Test
    public void testReadHeader_ImgMissing() throws IOException {
        StringBuffer headerContent = new StringBuffer();
        this.writeHeaderFile(headerContent);
        EnviProductReaderPlugIn plugIn = new EnviProductReaderPlugIn();
        ProductReader productReader = plugIn.createReaderInstance();
        try {
            Product product = productReader.readProductNodes((Object)this.headerFile, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Before
    public void setUp() throws Exception {
        this.headerFile = null;
        this.imageFile = null;
    }

    @After
    public void tearDown() throws Exception {
        if (this.headerFile != null && !this.headerFile.delete()) {
            Assert.fail((String)("unable to delete: " + this.headerFile.getCanonicalPath()));
        }
        if (this.imageFile != null && !this.imageFile.delete()) {
            Assert.fail((String)("unable to delete: " + this.imageFile.getCanonicalPath()));
        }
    }

    private void writeHeaderFile(StringBuffer headerContent) throws IOException {
        this.headerFile = new File("test_1.hdr");
        this.headerFile.createNewFile();
        FileOutputStream headerOut = new FileOutputStream(this.headerFile);
        headerOut.write(headerContent.toString().getBytes());
        headerOut.flush();
        headerOut.close();
    }

    private void writeImageFile(byte[] content) throws IOException {
        this.imageFile = new File("test_1.img");
        this.imageFile.createNewFile();
        FileOutputStream headerOut = new FileOutputStream(this.imageFile);
        headerOut.write(content);
        headerOut.flush();
        headerOut.close();
    }
}

