/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.envi.EnviProductReader;
import org.esa.snap.dataio.envi.EnviProductReaderPlugIn;
import org.esa.snap.dataio.envi.Header;
import org.esa.snap.dataio.envi.HeaderTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnviProductReaderTest {
    private static final File TEST_DIR = new File("testDir");
    private static final String MAP_INFO = "SamerAlbers, 1.0000, 1.0000, -479862.9999, 1288756.5614, 8.0000000000e+03,8.0000000000e+03,WGS-84,units=Meters";
    private static final String PROJECTION_INFO = "9, 6378137.0, 6356752.3, -17.500000, 63.500000,-32.500000, -2.500000, 7.0,0.0,WGS-84, SamerAlbers, units=Meters";
    private static final String INTERLEAVE = "Test Interleave";
    private static final String PRODUCT_NAME = "TestProductName";
    private static final String PRODUCT_TYPE = "unknown";
    private static final int WIDTH = 25;
    private static final int HEIGHT = 25;
    private static final int NUM_BANDS = 6;
    private static final int HEADER_OFFSET = 0;
    private static final String FILE_TYPE = "ENVI Standard";
    private static final int DATA_TYPE = 2;
    private static final String SENSOR_TYPE = "unknown";
    private static final int BYTE_ORDER = 1;
    private static final String WAVELENGTH_UNITS = "unknown";

    @Before
    public void setUp() throws Exception {
        FileUtils.deleteTree((File)TEST_DIR);
        TEST_DIR.mkdirs();
    }

    @AfterClass
    public static void tearDownClass() {
        FileUtils.deleteTree((File)TEST_DIR);
    }

    @Test
    public void testParseBandNames_emptyBandnameProperty() throws IOException {
        StringReader reader = new StringReader(HeaderTest.createMandatoryHeader() + "band names = {}");
        Header header = new Header(new BufferedReader(reader));
        String[] bandNames = EnviProductReader.getBandNames((Header)header);
        Assert.assertEquals((long)1L, (long)bandNames.length);
        Assert.assertEquals((Object)"Band", (Object)bandNames[0]);
    }

    @Test
    public void testParseBandNames_noBandnameProperty() throws IOException {
        StringReader reader = new StringReader(HeaderTest.createMandatoryHeader());
        Header header = new Header(new BufferedReader(reader));
        String[] bandNames = EnviProductReader.getBandNames((Header)header);
        Assert.assertEquals((long)1L, (long)bandNames.length);
        Assert.assertEquals((Object)"Band", (Object)bandNames[0]);
    }

    @Test
    public void testParseBandNames_withBandnameProperty() throws IOException {
        StringReader reader = new StringReader(HeaderTest.createMandatoryHeader() + "band names = { myband_1, myband_2}");
        Header header = new Header(new BufferedReader(reader));
        String[] bandNames = EnviProductReader.getBandNames((Header)header);
        Assert.assertEquals((long)2L, (long)bandNames.length);
        Assert.assertEquals((Object)"myband_1", (Object)bandNames[0]);
        Assert.assertEquals((Object)"myband_2", (Object)bandNames[1]);
    }

    @Test
    public void testParseBandNames_withBandNumberProperty() throws IOException {
        StringReader reader = new StringReader(HeaderTest.createMandatoryHeader() + "bands = 3");
        Header header = new Header(new BufferedReader(reader));
        String[] bandNames = EnviProductReader.getBandNames((Header)header);
        Assert.assertEquals((long)3L, (long)bandNames.length);
        Assert.assertEquals((Object)"Band_1", (Object)bandNames[0]);
        Assert.assertEquals((Object)"Band_2", (Object)bandNames[1]);
        Assert.assertEquals((Object)"Band_3", (Object)bandNames[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadProductNodes_WithoutSensingStartStop() throws IOException, ParseException {
        String sensingStartStop = "";
        String headerContent = this.createHeaderFileContent("");
        File headerFile = this.createHeaderAndImageFile(headerContent, PRODUCT_NAME);
        EnviProductReaderPlugIn plugIn = new EnviProductReaderPlugIn();
        ProductReader reader = plugIn.createReaderInstance();
        Product product = reader.readProductNodes((Object)headerFile, null);
        try {
            Assert.assertNotNull((Object)product);
            Assert.assertEquals((Object)PRODUCT_NAME, (Object)product.getName());
            Assert.assertEquals((Object)"unknown", (Object)product.getProductType());
            Assert.assertEquals((long)25L, (long)product.getSceneRasterWidth());
            Assert.assertEquals((long)25L, (long)product.getSceneRasterHeight());
            Assert.assertEquals((long)6L, (long)product.getNumBands());
            Band band1 = product.getBand("data_molly_AVHRR_samer_SA81jul15a_n07_VIg");
            Band band2 = product.getBand("data_molly_AVHRR_samer_SA81jul15b_n07_VIg");
            Band band3 = product.getBand("data_molly_AVHRR_samer_SA81aug15a_n07_VIg");
            Band band4 = product.getBand("data_molly_AVHRR_samer_SA81aug15b_n07_VIg");
            Band band5 = product.getBand("data_molly_AVHRR_samer_SA81sep15a_n07_VIg");
            Band band6 = product.getBand("data_molly_AVHRR_samer_SA81sep15b_n07_VIg");
            Assert.assertNotNull((Object)band1);
            Assert.assertNotNull((Object)band2);
            Assert.assertNotNull((Object)band3);
            Assert.assertNotNull((Object)band4);
            Assert.assertNotNull((Object)band5);
            Assert.assertNotNull((Object)band6);
            Assert.assertEquals((Object)"non formatted band name: _/data/molly/AVHRR/samer/SA81jul15a.n07-VIg", (Object)band1.getDescription());
            Assert.assertEquals((Object)"non formatted band name: /data/molly/AVHRR/samer/SA81jul15b.n07-VIg_", (Object)band2.getDescription());
            Assert.assertEquals((Object)"", (Object)band3.getDescription());
            Assert.assertEquals((Object)"non formatted band name: /data/molly/AVHRR/samer/SA81aug15b.n07-VIg", (Object)band4.getDescription());
            Assert.assertEquals((Object)"non formatted band name: /data/molly/AVHRR/samer/SA81sep15a.n07-VIg", (Object)band5.getDescription());
            Assert.assertEquals((Object)"non formatted band name: /data/molly/AVHRR/samer/SA81sep15b.n07-VIg", (Object)band6.getDescription());
        }
        finally {
            product.dispose();
        }
    }

    @Test
    public void testReadProductNodes_WithInvalidSensingStart() throws IOException {
        String start = "sensingStart";
        String stop = "sensingStop";
        String sensingStartStop = "sensingStart = 238746, sensingStop = 17-feb-1999 6:7:8";
        String headerContent = this.createHeaderFileContent("sensingStart = 238746, sensingStop = 17-feb-1999 6:7:8");
        File headerFile = this.createHeaderAndImageFile(headerContent, PRODUCT_NAME);
        EnviProductReaderPlugIn plugIn = new EnviProductReaderPlugIn();
        ProductReader reader = plugIn.createReaderInstance();
        try {
            reader.readProductNodes((Object)headerFile, null);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("sensingStart"));
        }
    }

    @Test
    public void testReadProductNodes_WithInvalidSensingStop() throws IOException {
        String start = "sensingStart";
        String stop = "sensingStop";
        String sensingStartStop = "sensingStart = 16-jan-1998 5:6:7, sensingStop = jkhadsf";
        String headerContent = this.createHeaderFileContent("sensingStart = 16-jan-1998 5:6:7, sensingStop = jkhadsf");
        File headerFile = this.createHeaderAndImageFile(headerContent, PRODUCT_NAME);
        EnviProductReaderPlugIn plugIn = new EnviProductReaderPlugIn();
        ProductReader reader = plugIn.createReaderInstance();
        try {
            reader.readProductNodes((Object)headerFile, null);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("sensingStop"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadProductNodes_WithValidSensingStartStop() throws IOException {
        String start = "sensingStart";
        String stop = "sensingStop";
        String sensingStartStop = "sensingStart = 16-jan-1998 5:6:7, sensingStop = 17-feb-1999 6:7:8";
        String headerContent = this.createHeaderFileContent("sensingStart = 16-jan-1998 5:6:7, sensingStop = 17-feb-1999 6:7:8");
        File headerFile = this.createHeaderAndImageFile(headerContent, PRODUCT_NAME);
        EnviProductReaderPlugIn plugIn = new EnviProductReaderPlugIn();
        ProductReader reader = plugIn.createReaderInstance();
        Product product = reader.readProductNodes((Object)headerFile, null);
        try {
            Band[] allBands;
            Assert.assertNotNull((Object)product);
            Assert.assertEquals((Object)PRODUCT_NAME, (Object)product.getName());
            Assert.assertEquals((Object)"unknown", (Object)product.getProductType());
            Assert.assertEquals((long)25L, (long)product.getSceneRasterWidth());
            Assert.assertEquals((long)25L, (long)product.getSceneRasterHeight());
            Assert.assertEquals((Object)"16-JAN-1998 05:06:07.000000", (Object)product.getStartTime().format());
            Assert.assertEquals((Object)"17-FEB-1999 06:07:08.000000", (Object)product.getEndTime().format());
            Assert.assertEquals((long)6L, (long)product.getNumBands());
            Band band1 = product.getBand("data_molly_AVHRR_samer_SA81jul15a_n07_VIg");
            Band band2 = product.getBand("data_molly_AVHRR_samer_SA81jul15b_n07_VIg");
            Band band3 = product.getBand("data_molly_AVHRR_samer_SA81aug15a_n07_VIg");
            Band band4 = product.getBand("data_molly_AVHRR_samer_SA81aug15b_n07_VIg");
            Band band5 = product.getBand("data_molly_AVHRR_samer_SA81sep15a_n07_VIg");
            Band band6 = product.getBand("data_molly_AVHRR_samer_SA81sep15b_n07_VIg");
            Assert.assertNotNull((Object)band1);
            Assert.assertNotNull((Object)band2);
            Assert.assertNotNull((Object)band3);
            Assert.assertNotNull((Object)band4);
            Assert.assertNotNull((Object)band5);
            Assert.assertNotNull((Object)band6);
            Assert.assertEquals((Object)"non formatted band name: _/data/molly/AVHRR/samer/SA81jul15a.n07-VIg", (Object)band1.getDescription());
            Assert.assertEquals((Object)"non formatted band name: /data/molly/AVHRR/samer/SA81jul15b.n07-VIg_", (Object)band2.getDescription());
            Assert.assertEquals((Object)"", (Object)band3.getDescription());
            Assert.assertEquals((Object)"non formatted band name: /data/molly/AVHRR/samer/SA81aug15b.n07-VIg", (Object)band4.getDescription());
            Assert.assertEquals((Object)"non formatted band name: /data/molly/AVHRR/samer/SA81sep15a.n07-VIg", (Object)band5.getDescription());
            Assert.assertEquals((Object)"non formatted band name: /data/molly/AVHRR/samer/SA81sep15b.n07-VIg", (Object)band6.getDescription());
            for (Band band : allBands = product.getBands()) {
                Assert.assertTrue((boolean)band.isNoDataValueUsed());
                Assert.assertEquals((double)42.0, (double)band.getNoDataValue(), (double)1.0E-9);
            }
            Assert.assertEquals((double)100.0, (double)band1.getSpectralWavelength(), (double)1.0E-5);
            Assert.assertEquals((double)10.0, (double)band1.getSpectralBandwidth(), (double)1.0E-5);
            Assert.assertEquals((long)1L, (long)product.getIndexCodingGroup().getNodeCount());
            IndexCoding indexCoding = (IndexCoding)product.getIndexCodingGroup().get(0);
            Assert.assertEquals((Object)"classification", (Object)indexCoding.getName());
            Assert.assertArrayEquals((Object[])new String[]{"classA", "classB"}, (Object[])indexCoding.getIndexNames());
        }
        finally {
            product.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadProductNodes_WithoutSensingStop() throws IOException {
        String sensingStartStop = "sensingStart = 16-jan-1998 5:6:7";
        String headerContent = this.createHeaderFileContent("sensingStart = 16-jan-1998 5:6:7");
        File headerFile = this.createHeaderAndImageFile(headerContent, PRODUCT_NAME);
        EnviProductReaderPlugIn plugIn = new EnviProductReaderPlugIn();
        ProductReader reader = plugIn.createReaderInstance();
        Product product = reader.readProductNodes((Object)headerFile, null);
        try {
            Assert.assertNotNull((Object)product);
            Assert.assertEquals((Object)"16-JAN-1998 05:06:07.000000", (Object)product.getStartTime().format());
            Assert.assertEquals(null, (Object)product.getEndTime());
        }
        finally {
            product.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadata() throws IOException {
        String headerContent = this.createHeaderFileContent("");
        File headerFile = this.createHeaderAndImageFile(headerContent, PRODUCT_NAME);
        EnviProductReaderPlugIn plugIn = new EnviProductReaderPlugIn();
        ProductReader reader = plugIn.createReaderInstance();
        Product product = reader.readProductNodes((Object)headerFile, null);
        try {
            Assert.assertNotNull((Object)product);
            MetadataElement metadataRoot = product.getMetadataRoot();
            Assert.assertEquals((long)1L, (long)metadataRoot.getNumElements());
            MetadataElement headerElem = metadataRoot.getElementAt(0);
            Assert.assertNotNull((Object)headerElem);
            Assert.assertEquals((Object)"Header", (Object)headerElem.getName());
            Object[] attributeNames = headerElem.getAttributeNames();
            Object[] expected = new String[]{"description", "samples", "lines", "bands", "header offset", "file type", "data type", "interleave", "sensor type", "byte order", "data ignore value", "map info", "projection info", "wavelength", "fwhm", "wavelength units", "band names", "classes", "class lookup", "class names"};
            Assert.assertArrayEquals((Object[])expected, (Object[])attributeNames);
        }
        finally {
            product.dispose();
        }
    }

    private String createHeaderFileContent(String sensingStartStop) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        pw.println("ENVI");
        pw.println("description = {");
        pw.print("\tENVI File \tCreated [Wed Feb 23 09:36:22 2005]");
        if (sensingStartStop.length() > 0) {
            pw.print("\tbeamProperties = [" + sensingStartStop + "]");
        }
        pw.println("}");
        pw.println("samples = 25");
        pw.println("lines = 25");
        pw.println("bands = 6");
        pw.println("header offset = 0");
        pw.println("file type = ENVI Standard");
        pw.println("data type = 2");
        pw.println("interleave = Test Interleave");
        pw.println("sensor type = unknown");
        pw.println("byte order = 1");
        pw.println("data ignore value = 42");
        pw.println();
        pw.println("map info = {SamerAlbers, 1.0000, 1.0000, -479862.9999, 1288756.5614, 8.0000000000e+03,8.0000000000e+03,WGS-84,units=Meters}");
        pw.println("projection info ={9, 6378137.0, 6356752.3, -17.500000, 63.500000,-32.500000, -2.500000, 7.0,0.0,WGS-84, SamerAlbers, units=Meters}");
        pw.println("wavelength = {100,200,300,400,500,600}");
        pw.println("fwhm = {10,20,30,30,20,10}");
        pw.println("wavelength units = unknown");
        pw.println("band names = {");
        pw.println(" _/data/molly/AVHRR/samer/SA81jul15a.n07-VIg,");
        pw.println(" /data/molly/AVHRR/samer/SA81jul15b.n07-VIg_,");
        pw.println(" data_molly_AVHRR_samer_SA81aug15a_n07_VIg,");
        pw.println(" /data/molly/AVHRR/samer/SA81aug15b.n07-VIg,");
        pw.println(" /data/molly/AVHRR/samer/SA81sep15a.n07-VIg,");
        pw.println(" /data/molly/AVHRR/samer/SA81sep15b.n07-VIg }");
        pw.println("classes = 2");
        pw.println("class lookup = {0,   0,   0, 255,   0,   0}");
        pw.println("class names = {classA, classB}");
        pw.flush();
        return writer.toString();
    }

    private File createHeaderAndImageFile(String headerContent, String headerFileName) throws IOException {
        File headerFile = new File(TEST_DIR, headerFileName + ".hdr");
        File imageFile = new File(TEST_DIR, headerFileName + ".img");
        Assert.assertTrue((boolean)headerFile.createNewFile());
        Assert.assertTrue((boolean)imageFile.createNewFile());
        FileOutputStream outputStream = new FileOutputStream(headerFile);
        outputStream.write(headerContent.getBytes());
        outputStream.close();
        return headerFile;
    }
}

