/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.esa.snap.core.util.SystemUtils;

public class ZipUtils {
    private static final String[] extList = new String[]{".zip", ".gz", ".z"};

    public static boolean isZipped(File file) {
        String name = file.getName().toLowerCase();
        for (String ext : extList) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isZip(File inputFile) {
        return inputFile.getName().toLowerCase().endsWith(".zip");
    }

    public static boolean findInZip(File file, String prefix, String suffix) {
        try {
            ZipFile productZip = new ZipFile(file, 1);
            Optional<ZipEntry> result = productZip.stream().filter(ze -> !ze.isDirectory()).filter(ze -> ze.getName().toLowerCase().endsWith(suffix)).filter(ze -> ze.getName().toLowerCase().startsWith(prefix)).findFirst();
            return result.isPresent();
        }
        catch (Exception e) {
            SystemUtils.LOG.warning("unable to read zip file " + file + ": " + e.getMessage());
            return false;
        }
    }

    public static String getRootFolder(File file, String headerFileName) throws IOException {
        ZipFile productZip = new ZipFile(file, 1);
        Optional<ZipEntry> result = productZip.stream().filter(ze -> !ze.isDirectory()).filter(ze -> ze.getName().toLowerCase().endsWith(headerFileName)).findFirst();
        if (result.isPresent()) {
            ZipEntry ze2 = result.get();
            String path = ze2.toString();
            int sepIndex = path.lastIndexOf(47);
            if (sepIndex > 0) {
                return path.substring(0, sepIndex) + '/';
            }
            return "";
        }
        return "";
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static boolean isValid(File file) {
        try {
            Throwable throwable = null;
            try (ZipFile zipfile = new ZipFile(file);){
                boolean bl;
                Throwable throwable2;
                ZipInputStream zis;
                block64: {
                    block65: {
                        ZipEntry ze;
                        block61: {
                            boolean bl2;
                            block62: {
                                block63: {
                                    zis = new ZipInputStream(new FileInputStream(file));
                                    throwable2 = null;
                                    ze = zis.getNextEntry();
                                    if (ze != null) break block61;
                                    bl2 = false;
                                    if (zis == null) break block62;
                                    if (throwable2 == null) break block63;
                                    try {
                                        zis.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    break block62;
                                }
                                zis.close();
                            }
                            return bl2;
                        }
                        while (true) {
                            if (ze == null) break;
                            try {
                                InputStream in = zipfile.getInputStream(ze);
                                Throwable throwable4 = null;
                                try {
                                    ze.getCrc();
                                    ze.getCompressedSize();
                                    ze = zis.getNextEntry();
                                }
                                catch (Throwable throwable5) {
                                    throwable4 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    if (in == null) continue;
                                    if (throwable4 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable4.addSuppressed(throwable6);
                                        }
                                        continue;
                                    }
                                    in.close();
                                }
                            }
                            catch (IOException e) {
                                boolean bl3 = false;
                                if (zis != null) {
                                    if (throwable2 != null) {
                                        try {
                                            zis.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                    } else {
                                        zis.close();
                                    }
                                }
                                if (zipfile != null) {
                                    if (throwable != null) {
                                        try {
                                            zipfile.close();
                                        }
                                        catch (Throwable throwable8) {
                                            throwable.addSuppressed(throwable8);
                                        }
                                    } else {
                                        zipfile.close();
                                    }
                                }
                                return bl3;
                            }
                        }
                        bl = true;
                        if (zis == null) break block64;
                        if (throwable2 == null) break block65;
                        try {
                            zis.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        break block64;
                    }
                    zis.close();
                }
                return bl;
                catch (Throwable throwable10) {
                    try {
                        try {
                            try {
                                throwable2 = throwable10;
                                throw throwable10;
                            }
                            catch (Throwable throwable11) {
                                if (zis != null) {
                                    if (throwable2 != null) {
                                        try {
                                            zis.close();
                                        }
                                        catch (Throwable throwable12) {
                                            throwable2.addSuppressed(throwable12);
                                        }
                                    } else {
                                        zis.close();
                                    }
                                }
                                throw throwable11;
                            }
                        }
                        catch (IOException e) {
                            boolean bl4 = false;
                            return bl4;
                        }
                    }
                    catch (Throwable throwable13) {
                        throwable = throwable13;
                        throw throwable13;
                    }
                    catch (Throwable throwable14) {
                        throw throwable14;
                    }
                }
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void unzip(Path sourceFile, Path destination, boolean keepFolderStructure) throws IOException {
        if (sourceFile == null || destination == null) {
            throw new IllegalArgumentException("One of the arguments is null");
        }
        if (!Files.exists(destination, new LinkOption[0])) {
            Files.createDirectory(destination, new FileAttribute[0]);
        }
        try (ZipFile zipFile = new ZipFile(sourceFile.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() && !keepFolderStructure) continue;
                Path filePath = destination.resolve(entry.getName());
                Path strippedFilePath = destination.resolve(filePath.getFileName());
                if (Files.exists(filePath, new LinkOption[0])) continue;
                if (entry.isDirectory()) {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                    continue;
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(keepFolderStructure ? filePath.toFile() : strippedFilePath.toFile()));
                    Throwable throwable2 = null;
                    try {
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = inputStream.read(buffer)) > 0) {
                            bos.write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable2 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    public static void zipFile(File file, File outputZipFile) throws IOException {
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(outputZipFile));){
            ZipUtils.addToZipFile(file, zipStream);
        }
    }

    private static void addToZipFile(File file, ZipOutputStream zipStream) {
        try (FileInputStream inputStream = new FileInputStream(file.getPath());){
            int amountRead;
            ZipEntry entry = new ZipEntry(file.getName());
            entry.setCreationTime(FileTime.fromMillis(file.lastModified()));
            zipStream.putNextEntry(entry);
            byte[] readBuffer = new byte[2048];
            int written = 0;
            while ((amountRead = inputStream.read(readBuffer)) > 0) {
                zipStream.write(readBuffer, 0, amountRead);
                written += amountRead;
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("Unable to zip " + file);
        }
    }
}

