/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import com.bc.ceres.core.ProgressMonitor;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

public final class TileGeoreferencing {
    private final GeoCoding geocoding;
    private final int width;
    private final int size;
    private final int x1;
    private final int y1;
    private boolean isCached;
    private double[] latPixels = null;
    private double[] lonPixels = null;
    private final boolean isCrossingMeridian;

    public TileGeoreferencing(Product product, int x1, int y1, int w, int h) {
        this.geocoding = product.getSceneGeoCoding();
        this.isCrossingMeridian = this.geocoding.isCrossingMeridianAt180();
        TiePointGrid latTPG = OperatorUtils.getLatitude(product);
        TiePointGrid lonTPG = OperatorUtils.getLongitude(product);
        this.x1 = x1;
        this.y1 = y1;
        this.width = w;
        this.size = w * h;
        boolean isCrsGeoCoding = this.geocoding instanceof CrsGeoCoding;
        this.isCached = latTPG != null && lonTPG != null || isCrsGeoCoding;
        try {
            if (isCrsGeoCoding) {
                this.latPixels = new double[this.size];
                this.lonPixels = new double[this.size];
                ((CrsGeoCoding)this.geocoding).getPixels(x1, y1, w, h, this.latPixels, this.lonPixels);
            } else {
                if (latTPG != null) {
                    this.latPixels = new double[this.size];
                    latTPG.getPixels(x1, y1, w, h, this.latPixels, ProgressMonitor.NULL);
                }
                if (lonTPG != null) {
                    this.lonPixels = new double[this.size];
                    lonTPG.getPixels(x1, y1, w, h, this.lonPixels, ProgressMonitor.NULL);
                }
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("TileGeoreferencing tiepoint error " + e.getMessage());
            this.isCached = false;
        }
    }

    public void getGeoPos(int x, int y, GeoPos geo) {
        if (this.isCached) {
            int pos;
            int xx = x - this.x1;
            int yy = y - this.y1;
            if (xx >= 0 && yy >= 0 && (pos = yy * this.width + xx) < this.size) {
                geo.setLocation(this.latPixels[pos], this.lonPixels[pos]);
                return;
            }
        }
        this.geocoding.getGeoPos(new PixelPos((double)((float)x + 0.5f), (double)((float)y + 0.5f)), geo);
    }

    public void getGeoPos(PixelPos pix, GeoPos geo) {
        if (this.isCached) {
            int xx = (int)pix.getX() - this.x1;
            int yy = (int)pix.getY() - this.y1;
            int pos = yy * this.width + xx;
            if (xx >= 0 && yy >= 0 && pos < this.size) {
                geo.setLocation(this.latPixels[pos], this.lonPixels[pos]);
                return;
            }
        }
        this.geocoding.getGeoPos(pix, geo);
    }

    public void getPixelPos(GeoPos geo, PixelPos pix) {
        if (this.isCrossingMeridian && geo.lon < 0.0) {
            geo.lon += 360.0;
        }
        this.geocoding.getPixelPos(geo, pix);
    }
}

