/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public final class OperatorUtils {
    public static final String TPG_SLANT_RANGE_TIME = "slant_range_time";
    public static final String TPG_INCIDENT_ANGLE = "incident_angle";
    public static final String TPG_ELEVATION_ANGLE = "elevation_angle";
    public static final String TPG_LATITUDE = "latitude";
    public static final String TPG_LONGITUDE = "longitude";

    public static TiePointGrid getIncidenceAngle(Product sourceProduct) {
        return sourceProduct.getTiePointGrid(TPG_INCIDENT_ANGLE);
    }

    public static TiePointGrid getSlantRangeTime(Product sourceProduct) {
        return sourceProduct.getTiePointGrid(TPG_SLANT_RANGE_TIME);
    }

    public static TiePointGrid getLatitude(Product sourceProduct) {
        return sourceProduct.getTiePointGrid(TPG_LATITUDE);
    }

    public static TiePointGrid getLongitude(Product sourceProduct) {
        return sourceProduct.getTiePointGrid(TPG_LONGITUDE);
    }

    public static String[] getPolarisations(Product product) {
        HashSet<String> polarisationSet = new HashSet<String>();
        for (Band band : product.getBands()) {
            String pol = OperatorUtils.getPolarizationFromBandName(band.getName());
            if (pol == null) continue;
            polarisationSet.add(pol);
        }
        return polarisationSet.toArray(new String[polarisationSet.size()]);
    }

    public static String getBandPolarization(String bandName, MetadataElement absRoot) {
        String pol = OperatorUtils.getPolarizationFromBandName(bandName);
        if (pol != null) {
            return pol;
        }
        if (absRoot != null) {
            String[] mdsPolar = OperatorUtils.getProductPolarization(absRoot);
            return mdsPolar[0];
        }
        return "";
    }

    public static String getPolarizationFromBandName(String bandName) {
        String pol = "";
        String bandNameLower = bandName.toLowerCase();
        if (bandNameLower.contains("_hh")) {
            pol = pol + "hh";
        }
        if (bandNameLower.contains("_vv")) {
            pol = pol + "vv";
        }
        if (bandNameLower.contains("_hv")) {
            pol = pol + "hv";
        }
        if (bandNameLower.contains("_vh")) {
            pol = pol + "vh";
        }
        if (bandNameLower.contains("_rh")) {
            pol = pol + "rh";
        }
        if (bandNameLower.contains("_rv")) {
            pol = pol + "rv";
        }
        if (bandNameLower.contains("_rch")) {
            pol = pol + "rch";
        }
        if (bandNameLower.contains("_rcv")) {
            pol = pol + "rcv";
        }
        if (pol.length() >= 2 && pol.length() <= 3) {
            return pol;
        }
        if (pol.length() > 3) {
            throw new OperatorException("Band name contains multiple polarizations: " + pol);
        }
        return null;
    }

    public static String getSubswathFromBandName(String bandName) {
        String ss = "";
        String bandNameU = bandName.toUpperCase();
        if (bandNameU.contains("_IW")) {
            int idx = bandNameU.indexOf("_IW") + 1;
            return bandNameU.substring(idx, idx + 3);
        }
        if (bandNameU.contains("_EW")) {
            int idx = bandNameU.indexOf("_EW") + 1;
            return bandNameU.substring(idx, idx + 3);
        }
        return "";
    }

    public static String[] getProductPolarization(MetadataElement absRoot) {
        String[] mdsPolar = new String[4];
        for (int i = 0; i < mdsPolar.length; ++i) {
            String polarName = absRoot.getAttributeString(AbstractMetadata.polarTags[i], "").toLowerCase();
            mdsPolar[i] = "";
            if (!polarName.contains("hh") && !polarName.contains("hv") && !polarName.contains("vh") && !polarName.contains("vv")) continue;
            mdsPolar[i] = polarName;
        }
        return mdsPolar;
    }

    public static String getPrefixFromBandName(String bandName) {
        int idx1 = bandName.indexOf(95);
        if (idx1 != -1) {
            return bandName.substring(0, idx1);
        }
        int idx2 = bandName.indexOf(45);
        if (idx2 != -1) {
            return bandName.substring(0, idx2);
        }
        int idx3 = bandName.indexOf(46);
        if (idx3 != -1) {
            return bandName.substring(0, idx3);
        }
        return null;
    }

    public static String getSuffixFromBandName(String bandName) {
        int idx1 = bandName.indexOf(95);
        if (idx1 != -1) {
            return bandName.substring(idx1 + 1);
        }
        int idx2 = bandName.indexOf(45);
        if (idx2 != -1) {
            return bandName.substring(idx2 + 1);
        }
        int idx3 = bandName.indexOf(46);
        if (idx3 != -1) {
            return bandName.substring(idx3 + 1);
        }
        return null;
    }

    public static void copyGCPsToTarget(ProductNodeGroup<Placemark> group, ProductNodeGroup<Placemark> targetGCPGroup, GeoCoding targetGeoCoding) {
        targetGCPGroup.removeAll();
        for (int i = 0; i < group.getNodeCount(); ++i) {
            Placemark sPin = (Placemark)group.get(i);
            Placemark tPin = Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)sPin.getName(), (String)sPin.getLabel(), (String)sPin.getDescription(), (PixelPos)sPin.getPixelPos(), (GeoPos)sPin.getGeoPos(), (GeoCoding)targetGeoCoding);
            targetGCPGroup.add((ProductNode)tPin);
        }
    }

    public static Product createDummyTargetProduct(Product[] sourceProducts) {
        Product targetProduct = new Product(sourceProducts[0].getName(), sourceProducts[0].getProductType(), sourceProducts[0].getSceneRasterWidth(), sourceProducts[0].getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)sourceProducts[0], (Product)targetProduct);
        for (Product prod : sourceProducts) {
            for (Band band : prod.getBands()) {
                ProductUtils.copyBand((String)band.getName(), (Product)prod, (String)band.getName(), (Product)targetProduct, (boolean)false);
            }
        }
        return targetProduct;
    }

    public static String getAcquisitionDate(MetadataElement root) {
        String dateString;
        try {
            ProductData.UTC date = root.getAttributeUTC("first_line_time");
            DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"ddMMMyyyy");
            dateString = dateFormat.format(date.getAsDate());
        }
        catch (Exception e) {
            dateString = "";
        }
        return dateString;
    }

    public static String getAcquisitionTime(MetadataElement root) {
        String dateString;
        try {
            ProductData.UTC time = root.getAttributeUTC("first_line_time");
            DateFormat timeFormat = ProductData.UTC.createDateFormat((String)"yyyyMMdd_HHmmss");
            dateString = timeFormat.format(time.getAsDate());
            dateString = dateString.replace('_', 'T').substring(0, dateString.length() - 2);
        }
        catch (Exception e) {
            dateString = "";
        }
        return dateString;
    }

    public static void createNewTiePointGridsAndGeoCoding(Product sourceProduct, Product targetProduct, int gridWidth, int gridHeight, double subSamplingX, double subSamplingY, PixelPos[] newTiePointPos) {
        TiePointGrid latGrid = null;
        TiePointGrid lonGrid = null;
        for (TiePointGrid srcTPG : sourceProduct.getTiePointGrids()) {
            TiePointGrid tgtTPG;
            TiePointGrid prevTPG;
            float[] tiePoints = new float[gridWidth * gridHeight];
            for (int k = 0; k < newTiePointPos.length; ++k) {
                tiePoints[k] = (float)srcTPG.getPixelDouble(newTiePointPos[k].x, newTiePointPos[k].y);
            }
            int discontinuity = 0;
            if (srcTPG.getName().equals(TPG_LONGITUDE)) {
                discontinuity = 180;
            }
            if ((prevTPG = targetProduct.getTiePointGrid((tgtTPG = new TiePointGrid(srcTPG.getName(), gridWidth, gridHeight, 0.0, 0.0, subSamplingX, subSamplingY, tiePoints, discontinuity)).getName())) != null) {
                targetProduct.removeTiePointGrid(prevTPG);
            }
            targetProduct.addTiePointGrid(tgtTPG);
            if (srcTPG.getName().equals(TPG_LATITUDE)) {
                latGrid = tgtTPG;
                continue;
            }
            if (!srcTPG.getName().equals(TPG_LONGITUDE)) continue;
            lonGrid = tgtTPG;
        }
        TiePointGeoCoding gc = new TiePointGeoCoding(latGrid, lonGrid);
        targetProduct.setSceneGeoCoding((GeoCoding)gc);
    }

    public static Band[] getSourceBands(Product sourceProduct, String[] sourceBandNames, boolean includeVirtualBands) throws OperatorException {
        if (sourceBandNames == null || sourceBandNames.length == 0) {
            Band[] bands = sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                if (band instanceof VirtualBand && !includeVirtualBands) continue;
                bandNameList.add(band.getName());
            }
            sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        ArrayList<Band> sourceBandList = new ArrayList<Band>(sourceBandNames.length);
        for (String sourceBandName : sourceBandNames) {
            Band sourceBand = sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) continue;
            sourceBandList.add(sourceBand);
        }
        return sourceBandList.toArray(new Band[sourceBandList.size()]);
    }

    public static Band[] addBands(Product targetProduct, String[] targetBandNameList, String suffix) {
        ArrayList<Band> bandList = new ArrayList<Band>(targetBandNameList.length);
        for (String targetBandName : targetBandNameList) {
            Band targetBand = new Band(targetBandName + suffix, 30, targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
            if (targetBandName.contains("_real")) {
                targetBand.setUnit("real");
            } else if (targetBandName.contains("_imag")) {
                targetBand.setUnit("imaginary");
            } else {
                targetBand.setUnit("intensity");
            }
            bandList.add(targetBand);
            targetProduct.addBand(targetBand);
        }
        return bandList.toArray(new Band[bandList.size()]);
    }

    public static void catchOperatorException(String opName, Throwable e) throws OperatorException {
        String message = "";
        if (e.getMessage() != null) {
            message = message + e.getMessage();
        }
        if (e.getCause() != null && e.getCause().getMessage() != null && !e.getCause().getMessage().equals(e.getMessage())) {
            message = message + " due to " + e.getCause().getMessage();
        } else if (e.getMessage() == null || e.getMessage().isEmpty()) {
            message = message + e.toString();
            if (e.getCause() != null) {
                message = message + " due to " + e.getCause().toString();
            }
        }
        System.out.println(message);
        throw new OperatorException(message, e);
    }

    public static ImageGeoBoundary computeImageGeoBoundary(Product sourceProduct) throws OperatorException {
        ImageGeoBoundary geoBoundary = new ImageGeoBoundary();
        GeoCoding geoCoding = sourceProduct.getSceneGeoCoding();
        if (geoCoding == null) {
            throw new OperatorException("Product does not contain a geocoding");
        }
        GeoPos geoPosFirstNear = geoCoding.getGeoPos(new PixelPos(0.5, 0.5), null);
        GeoPos geoPosFirstFar = geoCoding.getGeoPos(new PixelPos((double)((float)sourceProduct.getSceneRasterWidth() - 0.5f), 0.5), null);
        GeoPos geoPosLastNear = geoCoding.getGeoPos(new PixelPos(0.5, (double)((float)sourceProduct.getSceneRasterHeight() - 0.5f)), null);
        GeoPos geoPosLastFar = geoCoding.getGeoPos(new PixelPos((double)((float)sourceProduct.getSceneRasterWidth() - 0.5f), (double)((float)sourceProduct.getSceneRasterHeight() - 0.5f)), null);
        double[] lats = new double[]{geoPosFirstNear.getLat(), geoPosFirstFar.getLat(), geoPosLastNear.getLat(), geoPosLastFar.getLat()};
        double[] lons = new double[]{geoPosFirstNear.getLon(), geoPosFirstFar.getLon(), geoPosLastNear.getLon(), geoPosLastFar.getLon()};
        geoBoundary.latMin = 90.0;
        geoBoundary.latMax = -90.0;
        for (double lat : lats) {
            if (lat < geoBoundary.latMin) {
                geoBoundary.latMin = lat;
            }
            if (!(lat > geoBoundary.latMax)) continue;
            geoBoundary.latMax = lat;
        }
        geoBoundary.lonMin = 180.0;
        geoBoundary.lonMax = -180.0;
        for (double lon : lons) {
            if (lon < geoBoundary.lonMin) {
                geoBoundary.lonMin = lon;
            }
            if (!(lon > geoBoundary.lonMax)) continue;
            geoBoundary.lonMax = lon;
        }
        if (geoBoundary.lonMax - geoBoundary.lonMin >= 180.0) {
            geoBoundary.lonMin = 360.0;
            geoBoundary.lonMax = 0.0;
            for (double lon : lons) {
                if (lon < 0.0) {
                    lon += 360.0;
                }
                if (lon < geoBoundary.lonMin) {
                    geoBoundary.lonMin = lon;
                }
                if (!(lon > geoBoundary.lonMax)) continue;
                geoBoundary.lonMax = lon;
            }
        }
        return geoBoundary;
    }

    public static void addSelectedBands(Product sourceProduct, String[] sourceBandNames, Product targetProduct, Map<String, String[]> targetBandNameToSourceBandName, boolean outputIntensity, boolean outputFloat) throws OperatorException {
        Band[] sourceBands = OperatorUtils.getSourceBands(sourceProduct, sourceBandNames, false);
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(sourceProduct);
        boolean isPolsar = absRoot.getAttributeInt("polsar_data", 0) == 1;
        for (int i = 0; i < sourceBands.length; ++i) {
            String targetBandName;
            Band srcBand = sourceBands[i];
            String unit = srcBand.getUnit();
            if (unit == null) {
                unit = "amplitude";
            }
            String targetUnit = "";
            if (unit.contains("imaginary") && outputIntensity && !isPolsar) {
                throw new OperatorException("Real and imaginary bands should be selected in pairs");
            }
            if (unit.contains("real") && outputIntensity && !isPolsar) {
                if (i == sourceBands.length - 1) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                String nextUnit = sourceBands[i + 1].getUnit();
                if (!(nextUnit != null && (unit.equals("real") && nextUnit.equals("imaginary") || unit.equals("imaginary") && nextUnit.equals("real")))) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                String[] srcBandNames = new String[]{srcBand.getName(), sourceBands[i + 1].getName()};
                targetBandName = "Intensity";
                String suff = OperatorUtils.getSuffixFromBandName(srcBandNames[0]);
                if (suff != null) {
                    targetBandName = targetBandName + '_' + suff;
                }
                if (isPolsar) {
                    String pre = OperatorUtils.getPrefixFromBandName(srcBandNames[0]);
                    targetBandName = "Intensity_" + pre;
                }
                ++i;
                if (targetProduct.getBand(targetBandName) == null) {
                    targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
                    targetUnit = "intensity";
                }
            } else {
                String[] srcBandNames = new String[]{srcBand.getName()};
                targetBandName = srcBand.getName();
                if (targetProduct.getBand(targetBandName) == null) {
                    targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
                    targetUnit = unit;
                }
            }
            if (targetProduct.getBand(targetBandName) != null) continue;
            int dataType = srcBand.getDataType();
            if (outputFloat) {
                dataType = 30;
            }
            if (outputIntensity && (dataType == 10 || dataType == 11)) {
                dataType = 12;
            }
            if (outputIntensity && (dataType == 20 || dataType == 21)) {
                dataType = 22;
            }
            Band targetBand = new Band(targetBandName, dataType, targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
            targetBand.setUnit(targetUnit);
            targetBand.setDescription(srcBand.getDescription());
            targetBand.setNoDataValue(srcBand.getNoDataValue());
            targetBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
            targetProduct.addBand(targetBand);
        }
        if (targetProduct.getNumBands() == 0) {
            throw new OperatorException("Target product has no bands");
        }
    }

    public static Rectangle[] getAllTileRectangles(Product sourceProduct, Dimension tileSize, int margin) {
        if (tileSize.getHeight() > (double)sourceProduct.getSceneRasterHeight() || tileSize.getWidth() > (double)sourceProduct.getSceneRasterWidth()) {
            return new Rectangle[]{new Rectangle(0, 0, sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight())};
        }
        int rasterHeight = sourceProduct.getSceneRasterHeight() - margin - margin;
        int rasterWidth = sourceProduct.getSceneRasterWidth() - margin - margin;
        Rectangle boundary = new Rectangle(margin, margin, rasterWidth, rasterHeight);
        int tileCountX = MathUtils.ceilInt((double)((double)boundary.width / (double)tileSize.width));
        int tileCountY = MathUtils.ceilInt((double)((double)boundary.height / (double)tileSize.height));
        Rectangle[] rectangles = new Rectangle[tileCountX * tileCountY];
        int index = 0;
        for (int tileY = 0; tileY < tileCountY; ++tileY) {
            for (int tileX = 0; tileX < tileCountX; ++tileX) {
                Rectangle intersection;
                Rectangle tileRectangle = new Rectangle(tileX * tileSize.width + margin, tileY * tileSize.height + margin, tileSize.width, tileSize.height);
                rectangles[index] = intersection = boundary.intersection(tileRectangle);
                ++index;
            }
        }
        return rectangles;
    }

    public static void computeImageGeoBoundary(Product[] sourceProducts, SceneProperties scnProp) {
        scnProp.latMin = 90.0f;
        scnProp.latMax = -90.0f;
        scnProp.lonMin = 180.0f;
        scnProp.lonMax = -180.0f;
        for (Product srcProd : sourceProducts) {
            GeoCoding geoCoding = srcProd.getSceneGeoCoding();
            GeoPos geoPosFirstNear = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
            GeoPos geoPosFirstFar = geoCoding.getGeoPos(new PixelPos((double)(srcProd.getSceneRasterWidth() - 1), 0.0), null);
            GeoPos geoPosLastNear = geoCoding.getGeoPos(new PixelPos(0.0, (double)(srcProd.getSceneRasterHeight() - 1)), null);
            GeoPos geoPosLastFar = geoCoding.getGeoPos(new PixelPos((double)(srcProd.getSceneRasterWidth() - 1), (double)(srcProd.getSceneRasterHeight() - 1)), null);
            double[] lats = new double[]{geoPosFirstNear.getLat(), geoPosFirstFar.getLat(), geoPosLastNear.getLat(), geoPosLastFar.getLat()};
            double[] lons = new double[]{geoPosFirstNear.getLon(), geoPosFirstFar.getLon(), geoPosLastNear.getLon(), geoPosLastFar.getLon()};
            scnProp.srcCornerLatitudeMap.put(srcProd, lats);
            scnProp.srcCornerLongitudeMap.put(srcProd, lons);
            for (double lat : lats) {
                if (lat < (double)scnProp.latMin) {
                    scnProp.latMin = (float)lat;
                }
                if (!(lat > (double)scnProp.latMax)) continue;
                scnProp.latMax = (float)lat;
            }
            for (double lon : lons) {
                if (lon < (double)scnProp.lonMin) {
                    scnProp.lonMin = (float)lon;
                }
                if (!(lon > (double)scnProp.lonMax)) continue;
                scnProp.lonMax = (float)lon;
            }
        }
    }

    public static void getSceneDimensions(double minSpacing, SceneProperties scnProp) {
        double minAbsLat = scnProp.latMin * scnProp.latMax > 0.0f ? (double)Math.min(Math.abs(scnProp.latMin), Math.abs(scnProp.latMax)) * (Math.PI / 180) : 0.0;
        double delLat = minSpacing / 6371008.7714 * 57.29577951308232;
        double delLon = minSpacing / (6371008.7714 * FastMath.cos((double)minAbsLat)) * 57.29577951308232;
        delLon = delLat = Math.min(delLat, delLon);
        scnProp.sceneWidth = (int)((double)(scnProp.lonMax - scnProp.lonMin) / delLon) + 1;
        scnProp.sceneHeight = (int)((double)(scnProp.latMax - scnProp.latMin) / delLat) + 1;
    }

    public static void addGeoCoding(Product product, SceneProperties scnProp) {
        int sceneWidth = product.getSceneRasterWidth();
        int sceneHeight = product.getSceneRasterHeight();
        double delLon = (scnProp.lonMax - scnProp.lonMin) / (float)(scnProp.sceneWidth - 1);
        double delLat = (scnProp.latMax - scnProp.latMin) / (float)(scnProp.sceneHeight - 1);
        int gridWidth = 11;
        int gridHeight = 11;
        int subSamplingX = (sceneWidth - 1) / 10;
        int subSamplingY = (sceneHeight - 1) / 10;
        float[] latTiePoints = new float[121];
        float[] lonTiePoints = new float[121];
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 11; ++j) {
                latTiePoints[i * 11 + j] = (float)((double)scnProp.latMax - (double)(i * subSamplingY) * delLat);
                lonTiePoints[i * 11 + j] = (float)((double)scnProp.lonMin + (double)(j * subSamplingX) * delLon);
                System.out.print(lonTiePoints[i * 11 + j]);
                System.out.print(" ");
            }
            System.out.println();
        }
        TiePointGrid latGrid = new TiePointGrid(TPG_LATITUDE, 11, 11, 0.5, 0.5, (double)subSamplingX, (double)subSamplingY, latTiePoints);
        latGrid.setUnit("deg");
        TiePointGrid lonGrid = new TiePointGrid(TPG_LONGITUDE, 11, 11, 0.5, 0.5, (double)subSamplingX, (double)subSamplingY, lonTiePoints, 180);
        lonGrid.setUnit("deg");
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid));
    }

    public static class SceneProperties {
        public int sceneWidth;
        public int sceneHeight;
        public float latMin;
        public float lonMin;
        public float latMax;
        public float lonMax;
        public final Map<Product, double[]> srcCornerLatitudeMap = new HashMap<Product, double[]>(10);
        public final Map<Product, double[]> srcCornerLongitudeMap = new HashMap<Product, double[]>(10);
    }

    public static class ImageGeoBoundary {
        public double latMin = 0.0;
        public double latMax = 0.0;
        public double lonMin = 0.0;
        public double lonMax = 0.0;
    }
}

