/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class VectorUtils {
    public static AttributeDescriptorImpl createAttribute(String name, Class<?> binding) {
        NameImpl newAttrName = new NameImpl(name);
        AttributeTypeImpl newAttrType = new AttributeTypeImpl((Name)newAttrName, binding, false, false, null, null, null);
        return new AttributeDescriptorImpl((AttributeType)newAttrType, (Name)newAttrName, 0, 1, true, (Object)" ");
    }

    public static SimpleFeatureType createFeatureType(GeoCoding geoCoding, String vectorNodeName, List<AttributeDescriptor> attributeDescriptors) {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(vectorNodeName);
        ftb.add("geometry", Point.class, geoCoding.getImageCRS());
        ftb.setDefaultGeometry("geometry");
        ftb.addAll(attributeDescriptors);
        return ftb.buildFeatureType();
    }

    public static boolean hasFeatures(VectorDataNode node) {
        DefaultFeatureCollection featureCollection = node.getFeatureCollection();
        return featureCollection != null && !featureCollection.isEmpty();
    }

    public static String[] getAttributesList(Product[] products) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        if (products != null && products.length > 0) {
            ProductNodeGroup vectorGroup = products[0].getVectorDataGroup();
            int numNodes = vectorGroup.getNodeCount();
            for (int i = 0; i < numNodes; ++i) {
                VectorDataNode vectorDataNode = (VectorDataNode)vectorGroup.get(i);
                if (!VectorUtils.hasFeatures(vectorDataNode)) continue;
                DefaultFeatureCollection featureCollection = vectorDataNode.getFeatureCollection();
                SimpleFeature simpleFeature = (SimpleFeature)featureCollection.features().next();
                List attributeDescriptors = simpleFeature.getFeatureType().getAttributeDescriptors();
                for (AttributeDescriptor ad : attributeDescriptors) {
                    if (attributeNames.contains(ad.getLocalName())) continue;
                    attributeNames.add(ad.getLocalName());
                }
            }
        }
        return attributeNames.toArray(new String[attributeNames.size()]);
    }

    public static VectorDataNode[] getPolygonsForOneRectangle(Rectangle rectangle, GeoCoding geoCoding, VectorDataNode[] polygonVectorDataNodes) {
        ArrayList<VectorDataNode> list = new ArrayList<VectorDataNode>();
        ReferencedEnvelope recEnv = new ReferencedEnvelope((Rectangle2D)rectangle, geoCoding.getImageCRS());
        for (VectorDataNode node : polygonVectorDataNodes) {
            try {
                ReferencedEnvelope nodeEnv = node.getEnvelope().transform(geoCoding.getImageCRS(), true);
                if (!recEnv.intersects((Envelope)nodeEnv)) continue;
                list.add(node);
            }
            catch (Exception e) {
                SystemUtils.LOG.severe("Unable to transform vector coordinates: " + e.getMessage());
            }
        }
        VectorDataNode[] array = new VectorDataNode[list.size()];
        array = list.toArray(array);
        return array;
    }

    public static VectorDataNode[] getPolygonsForOneRectangle(Rectangle rectangle, CoordinateReferenceSystem crs, VectorDataNode[] polygonVectorDataNodes) {
        ArrayList<VectorDataNode> list = new ArrayList<VectorDataNode>();
        ReferencedEnvelope recEnv = new ReferencedEnvelope((Rectangle2D)rectangle, crs);
        for (VectorDataNode node : polygonVectorDataNodes) {
            ReferencedEnvelope nodeEnv = node.getEnvelope();
            if (nodeEnv == null) continue;
            try {
                BoundingBox bbox2 = nodeEnv.toBounds(recEnv.getCoordinateReferenceSystem());
                BoundingBox bbox = recEnv.toBounds(nodeEnv.getCoordinateReferenceSystem());
                if (!recEnv.intersects((Envelope)new ReferencedEnvelope(bbox))) continue;
                list.add(node);
            }
            catch (Throwable e) {
                SystemUtils.LOG.info("getPolygonsForOneRectangle: caught exception: " + e.getMessage());
            }
        }
        return list.toArray(new VectorDataNode[list.size()]);
    }

    public static Double getAttribDoubleValue(VectorDataNode node, String attribName) {
        DefaultFeatureCollection featureCollection = node.getFeatureCollection();
        SimpleFeature simpleFeature = (SimpleFeature)featureCollection.features().next();
        String valStr = String.valueOf(simpleFeature.getAttribute(attribName)).trim();
        try {
            return Double.parseDouble(valStr);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static String getAttribStringValue(VectorDataNode node, String attribName) {
        DefaultFeatureCollection featureCollection = node.getFeatureCollection();
        SimpleFeature simpleFeature = (SimpleFeature)featureCollection.features().next();
        String valStr = String.valueOf(simpleFeature.getAttribute(attribName)).trim();
        if (StringUtils.isIntegerString((String)valStr)) {
            valStr = StringUtils.padNum((int)Integer.parseInt(valStr), (int)5, (char)' ');
        } else if (StringUtils.isNumeric((String)valStr, Double.class)) {
            Integer valInt = (int)VectorUtils.quantize(Double.parseDouble(valStr), 0.0, 200.0, 10.0);
            valStr = StringUtils.padNum((int)valInt, (int)5, (char)'0');
        }
        return valStr;
    }

    public static double quantize(double val, double min, double max, double stepSize) {
        double quantizedVal = val;
        quantizedVal = quantizedVal < min ? min : (quantizedVal > max ? max : (double)Math.round(val / stepSize) * stepSize);
        return quantizedVal;
    }
}

