/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel.metadata;

import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataBase;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataInterface;

public final class AbstractMetadata
extends AbstractMetadataBase
implements AbstractMetadataInterface {
    private static final String METADATA_VERSION = "6.0";
    private static final String abstracted_metadata_version = "metadata_version";
    public static final String ABSTRACT_METADATA_ROOT = "Abstracted_Metadata";
    private static final String ORIGINAL_PRODUCT_METADATA = "Original_Product_Metadata";
    public static final String SLAVE_METADATA_ROOT = "Slave_Metadata";
    public static final String MASTER_BANDS = "Master_bands";
    public static final String SLAVE_BANDS = "Slave_bands";
    public static final String product_name = "PRODUCT";
    public static final String product_type = "PRODUCT_TYPE";
    public static final String descriptor = "SPH_DESCRIPTOR";
    public static final String path = "PATH";
    public static final String mission = "MISSION";
    public static final String acquisition_mode = "ACQUISITION_MODE";
    public static final String beams = "BEAMS";
    public static final String annotation = "annotation";
    public static final String band_names = "band_names";
    public static final String swath = "swath";
    public static final String processing_time = "PROC_TIME";
    public static final String processing_system = "Processing_system_identifier";
    public static final String cycle = "orbit_cycle";
    public static final String rel_orbit = "REL_ORBIT";
    public static final String abs_orbit = "ABS_ORBIT";
    public static final String state_vector_time = "STATE_VECTOR_TIME";
    public static final String num_slices = "num_slices";
    public static final String first_line_time = "first_line_time";
    public static final String last_line_time = "last_line_time";
    public static final String line_time_interval = "line_time_interval";
    public static final String first_near_lat = "first_near_lat";
    public static final String first_near_long = "first_near_long";
    public static final String first_far_lat = "first_far_lat";
    public static final String first_far_long = "first_far_long";
    public static final String last_near_lat = "last_near_lat";
    public static final String last_near_long = "last_near_long";
    public static final String last_far_lat = "last_far_lat";
    public static final String last_far_long = "last_far_long";
    public static final String pass = "pass";
    public static final String sample_type = "sample_type";
    public static final String total_size = "total_size";
    public static final String num_output_lines = "num_output_lines";
    public static final String num_samples_per_line = "num_samples_per_line";
    public static final String subset_offset_x = "subset_offset_x";
    public static final String subset_offset_y = "subset_offset_y";
    public static final String map_projection = "map_projection";
    public static final String orbit_state_vectors = "Orbit_State_Vectors";
    public static final String orbit_vector = "orbit_vector";
    public static final String orbit_vector_time = "time";
    public static final String orbit_vector_x_pos = "x_pos";
    public static final String orbit_vector_y_pos = "y_pos";
    public static final String orbit_vector_z_pos = "z_pos";
    public static final String orbit_vector_x_vel = "x_vel";
    public static final String orbit_vector_y_vel = "y_vel";
    public static final String orbit_vector_z_vel = "z_vel";

    public static AbstractMetadata getAbstractedMetadata(Product sourceProduct) {
        MetadataElement root = sourceProduct.getMetadataRoot();
        if (root == null) {
            return null;
        }
        return new AbstractMetadata(root, root.getElement(ABSTRACT_METADATA_ROOT));
    }

    private AbstractMetadata(MetadataElement root, MetadataElement abstractedMetadata) {
        super(root, abstractedMetadata);
    }

    @Override
    protected boolean isCurrentVersion() {
        String version = this.absRoot.getAttributeString(abstracted_metadata_version, "");
        return version.equals(METADATA_VERSION);
    }

    @Override
    protected void migrateToCurrentVersion(MetadataElement abstractedMetadata) {
        if (this.isCurrentVersion()) {
            return;
        }
    }

    @Override
    protected MetadataElement addAbstractedMetadataHeader(MetadataElement root) {
        if (root == null) {
            this.absRoot = new MetadataElement(ABSTRACT_METADATA_ROOT);
        } else {
            this.absRoot = root.getElement(ABSTRACT_METADATA_ROOT);
            if (this.absRoot == null) {
                this.absRoot = new MetadataElement(ABSTRACT_METADATA_ROOT);
                root.addElementAt(this.absRoot, 0);
            }
        }
        AbstractMetadata.addAbstractedAttribute(this.absRoot, product_name, 41, "", "Product name");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, product_type, 41, "", "Product type");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, descriptor, 41, "", "Description");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, mission, 41, "", "Satellite mission");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, acquisition_mode, 41, "", "Acquisition mode");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, beams, 41, "", "Beams used");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, swath, 41, "", "Swath name");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, processing_time, 51, "utc", "Processed time");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, processing_system, 41, "", "Processing system identifier");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, cycle, 12, "", "Cycle");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, rel_orbit, 12, "", "Track");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, abs_orbit, 12, "", "Orbit");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, state_vector_time, 51, "utc", "Time of orbit state vector");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, num_slices, 12, "", "Number of slices");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, first_line_time, 51, "utc", "First zero doppler azimuth time");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, last_line_time, 51, "utc", "Last zero doppler azimuth time");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, line_time_interval, 31, "s", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, first_near_lat, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, first_near_long, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, first_far_lat, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, first_far_long, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, last_near_lat, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, last_near_long, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, last_far_lat, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, last_far_long, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, pass, 41, "", "ASCENDING or DESCENDING");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, sample_type, 41, "", "DETECTED or COMPLEX");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, total_size, 22, "MB", "Total product size");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, num_output_lines, 22, "lines", "Raster height");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, num_samples_per_line, 22, "samples", "Raster width");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, subset_offset_x, 22, "samples", "X coordinate of UL corner of subset in original image");
        AbstractMetadata.addAbstractedAttribute(this.absRoot, subset_offset_y, 22, "samples", "Y coordinate of UL corner of subset in original image");
        this.setAttribute(subset_offset_x, 0);
        this.setAttribute(subset_offset_y, 0);
        AbstractMetadata.addAbstractedAttribute(this.absRoot, map_projection, 41, "", "Map projection applied");
        this.absRoot.addElement(new MetadataElement(orbit_state_vectors));
        MetadataAttribute att = AbstractMetadata.addAbstractedAttribute(this.absRoot, abstracted_metadata_version, 41, "", "AbsMetadata version");
        att.getData().setElems((Object)METADATA_VERSION);
        return this.absRoot;
    }

    public static MetadataElement getOriginalProductMetadata(Product product) {
        MetadataElement root = product.getMetadataRoot();
        MetadataElement origMetadata = root.getElement(ORIGINAL_PRODUCT_METADATA);
        if (origMetadata == null) {
            return root;
        }
        return origMetadata;
    }

    public static MetadataElement addOriginalProductMetadata(Product product) {
        MetadataElement root = product.getMetadataRoot();
        MetadataElement origMetadata = root.getElement(ORIGINAL_PRODUCT_METADATA);
        if (origMetadata == null) {
            origMetadata = new MetadataElement(ORIGINAL_PRODUCT_METADATA);
            root.addElement(origMetadata);
        }
        return origMetadata;
    }

    public static boolean hasAbstractedMetadata(Product sourceProduct) {
        MetadataElement root = sourceProduct.getMetadataRoot();
        if (root == null) {
            return false;
        }
        MetadataElement abstractedMetadata = root.getElement(ABSTRACT_METADATA_ROOT);
        return abstractedMetadata != null;
    }

    public static MetadataElement getSlaveMetadata(Product product) {
        MetadataElement targetRoot = product.getMetadataRoot();
        MetadataElement targetSlaveMetadataRoot = targetRoot.getElement(SLAVE_METADATA_ROOT);
        if (targetSlaveMetadataRoot == null) {
            targetSlaveMetadataRoot = new MetadataElement(SLAVE_METADATA_ROOT);
            targetRoot.addElement(targetSlaveMetadataRoot);
        }
        return targetSlaveMetadataRoot;
    }

    public static MetadataElement addElement(MetadataElement root, String tag) {
        MetadataElement subElemRoot = root.getElement(tag);
        if (subElemRoot == null) {
            subElemRoot = new MetadataElement(tag);
            root.addElement(subElemRoot);
        }
        return subElemRoot;
    }

    @Deprecated
    public static MetadataElement getBandAbsMetadata(MetadataElement root, String bandName, boolean create) {
        String bandElemName = "Band_" + bandName;
        MetadataElement bandElem = root.getElement(bandElemName);
        if (bandElem == null) {
            if (bandName.startsWith("Intensity")) {
                String realBandName = bandName.replace("Intensity_", "i_");
                bandElem = root.getElement("Band_" + realBandName);
            } else if (bandName.startsWith("Phase")) {
                String realBandName = bandName.replace("Phase_", "i_");
                bandElem = root.getElement("Band_" + realBandName);
            }
            if (bandElem == null && create) {
                bandElem = new MetadataElement(bandElemName);
                root.addElement(bandElem);
            }
        }
        return bandElem;
    }

    public OrbitStateVector[] getOrbitStateVectors() {
        MetadataElement elemRoot = this.absRoot.getElement(orbit_state_vectors);
        if (elemRoot == null) {
            return new OrbitStateVector[0];
        }
        int numElems = elemRoot.getNumElements();
        OrbitStateVector[] orbitStateVectors = new OrbitStateVector[numElems];
        for (int i = 0; i < numElems; ++i) {
            OrbitStateVector vector;
            MetadataElement subElemRoot = elemRoot.getElement(orbit_vector + (i + 1));
            orbitStateVectors[i] = vector = new OrbitStateVector(subElemRoot.getAttributeUTC(orbit_vector_time), subElemRoot.getAttributeDouble(orbit_vector_x_pos), subElemRoot.getAttributeDouble(orbit_vector_y_pos), subElemRoot.getAttributeDouble(orbit_vector_z_pos), subElemRoot.getAttributeDouble(orbit_vector_x_vel), subElemRoot.getAttributeDouble(orbit_vector_y_vel), subElemRoot.getAttributeDouble(orbit_vector_z_vel));
        }
        return orbitStateVectors;
    }

    public void setOrbitStateVectors(OrbitStateVector[] orbitStateVectors) throws Exception {
        MetadataElement elemRoot = this.absRoot.getElement(orbit_state_vectors);
        int numElems = elemRoot.getNumElements();
        if (numElems != orbitStateVectors.length) {
            throw new Exception("Length of orbit state vector array is not correct");
        }
        for (int i = 0; i < numElems; ++i) {
            OrbitStateVector vector = orbitStateVectors[i];
            MetadataElement subElemRoot = elemRoot.getElement(orbit_vector + (i + 1));
            subElemRoot.setAttributeUTC(orbit_vector_time, vector.time);
            subElemRoot.setAttributeDouble(orbit_vector_x_pos, vector.x_pos);
            subElemRoot.setAttributeDouble(orbit_vector_y_pos, vector.y_pos);
            subElemRoot.setAttributeDouble(orbit_vector_z_pos, vector.z_pos);
            subElemRoot.setAttributeDouble(orbit_vector_x_vel, vector.x_vel);
            subElemRoot.setAttributeDouble(orbit_vector_y_vel, vector.y_vel);
            subElemRoot.setAttributeDouble(orbit_vector_z_vel, vector.z_vel);
        }
    }
}

