/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import junit.framework.TestCase;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.runtime.Config;
import org.junit.Before;
import org.junit.Test;

public class TestSettings {
    @Before
    public void SetUp() throws IOException {
        Path propFile = SystemUtils.getApplicationHomeDir().toPath().resolve("snap-engine").resolve("etc/snap.auxdata.properties");
        if (!Files.exists(propFile, new LinkOption[0])) {
            propFile = SystemUtils.getApplicationHomeDir().toPath().resolve("../etc/snap.auxdata.properties");
        }
        if (!propFile.toFile().exists()) {
            throw new IOException("Unable to locate snap.auxdata.properties");
        }
        Config.instance((String)"snap.auxdata").load(propFile);
    }

    @Test
    public void testLoadSettings() {
        Settings settings = Settings.instance();
        String value1 = settings.get("AuxData.envisatAuxDataPath");
        String value2 = settings.get("DEM.srtm3GeoTiffDEM_FTP");
    }

    @Test
    public void testGet() {
        String value1 = Settings.instance().get("DEM.srtm3GeoTiffDEM_FTP");
        TestCase.assertEquals((String)"xftp.jrc.it", (String)value1);
    }

    @Test
    public void testGetAuxDataPath() {
        String value2 = Settings.instance().get("AuxDataPath");
        TestCase.assertEquals((String)value2, (String)SystemUtils.getAuxDataPath().toString());
    }

    @Test
    public void testVariableReplacement() {
        String value3 = Settings.instance().get("demPath");
        assert (!value3.contains("AuxDataPath"));
    }

    @Test
    public void testGetAuxDataProperty() {
        Settings settings = Settings.instance();
        String value = settings.get("DEM.srtm3GeoTiffDEM_FTP");
        assert (!value.isEmpty());
    }

    @Test
    public void testNotFound() {
        Settings settings = Settings.instance();
        String value = settings.get("string not found");
        assert (value.isEmpty());
    }
}

