/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.esa.beam.util.io.FileUtils;

public class ZipUtils {
    private static final String[] extList = new String[]{".zip", ".gz", ".z", ".7z"};

    public static boolean isZipped(File file) {
        String name = file.getName().toLowerCase();
        for (String ext : extList) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isZip(File inputFile) {
        return inputFile.getName().toLowerCase().endsWith(".zip");
    }

    public static boolean findInZip(File file, String prefix, String suffix) {
        try {
            ZipFile productZip = new ZipFile(file, 1);
            Optional<ZipEntry> result = productZip.stream().filter(ze -> !ze.isDirectory()).filter(ze -> ze.getName().toLowerCase().endsWith(suffix)).filter(ze -> ze.getName().toLowerCase().startsWith(prefix)).findFirst();
            return result.isPresent();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getRootFolder(File file, String headerFileName) throws IOException {
        ZipFile productZip = new ZipFile(file, 1);
        Optional<ZipEntry> result = productZip.stream().filter(ze -> !ze.isDirectory()).filter(ze -> ze.getName().toLowerCase().endsWith(headerFileName)).findFirst();
        ZipEntry ze2 = result.get();
        String path = ze2.toString();
        int sepIndex = path.lastIndexOf(47);
        if (sepIndex > 0) {
            return path.substring(0, sepIndex) + '/';
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] unzipToFolder(File inFile, File outFolder) throws Exception {
        RandomAccessFile randomAccessFile = new RandomAccessFile(inFile, "r");
        ISevenZipInArchive inArchive = null;
        try {
            inArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
            int[] in = new int[inArchive.getNumberOfItems()];
            for (int i = 0; i < in.length; ++i) {
                in[i] = i;
            }
            ExtractCallback extractCB = new ExtractCallback(inArchive, inFile, outFolder);
            inArchive.extract(in, false, (IArchiveExtractCallback)extractCB);
            File[] fileArray = extractCB.getTargetFiles();
            return fileArray;
        }
        finally {
            if (inArchive != null) {
                inArchive.close();
            }
            randomAccessFile.close();
        }
    }

    public static InputStream unZipToStream(File file) throws Exception {
        return new ZipArchiveInputStream((InputStream)new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream unzipToStream(File file) throws Exception {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        ISevenZipInArchive inArchive = null;
        try {
            inArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
            int numItems = inArchive.getNumberOfItems();
            ISimpleInArchiveItem item = inArchive.getSimpleInterface().getArchiveItem(0);
            InputStream inputStream = new ArchiveInputStreamHandler(item).getInputStream();
            return inputStream;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inArchive != null) {
                inArchive.close();
            }
            randomAccessFile.close();
        }
        return null;
    }

    private static class ExtractCallback
    implements IArchiveExtractCallback {
        private int index;
        private int current = -1;
        private boolean skipExtraction;
        private final ISevenZipInArchive inArchive;
        private final File inFile;
        private final File outFolder;
        private OutputStream out;
        private final File[] targetFiles;

        public ExtractCallback(ISevenZipInArchive inArchive, File inFile, File outFolder) throws SevenZipException {
            this.inArchive = inArchive;
            this.inFile = inFile;
            this.outFolder = outFolder;
            this.targetFiles = new File[inArchive.getNumberOfItems()];
        }

        public File[] getTargetFiles() {
            return this.targetFiles;
        }

        public ISequentialOutStream getStream(final int index, ExtractAskMode extractAskMode) throws SevenZipException {
            this.index = index;
            this.skipExtraction = (Boolean)this.inArchive.getProperty(index, PropID.IS_FOLDER);
            if (this.skipExtraction || extractAskMode != ExtractAskMode.EXTRACT) {
                return null;
            }
            return new ISequentialOutStream(){

                public int write(byte[] data) throws SevenZipException {
                    try {
                        if (index != current) {
                            File target;
                            if (out != null) {
                                out.flush();
                                out.close();
                            }
                            current = index;
                            Object path = inArchive.getProperty(index, PropID.PATH);
                            if (path == null) {
                                path = FileUtils.getFilenameWithoutExtension((File)inFile);
                            }
                            ((ExtractCallback)this).targetFiles[index] = target = new File(outFolder, String.valueOf(path));
                            target.getParentFile().mkdirs();
                            out = new BufferedOutputStream(new FileOutputStream(target));
                        }
                        try {
                            out.write(data, 0, data.length);
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        return data.length;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        }

        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
        }

        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            if (this.skipExtraction) {
                return;
            }
            try {
                this.out.flush();
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (extractOperationResult != ExtractOperationResult.OK) {
                // empty if block
            }
        }

        public void setCompleted(long completeValue) throws SevenZipException {
        }

        public void setTotal(long total) throws SevenZipException {
        }
    }

    private static class ArchiveInputStreamHandler {
        private final ISimpleInArchiveItem item;
        private ByteArrayInputStream arrayInputStream;

        public ArchiveInputStreamHandler(ISimpleInArchiveItem item) {
            this.item = item;
        }

        public InputStream getInputStream() throws SevenZipException {
            this.item.extractSlow(new ISequentialOutStream(){

                public int write(byte[] data) throws SevenZipException {
                    arrayInputStream = new ByteArrayInputStream(data);
                    return data.length;
                }
            });
            return this.arrayInputStream;
        }
    }
}

