/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.internal.DefaultRuntimeConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductSubsetBuilder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.gpf.operators.standard.WriteOp;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.logging.BeamLogManager;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.util.Config;
import org.esa.snap.util.MemUtils;
import org.esa.snap.util.ProductFunctions;
import org.esa.snap.util.ResourceUtils;

public class TestUtils {
    public static final Logger log = BeamLogManager.getSystemLogger();
    private static final String contextID = ResourceUtils.getContextID();
    private static final PropertyMap testPreferences = Config.getAutomatedTestConfigPropertyMap(contextID + ".tests");
    public static final String rootPathTestProducts;
    public static final String rootPathTerraSarX;
    public static final String rootPathASAR;
    public static final String rootPathRadarsat2;
    public static final String rootPathRadarsat1;
    public static final String rootPathSentinel1;
    public static final String rootPathERS;
    public static final String rootPathJERS;
    public static final String rootPathALOS;
    public static final String rootPathCosmoSkymed;
    public static final String rootPathMixProducts;
    private static final int subsetX;
    private static final int subsetY;
    private static final int subsetWidth;
    private static final int subsetHeight;
    private static final int maxIteration;
    private static final String testReadersOnAllProducts;
    private static final String testProcessingOnAllProducts;
    public static final boolean canTestReadersOnAllProducts;
    public static final boolean canTestProcessingOnAllProducts;
    private static final boolean FailOnSkip = false;
    private static final boolean FailOnLargeTestProducts = false;
    private static boolean testEnvironmentInitialized;
    private static final ProductFunctions.ValidProductFileFilter fileFilter;

    public static void initTestEnvironment() {
        if (testEnvironmentInitialized) {
            return;
        }
        try {
            DefaultRuntimeConfig runtimeConfig = new DefaultRuntimeConfig();
            JAI.getDefaultInstance().getTileScheduler().setParallelism(Runtime.getRuntime().availableProcessors());
            MemUtils.configureJaiTileCache();
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            testEnvironmentInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getMaxIterations() {
        return maxIteration;
    }

    public static Product readSourceProduct(String path) throws IOException {
        return TestUtils.readSourceProduct(new File(path));
    }

    public static Product readSourceProduct(File inputFile) throws IOException {
        if (!inputFile.exists()) {
            throw new IOException(inputFile.getAbsolutePath() + " not found");
        }
        ProductReader reader = ProductIO.getProductReaderForInput((Object)inputFile);
        if (reader == null) {
            throw new IOException("No reader found for " + inputFile);
        }
        return reader.readProductNodes((Object)inputFile, null);
    }

    public static Product createProduct(String type, int w, int h) {
        Product product = new Product("name", type, w, h);
        product.setStartTime(AbstractMetadata.parseUTC("10-MAY-2008 20:30:46.890683"));
        product.setEndTime(AbstractMetadata.parseUTC("10-MAY-2008 20:35:46.890683"));
        product.setDescription("description");
        TestUtils.addGeoCoding(product);
        AbstractMetadata.addAbstractedMetadataHeader(product.getMetadataRoot());
        return product;
    }

    public static Band createBand(Product testProduct, String bandName, int w, int h) {
        Band band = testProduct.addBand(bandName, 12);
        band.setUnit("amplitude");
        int[] intValues = new int[w * h];
        for (int i = 0; i < w * h; ++i) {
            intValues[i] = i + 1;
        }
        band.setData(ProductData.createInstance((int[])intValues));
        return band;
    }

    private static void addGeoCoding(Product product) {
        TiePointGrid latGrid = new TiePointGrid("lat", 2, 2, 0.5f, 0.5f, (float)product.getSceneRasterWidth(), (float)product.getSceneRasterHeight(), new float[]{10.0f, 10.0f, 5.0f, 5.0f});
        TiePointGrid lonGrid = new TiePointGrid("lon", 2, 2, 0.5f, 0.5f, (float)product.getSceneRasterWidth(), (float)product.getSceneRasterHeight(), new float[]{10.0f, 10.0f, 5.0f, 5.0f}, TiePointGrid.DISCONT_AT_360);
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid, Datum.WGS_84);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setGeoCoding((GeoCoding)tpGeoCoding);
    }

    public static void verifyProduct(Product product, boolean verifyTimes, boolean verifyGeoCoding) throws Exception {
        TestUtils.verifyProduct(product, verifyTimes, verifyGeoCoding, false);
    }

    public static void verifyProduct(Product product, boolean verifyTimes, boolean verifyGeoCoding, boolean verifyBandData) throws Exception {
        if (product == null) {
            throw new Exception("product is null");
        }
        if (verifyGeoCoding && product.getGeoCoding() == null) {
            log.warning("Geocoding is null for " + product.getFileLocation().getAbsolutePath());
        }
        if (product.getMetadataRoot() == null) {
            throw new Exception("metadataroot is null");
        }
        if (product.getNumBands() == 0) {
            throw new Exception("numbands is zero");
        }
        if (product.getProductType() == null || product.getProductType().isEmpty()) {
            throw new Exception("productType is null");
        }
        if (verifyTimes) {
            if (product.getStartTime() == null) {
                throw new Exception("startTime is null");
            }
            if (product.getEndTime() == null) {
                throw new Exception("endTime is null");
            }
        }
        if (verifyBandData) {
            for (Band b : product.getBands()) {
                if (b.getUnit() == null || b.getUnit().isEmpty()) {
                    throw new Exception("band " + b.getName() + " has null unit");
                }
                int w = b.getSceneRasterWidth();
                int h = b.getSceneRasterHeight();
                boolean allNoData = true;
                for (int y = 0; y < h; ++y) {
                    float[] floatValues = new float[w];
                    b.readPixels(0, y, w, 1, floatValues, ProgressMonitor.NULL);
                    for (float f : floatValues) {
                        if ((double)f == b.getNoDataValue() || f == 0.0f || f == Float.NaN) continue;
                        allNoData = false;
                    }
                }
                if (!allNoData) continue;
                throw new Exception("band " + b.getName() + " is all no data value");
            }
        }
    }

    public static void attributeEquals(MetadataElement elem, String name, double trueValue) throws Exception {
        double val = elem.getAttributeDouble(name, 0.0);
        if (Double.compare(val, trueValue) != 0 && Float.compare((float)val, (float)trueValue) != 0) {
            TestUtils.throwErr(name + " is " + val + ", expecting " + trueValue);
        }
    }

    public static void attributeEquals(MetadataElement elem, String name, String trueValue) throws Exception {
        String val = elem.getAttributeString(name, "");
        if (!val.equals(trueValue)) {
            TestUtils.throwErr(name + " is " + val + ", expecting " + trueValue);
        }
    }

    private static void compareMetadata(Product testProduct, Product expectedProduct, String[] excemptionList) throws Exception {
        MetadataAttribute[] attribList;
        MetadataElement expectedAbsRoot;
        MetadataElement testAbsRoot = AbstractMetadata.getAbstractedMetadata(testProduct);
        if (testAbsRoot == null) {
            TestUtils.throwErr("Metadata is null");
        }
        if ((expectedAbsRoot = AbstractMetadata.getAbstractedMetadata(expectedProduct)) == null) {
            TestUtils.throwErr("Metadata is null");
        }
        if (excemptionList != null) {
            Arrays.sort(excemptionList);
        }
        for (MetadataAttribute expectedAttrib : attribList = expectedAbsRoot.getAttributes()) {
            ProductData expectedData;
            if (excemptionList != null && Arrays.binarySearch(excemptionList, expectedAttrib.getName()) >= 0) continue;
            MetadataAttribute result = testAbsRoot.getAttribute(expectedAttrib.getName());
            if (result == null) {
                TestUtils.throwErr("Metadata attribute " + expectedAttrib.getName() + " is missing");
            }
            if ((expectedData = result.getData()).equalElems(expectedAttrib.getData()) || (expectedData.getType() == 31 || expectedData.getType() == 31) && Double.compare(expectedData.getElemDouble(), result.getData().getElemDouble()) == 0 || expectedData.toString().trim().equalsIgnoreCase(result.getData().toString().trim())) continue;
            TestUtils.throwErr("Metadata attribute " + expectedAttrib.getName() + " expecting " + expectedAttrib.getData().toString() + " got " + result.getData().toString());
        }
    }

    public static void compareProducts(Product targetProduct, Product expectedProduct) throws Exception {
        TestUtils.compareMetadata(targetProduct, expectedProduct, null);
        if (targetProduct.getNumBands() != expectedProduct.getNumBands()) {
            TestUtils.throwErr("Different number of bands");
        }
        if (!targetProduct.isCompatibleProduct(expectedProduct, 0.0f)) {
            TestUtils.throwErr("Geocoding is different");
        }
        for (TiePointGrid tiePointGrid : expectedProduct.getTiePointGrids()) {
            TiePointGrid trgTPG = targetProduct.getTiePointGrid(tiePointGrid.getName());
            if (trgTPG == null) {
                TestUtils.throwErr("TPG " + tiePointGrid.getName() + " not found");
            }
            float[] expectedTiePoints = tiePointGrid.getTiePoints();
            float[] trgTiePoints = trgTPG.getTiePoints();
            if (Arrays.equals(trgTiePoints, expectedTiePoints)) continue;
            TestUtils.throwErr("TPGs are different in file " + expectedProduct.getFileLocation().getAbsolutePath());
        }
        for (TiePointGrid tiePointGrid : expectedProduct.getBands()) {
            Band trgBand = targetProduct.getBand(tiePointGrid.getName());
            if (trgBand == null) {
                TestUtils.throwErr("Band " + tiePointGrid.getName() + " not found");
            }
            float[] floatValues = new float[2500];
            trgBand.readPixels(40, 40, 50, 50, floatValues, ProgressMonitor.NULL);
            float[] expectedValues = new float[2500];
            tiePointGrid.readPixels(40, 40, 50, 50, expectedValues, ProgressMonitor.NULL);
            if (Arrays.equals(floatValues, expectedValues)) continue;
            TestUtils.throwErr("Pixels are different in file " + expectedProduct.getFileLocation().getAbsolutePath());
        }
    }

    public static void compareProducts(Product targetProduct, String expectedPath, String[] excemptionList) throws Exception {
        Band targetBand = targetProduct.getBandAt(0);
        if (targetBand == null) {
            TestUtils.throwErr("targetBand at 0 is null");
        }
        float[] floatValues = new float[2500];
        targetBand.readPixels(40, 40, 50, 50, floatValues, ProgressMonitor.NULL);
        File expectedFile = new File(expectedPath);
        if (!expectedFile.exists()) {
            TestUtils.throwErr("Expected file not found " + expectedFile.toString());
        }
        ProductReader reader2 = ProductIO.getProductReaderForInput((Object)expectedFile);
        Product expectedProduct = reader2.readProductNodes((Object)expectedFile, null);
        Band expectedBand = expectedProduct.getBandAt(0);
        float[] expectedValues = new float[2500];
        expectedBand.readPixels(40, 40, 50, 50, expectedValues, ProgressMonitor.NULL);
        if (!Arrays.equals(floatValues, expectedValues)) {
            TestUtils.throwErr("Pixels are different in file " + expectedPath);
        }
        TestUtils.compareMetadata(targetProduct, expectedProduct, excemptionList);
    }

    public static void executeOperator(Operator op) throws Exception {
        Product targetProduct = op.getTargetProduct();
        TestUtils.verifyProduct(targetProduct, true, true, true);
    }

    public static Product createSubsetProduct(Product sourceProduct) throws IOException {
        int bandWidth = sourceProduct.getSceneRasterWidth();
        int bandHeight = sourceProduct.getSceneRasterHeight();
        ProductSubsetBuilder subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        subsetDef.addNodeNames(sourceProduct.getTiePointGridNames());
        subsetDef.addNodeNames(sourceProduct.getBandNames());
        int w = TestUtils.within(subsetWidth, bandWidth);
        int h = TestUtils.within(subsetHeight, bandHeight);
        subsetDef.setRegion(TestUtils.within(subsetX, bandWidth - w), TestUtils.within(subsetY, bandHeight - h), w, h);
        subsetDef.setIgnoreMetadata(false);
        subsetDef.setTreatVirtualBandsAsRealBands(false);
        Product subsetProduct = subsetReader.readProductNodes((Object)sourceProduct, subsetDef);
        if (subsetProduct.getSceneRasterWidth() > subsetWidth || subsetProduct.getSceneRasterHeight() > subsetHeight) {
            throw new IOException("product size mismatch");
        }
        return subsetProduct;
    }

    public static Product writeSubsetProduct(Product sourceProduct) throws IOException {
        int bandWidth = sourceProduct.getSceneRasterWidth();
        int bandHeight = sourceProduct.getSceneRasterHeight();
        ProductSubsetBuilder subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        subsetDef.addNodeNames(sourceProduct.getTiePointGridNames());
        String bandName = ProductUtils.findSuitableQuicklookBandName((Product)sourceProduct);
        subsetDef.addNodeNames(new String[]{bandName});
        int w = TestUtils.within(subsetWidth, bandWidth);
        int h = TestUtils.within(subsetHeight, bandHeight);
        subsetDef.setRegion(TestUtils.within(subsetX, bandWidth - w), TestUtils.within(subsetY, bandHeight - h), w, h);
        subsetDef.setIgnoreMetadata(false);
        subsetDef.setTreatVirtualBandsAsRealBands(true);
        Product subsetProduct = subsetReader.readProductNodes((Object)sourceProduct, subsetDef);
        File tmpFile = new File(ResourceUtils.getApplicationUserTempDataDir(), "tmp_subset.dim");
        WriteOp writer = new WriteOp(subsetProduct, tmpFile, "BEAM-DIMAP");
        writer.writeProduct(ProgressMonitor.NULL);
        return ProductIO.readProduct((File)tmpFile);
    }

    private static int within(int val, int max) {
        return Math.max(0, Math.min(val, max));
    }

    public static void recurseFindReadableProducts(File origFolder, ArrayList<File> productList, int maxCount) throws Exception {
        File[] fileList;
        File[] folderList;
        for (File folder : folderList = origFolder.listFiles(ProductFunctions.directoryFileFilter)) {
            if (folder.getName().contains("skipTest")) continue;
            TestUtils.recurseFindReadableProducts(folder, productList, maxCount);
        }
        for (File file : fileList = origFolder.listFiles(new ProductFunctions.ValidProductFileFilter())) {
            if (maxCount > 0 && productList.size() >= maxCount) {
                return;
            }
            try {
                ProductReader reader = ProductIO.getProductReaderForInput((Object)file);
                if (reader != null) {
                    productList.add(file);
                    continue;
                }
                log.warning(file.getAbsolutePath() + " is non valid");
            }
            catch (Exception e) {
                boolean ok = false;
                if (ok) continue;
                log.severe("Failed to process " + file.toString());
                throw e;
            }
        }
    }

    public static int recurseProcessFolder(OperatorSpi spi, File origFolder, int iterations, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        File[] fileList;
        File[] folderList;
        for (File folder : folderList = origFolder.listFiles(ProductFunctions.directoryFileFilter)) {
            if (maxIteration > 0 && iterations >= maxIteration) break;
            if (folder.getName().contains("skipTest")) continue;
            iterations = TestUtils.recurseProcessFolder(spi, folder, iterations, productTypeExemptions, exceptionExemptions);
        }
        for (File file : fileList = origFolder.listFiles(new ProductFunctions.ValidProductFileFilter())) {
            if (maxIteration > 0 && iterations >= maxIteration) break;
            try {
                ProductReader reader = ProductIO.getProductReaderForInput((Object)file);
                if (reader != null) {
                    Product sourceProduct = reader.readProductNodes((Object)file, null);
                    if (productTypeExemptions != null && TestUtils.containsProductType(productTypeExemptions, sourceProduct.getProductType())) continue;
                    TestUtils.verifyProduct(sourceProduct, true, true, false);
                    Product subsetProduct = TestUtils.createSubsetProduct(sourceProduct);
                    Operator op = spi.createOperator();
                    op.setSourceProduct(subsetProduct);
                    log.info(spi.getOperatorAlias() + " Processing " + file.toString());
                    TestUtils.executeOperator(op);
                    ++iterations;
                    continue;
                }
                log.warning(file.getAbsolutePath() + " is non valid");
            }
            catch (Exception e) {
                boolean ok = false;
                if (exceptionExemptions != null) {
                    for (String exemption : exceptionExemptions) {
                        if (!e.getMessage().contains(exemption)) continue;
                        ok = true;
                        log.info("Exemption for " + e.getMessage());
                        break;
                    }
                }
                if (ok) continue;
                log.severe("Failed to process " + file.toString());
                throw e;
            }
        }
        return iterations;
    }

    public static boolean containsProductType(String[] productTypeExemptions, String productType) {
        if (productTypeExemptions != null) {
            for (String str : productTypeExemptions) {
                if (!productType.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static void testProcessAllInPath(OperatorSpi spi, String folderPath, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            TestUtils.skipTest(spi, folderPath + " not found");
            return;
        }
        if (canTestProcessingOnAllProducts) {
            int iterations = 0;
            TestUtils.recurseProcessFolder(spi, folder, iterations, productTypeExemptions, exceptionExemptions);
        }
    }

    public static void recurseReadFolder(File origFolder, ProductReaderPlugIn readerPlugin, ProductReader reader, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        TestUtils.recurseReadFolder(origFolder, readerPlugin, reader, productTypeExemptions, exceptionExemptions, 0);
    }

    public static int recurseReadFolder(File origFolder, ProductReaderPlugIn readerPlugin, ProductReader reader, String[] productTypeExemptions, String[] exceptionExemptions, int iterations) throws Exception {
        File[] files;
        File[] folderList;
        for (File folder : folderList = origFolder.listFiles(ProductFunctions.directoryFileFilter)) {
            if (folder.getName().contains("skipTest")) continue;
            iterations = TestUtils.recurseReadFolder(folder, readerPlugin, reader, productTypeExemptions, exceptionExemptions, iterations);
            if (maxIteration <= 0 || iterations < maxIteration) continue;
            return iterations;
        }
        for (File file : files = origFolder.listFiles(fileFilter)) {
            if (readerPlugin.getDecodeQualification((Object)file) != DecodeQualification.INTENDED) continue;
            try {
                log.info("Reading " + file.toString());
                Product product = reader.readProductNodes((Object)file, null);
                if (productTypeExemptions != null && TestUtils.containsProductType(productTypeExemptions, product.getProductType())) continue;
                TestUtils.verifyProduct(product, true, true, false);
                if (maxIteration <= 0 || ++iterations < maxIteration) continue;
                break;
            }
            catch (Exception e) {
                boolean ok = false;
                if (exceptionExemptions != null) {
                    for (String excemption : exceptionExemptions) {
                        if (e.getMessage() == null || !e.getMessage().contains(excemption)) continue;
                        ok = true;
                        log.info("Excemption for " + e.getMessage());
                        break;
                    }
                }
                if (ok) continue;
                log.severe("Failed to read " + file.toString());
                throw e;
            }
        }
        return iterations;
    }

    public static boolean skipTest(Object obj) throws Exception {
        return TestUtils.skipTest(obj, "");
    }

    public static boolean skipTest(Object obj, String msg) throws Exception {
        log.severe(obj.getClass().getName() + " skipped " + msg);
        return true;
    }

    private static void throwErr(String description) throws Exception {
        throw new Exception(description);
    }

    static {
        if (testPreferences != null) {
            rootPathTestProducts = testPreferences.getPropertyString(contextID + ".test.rootPathTestProducts");
            rootPathTerraSarX = testPreferences.getPropertyString(contextID + ".test.rootPathTerraSarX");
            rootPathASAR = testPreferences.getPropertyString(contextID + ".test.rootPathASAR");
            rootPathRadarsat2 = testPreferences.getPropertyString(contextID + ".test.rootPathRadarsat2");
            rootPathRadarsat1 = testPreferences.getPropertyString(contextID + ".test.rootPathRadarsat1");
            rootPathSentinel1 = testPreferences.getPropertyString(contextID + ".test.rootPathSentinel1");
            rootPathERS = testPreferences.getPropertyString(contextID + ".test.rootPathERS");
            rootPathJERS = testPreferences.getPropertyString(contextID + ".test.rootPathJERS");
            rootPathALOS = testPreferences.getPropertyString(contextID + ".test.rootPathALOS");
            rootPathCosmoSkymed = testPreferences.getPropertyString(contextID + ".test.rootPathCosmoSkymed");
            rootPathMixProducts = testPreferences.getPropertyString(contextID + ".test.rootPathMixProducts");
            subsetX = Integer.parseInt(testPreferences.getPropertyString(contextID + ".test.subsetX"));
            subsetY = Integer.parseInt(testPreferences.getPropertyString(contextID + ".test.subsetY"));
            subsetWidth = Integer.parseInt(testPreferences.getPropertyString(contextID + ".test.subsetWidth"));
            subsetHeight = Integer.parseInt(testPreferences.getPropertyString(contextID + ".test.subsetHeight"));
            maxIteration = Integer.parseInt(testPreferences.getPropertyString(contextID + ".test.maxProductsPerRootFolder"));
            testReadersOnAllProducts = testPreferences.getPropertyString(contextID + ".test.ReadersOnAllProducts");
            testProcessingOnAllProducts = testPreferences.getPropertyString(contextID + ".test.ProcessingOnAllProducts");
            canTestReadersOnAllProducts = testReadersOnAllProducts != null && testReadersOnAllProducts.equalsIgnoreCase("true");
            canTestProcessingOnAllProducts = testProcessingOnAllProducts != null && testProcessingOnAllProducts.equalsIgnoreCase("true");
        } else {
            rootPathTestProducts = "";
            rootPathTerraSarX = "";
            rootPathASAR = "";
            rootPathRadarsat2 = "";
            rootPathRadarsat1 = "";
            rootPathSentinel1 = "";
            rootPathERS = "";
            rootPathJERS = "";
            rootPathALOS = "";
            rootPathCosmoSkymed = "";
            rootPathMixProducts = "";
            subsetX = 0;
            subsetY = 0;
            subsetWidth = 0;
            subsetHeight = 0;
            maxIteration = 0;
            testReadersOnAllProducts = "";
            testProcessingOnAllProducts = "";
            canTestReadersOnAllProducts = false;
            canTestProcessingOnAllProducts = false;
        }
        testEnvironmentInitialized = false;
        fileFilter = new ProductFunctions.ValidProductFileFilter(false);
    }
}

