/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import java.io.File;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.SystemUtils;
import org.esa.snap.util.Config;
import org.esa.snap.util.ResourceUtils;

public final class Settings {
    private static Settings _instance = null;
    private final PropertyMap auxdataConfig = new PropertyMap();

    public static Settings instance() {
        if (_instance == null) {
            _instance = new Settings();
        }
        return _instance;
    }

    private Settings() {
        Config.load(this.auxdataConfig, new File(SystemUtils.getApplicationHomeDir(), "config" + File.separator + SystemUtils.getApplicationContextId() + ".auxdata.config"));
    }

    public static boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("win");
    }

    private static String resolve(PropertyMap prop, String value) {
        String settingStr;
        String env;
        int idx1 = value.indexOf("${");
        int idx2 = value.indexOf(125) + 1;
        String keyWord = value.substring(idx1 + 2, idx2 - 1);
        String fullKey = value.substring(idx1, idx2);
        String property = System.getProperty(keyWord);
        String out = property != null && property.length() > 0 ? value.replace(fullKey, property) : ((env = null) != null && env.length() > 0 ? value.replace(fullKey, env) : ((settingStr = prop.getPropertyString(keyWord)) != null && settingStr.length() > 0 ? value.replace(fullKey, settingStr) : (keyWord.equalsIgnoreCase(ResourceUtils.getContextID() + ".home") || keyWord.equalsIgnoreCase("NEST_HOME") ? value.replace(fullKey, ResourceUtils.findHomeFolder().getAbsolutePath()) : value.replace(fullKey, keyWord))));
        if (out.contains("${")) {
            out = Settings.resolve(prop, out);
        }
        return out;
    }

    public String get(String key) {
        String val = this.auxdataConfig.getPropertyString(key);
        if (val != null && val.contains("${")) {
            val = Settings.resolve(this.auxdataConfig, val);
        }
        return val;
    }

    public PropertyMap getAuxdataProperty() {
        return this.auxdataConfig;
    }

    public static File getAuxDataFolder() {
        String auxDataPath = Settings.instance().get("AuxDataPath");
        if (auxDataPath == null) {
            auxDataPath = Settings.instance().get("dataPath");
        }
        if (auxDataPath == null) {
            return new File(SystemUtils.getApplicationDataDir((boolean)true), "AuxData");
        }
        return new File(auxDataPath);
    }
}

