/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import com.bc.ceres.core.runtime.internal.RuntimeActivator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.esa.beam.util.SystemUtils;

public final class ResourceUtils {
    public static ImageIcon rstbIcon = ResourceUtils.LoadIcon("org/esa/snap/icons/csa.png");
    public static ImageIcon arrayIcon = ResourceUtils.LoadIcon("org/esa/snap/icons/array_logo.png");
    public static ImageIcon esaIcon = ResourceUtils.LoadIcon("org/esa/snap/icons/esa.png");
    public static ImageIcon esaPlanetIcon = ResourceUtils.LoadIcon("org/esa/snap/icons/esa-planet.png");
    public static ImageIcon geoAusIcon = ResourceUtils.LoadIcon("org/esa/snap/icons/geo_aus.png");

    public static ImageIcon LoadIcon(String path) {
        URL imageURL = ResourceUtils.class.getClassLoader().getResource(path);
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            for (String aChild : file.list()) {
                ResourceUtils.deleteFile(new File(file, aChild));
            }
        }
        if (!file.delete()) {
            System.out.println("Could not delete " + file.getName());
        }
    }

    public static Properties loadProperties(String filename) throws IOException {
        InputStream dbPropInputStream = ResourceUtils.getResourceAsStream(filename);
        Properties dbProperties = new Properties();
        try {
            dbProperties.load(dbPropInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return dbProperties;
    }

    public static InputStream getResourceAsStream(String filename) throws IOException {
        return ResourceUtils.getResourceAsStream(filename, ResourceUtils.class);
    }

    public static InputStream getResourceAsStream(String filename, Class theClass) throws IOException {
        InputStream stream = ClassLoader.getSystemResourceAsStream(filename);
        if (stream != null) {
            return stream;
        }
        URL resURL = theClass.getClassLoader().getResource(filename);
        if (resURL != null) {
            return theClass.getClassLoader().getResourceAsStream(filename);
        }
        return new FileInputStream(filename);
    }

    public static File getApplicationUserDir(boolean forceCreate) {
        File dir = new File(SystemUtils.getUserHomeDir(), '.' + ResourceUtils.getContextID());
        if (forceCreate && !dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static String getContextID() {
        if (RuntimeActivator.getInstance() != null && RuntimeActivator.getInstance().getModuleContext() != null) {
            return RuntimeActivator.getInstance().getModuleContext().getRuntimeConfig().getContextId();
        }
        return System.getProperty("ceres.context", "unknown");
    }

    public static String getHomeUrl() {
        return System.getProperty(ResourceUtils.getContextID() + ".home", ".");
    }

    public static File getApplicationUserTempDataDir() {
        File tmpDir = new File(ResourceUtils.getApplicationUserDir(true), "temp");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return tmpDir;
    }

    public static File getGraphFolder(String subFolder) {
        return new File(ResourceUtils.getHomeUrl(), File.separator + "graphs" + File.separator + subFolder);
    }

    public static File getResFolder() {
        return new File(ResourceUtils.getHomeUrl(), "resource");
    }

    public static File findConfigFile(String filename) {
        String homeDir = System.getProperty(ResourceUtils.getContextID() + ".home");
        if (homeDir != null && homeDir.length() > 0) {
            File homeDirFile = new File(homeDir);
            String homeDirStr = homeDirFile.getAbsolutePath();
            String settingsfilePath = homeDirStr + File.separator + "config" + File.separator + filename;
            File outFile2 = new File(settingsfilePath);
            if (outFile2.exists()) {
                return outFile2;
            }
            int idx = homeDirStr.lastIndexOf(File.separator);
            settingsfilePath = homeDirStr.substring(0, idx) + File.separator + "config" + File.separator + filename;
            File outFile3 = new File(settingsfilePath);
            if (outFile3.exists()) {
                return outFile3;
            }
        }
        File homeFolder = ResourceUtils.findHomeFolder();
        return new File(homeFolder, "config" + File.separator + filename);
    }

    public static File findHomeFolder() {
        String nestHome = System.getProperty(ResourceUtils.getContextID() + ".home");
        File homePath = nestHome == null ? SystemUtils.getApplicationHomeDir() : new File(nestHome);
        String homePathStr = homePath.getAbsolutePath();
        if (homePathStr.endsWith(".") && homePathStr.length() > 1) {
            homePathStr = homePathStr.substring(0, homePathStr.lastIndexOf(File.separator));
        }
        return new File(homePathStr);
    }

    public static void sortFileList(File[] filelist) {
        DirAlphaComparator byDirThenAlpha = new DirAlphaComparator();
        Arrays.sort(filelist, byDirThenAlpha);
    }

    private static class DirAlphaComparator
    implements Comparator<File> {
        private DirAlphaComparator() {
        }

        @Override
        public int compare(File filea, File fileb) {
            if (filea.isDirectory() && !fileb.isDirectory()) {
                return -1;
            }
            if (!filea.isDirectory() && fileb.isDirectory()) {
                return 1;
            }
            return filea.getName().compareToIgnoreCase(fileb.getName());
        }
    }
}

