/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReader;

public class ProductFunctions {
    private static final String[] validExtensions = new String[]{".dim", ".n1", ".e1", ".e2", ".h5"};
    private static final String[] xmlPrefix = new String[]{"product", "tsx1_sar", "tsx2_sar", "tdx1_sar", "tdx2_sar"};
    private static final String[] nonValidExtensions = new String[]{"xsd", "xsl", "xls", "pdf", "txt", "doc", "ps", "db", "ief", "ord", "tfw", "gif", "jpg", "jgw", "hdr", "self", "report", "raw", "tgz", "log", "html", "htm", "png", "bmp", "ps", "aux", "ovr", "brs", "kml", "kmz", "sav", "7z", "rrd", "lbl", "z", "gz", "exe", "so", "dll", "bat", "sh", "rtf", "prj", "dbf", "shx", "shp", "ace", "ace2", "tar", "tooldes", "metadata.xml"};
    private static final String[] nonValidprefixes = new String[]{"led", "trl", "tra_", "nul", "lea", "dat", "img", "imop", "sarl", "sart", "par_", "dfas", "dfdn", "lut", "readme", "l1b_iif", "dor_vor", "imagery_", "browse"};
    public static final DirectoryFileFilter directoryFileFilter = new DirectoryFileFilter();

    public static boolean isValidProduct(File file) {
        String name = file.getName().toLowerCase();
        for (String str : validExtensions) {
            if (!name.endsWith(str)) continue;
            return true;
        }
        if (name.endsWith("xml")) {
            for (String str : xmlPrefix) {
                if (!name.startsWith(str)) continue;
                return true;
            }
            return false;
        }
        ProductReader reader = ProductIO.getProductReaderForInput((Object)file);
        return reader != null;
    }

    public static void scanForValidProducts(File inputFolder, ArrayList<String> pathList) {
        File[] files;
        ValidProductFileFilter dirFilter = new ValidProductFileFilter();
        for (File file : files = inputFolder.listFiles(dirFilter)) {
            if (file.isDirectory()) {
                ProductFunctions.scanForValidProducts(file, pathList);
                continue;
            }
            if (!ProductFunctions.isValidProduct(file)) continue;
            pathList.add(file.getAbsolutePath());
        }
    }

    public static class DirectoryFileFilter
    implements FileFilter {
        static final String[] skip = new String[]{"annotation", "measurement", "auxraster", "auxfiles", "imagedata", "preview", "support", "quality", "source_images", "schemas"};

        @Override
        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            String name = file.getName().toLowerCase();
            if (name.endsWith(".data")) {
                return false;
            }
            if (name.endsWith("safe")) {
                return true;
            }
            for (String ext : skip) {
                if (!name.equalsIgnoreCase(ext)) continue;
                return false;
            }
            return true;
        }
    }

    public static class ValidProductFileFilter
    implements FileFilter {
        private final boolean includeFolders;

        public ValidProductFileFilter() {
            this.includeFolders = false;
        }

        public ValidProductFileFilter(boolean includeFolders) {
            this.includeFolders = includeFolders;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return this.includeFolders;
            }
            String name = file.getName().toLowerCase();
            for (String ext : validExtensions) {
                if (!name.endsWith(ext)) continue;
                return !name.startsWith("asa_wss");
            }
            for (String pre : nonValidprefixes) {
                if (!name.startsWith(pre)) continue;
                return false;
            }
            for (String ext : nonValidExtensions) {
                if (!name.endsWith(ext)) continue;
                return false;
            }
            return true;
        }
    }
}

