/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import Jama.Matrix;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.datamodel.PosVector;

public final class Maths {
    private Maths() {
    }

    public static double interpolationLinear(double y0, double y1, double mu) {
        return (1.0 - mu) * y0 + mu * y1;
    }

    public static double interpolationCubic(double y0, double y1, double y2, double y3, double mu) {
        double mu2 = mu * mu;
        double a0 = -0.5 * y0 + 1.5 * y1 - 1.5 * y2 + 0.5 * y3;
        double a1 = y0 - 2.5 * y1 + 2.0 * y2 - 0.5 * y3;
        double a2 = -0.5 * y0 + 0.5 * y2;
        return a0 * mu * mu2 + a1 * mu2 + a2 * mu + y1;
    }

    public static double interpolationCubic2(double y0, double y1, double y2, double y3, double mu) {
        double mu2 = mu * mu;
        double a0 = y3 - y2 - y0 + y1;
        double a1 = y0 - y1 - a0;
        double a2 = y2 - y0;
        return a0 * mu * mu2 + a1 * mu2 + a2 * mu + y1;
    }

    public static double interpolationSinc(double y0, double y1, double y2, double y3, double y4, double mu) {
        int filterLength = 5;
        double f0 = Maths.sinc(mu + 2.0) * Maths.hanning(mu + 2.0, 5);
        double f1 = Maths.sinc(mu + 1.0) * Maths.hanning(mu + 1.0, 5);
        double f2 = Maths.sinc(mu + 0.0) * Maths.hanning(mu + 0.0, 5);
        double f3 = Maths.sinc(mu - 1.0) * Maths.hanning(mu - 1.0, 5);
        double f4 = Maths.sinc(mu - 2.0) * Maths.hanning(mu - 2.0, 5);
        double sum = f0 + f1 + f2 + f3 + f4;
        return (f0 * y0 + f1 * y1 + f2 * y2 + f3 * y3 + f4 * y4) / sum;
    }

    public static double interpolationBiLinear(double v00, double v01, double v10, double v11, double muX, double muY) {
        return (1.0 - muY) * ((1.0 - muX) * v00 + muX * v01) + muY * ((1.0 - muX) * v10 + muX * v11);
    }

    public static double interpolationBiCubic(double[][] v, double muX, double muY) {
        return Maths.interpolationCubic(Maths.interpolationCubic(v[0][0], v[0][1], v[0][2], v[0][3], muX), Maths.interpolationCubic(v[1][0], v[1][1], v[1][2], v[1][3], muX), Maths.interpolationCubic(v[2][0], v[2][1], v[2][2], v[2][3], muX), Maths.interpolationCubic(v[3][0], v[3][1], v[3][2], v[3][3], muX), muY);
    }

    public static double interpolationBiCubic2(double[][] v, double muX, double muY) {
        return Maths.interpolationCubic2(Maths.interpolationCubic2(v[0][0], v[0][1], v[0][2], v[0][3], muX), Maths.interpolationCubic2(v[1][0], v[1][1], v[1][2], v[1][3], muX), Maths.interpolationCubic2(v[2][0], v[2][1], v[2][2], v[2][3], muX), Maths.interpolationCubic2(v[3][0], v[3][1], v[3][2], v[3][3], muX), muY);
    }

    public static double interpolationBiSinc(double[][] v, double muX, double muY) {
        double tmpV0 = Maths.interpolationSinc(v[0][0], v[0][1], v[0][2], v[0][3], v[0][4], muX);
        double tmpV1 = Maths.interpolationSinc(v[1][0], v[1][1], v[1][2], v[1][3], v[1][4], muX);
        double tmpV2 = Maths.interpolationSinc(v[2][0], v[2][1], v[2][2], v[2][3], v[2][4], muX);
        double tmpV3 = Maths.interpolationSinc(v[3][0], v[3][1], v[3][2], v[3][3], v[3][4], muX);
        double tmpV4 = Maths.interpolationSinc(v[4][0], v[4][1], v[4][2], v[4][3], v[4][4], muX);
        return Maths.interpolationSinc(tmpV0, tmpV1, tmpV2, tmpV3, tmpV4, muY);
    }

    public static double[] lagrangeWeight(double[] pos, double desiredPos) {
        int length = pos.length;
        if (desiredPos < pos[0] || desiredPos > pos[length - 1]) {
            double time = desiredPos - (double)((int)desiredPos);
            double[] timeArray = new double[length];
            for (int i = 0; i < length; ++i) {
                timeArray[i] = pos[i] - (double)((int)pos[i]);
            }
            return Maths.computeWeight(timeArray, time);
        }
        return Maths.computeWeight(pos, desiredPos);
    }

    private static double[] computeWeight(double[] pos, double desiredPos) {
        int length = pos.length;
        double[] weight = new double[length];
        for (int i = 0; i < length; ++i) {
            double weightVal = 1.0;
            for (int j = 0; j < length; ++j) {
                if (j == i) continue;
                weightVal *= (desiredPos - pos[j]) / (pos[i] - pos[j]);
            }
            weight[i] = weightVal;
        }
        return weight;
    }

    public static void lagrangeInterpolatingPolynomial(double[] xVal, double[] yVal, double[] zVal, double[] weight, PosVector vector) {
        vector.x = 0.0;
        vector.y = 0.0;
        vector.z = 0.0;
        for (int i = 0; i < xVal.length; ++i) {
            vector.x += weight[i] * xVal[i];
            vector.y += weight[i] * yVal[i];
            vector.z += weight[i] * zVal[i];
        }
    }

    public static double lagrangeInterpolatingPolynomial(double[] pos, double[] val, double desiredPos) {
        double retVal = 0.0;
        int length = pos.length;
        for (int i = 0; i < length; ++i) {
            double weight = 1.0;
            for (int j = 0; j < length; ++j) {
                if (j == i) continue;
                weight *= (desiredPos - pos[j]) / (pos[i] - pos[j]);
            }
            retVal += weight * val[i];
        }
        return retVal;
    }

    public static double lagrangeEightOrderInterpolation(double[] samples, double x) {
        double out = 0.0;
        double[] denominators = new double[]{40320.0, -5040.0, 1440.0, -720.0, 576.0, -720.0, 1440.0, -5040.0, 40320.0};
        double numerator = x * (x - 1.0) * (x - 2.0) * (x - 3.0) * (x - 4.0) * (x - 5.0) * (x - 6.0) * (x - 7.0) * (x - 8.0);
        if (numerator == 0.0) {
            return samples[(int)Math.round(x)];
        }
        for (int i = 0; i < samples.length; ++i) {
            double coeff = numerator / denominators[i] / (x - (double)i);
            out += coeff * samples[i];
        }
        return out;
    }

    public static Matrix createVandermondeMatrix(double[] d, int warpPolynomialOrder) {
        int n = d.length;
        double[][] array = new double[n][warpPolynomialOrder + 1];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= warpPolynomialOrder; ++j) {
                array[i][j] = Math.pow(d[i], j);
            }
        }
        return new Matrix(array);
    }

    private static double sinc(double x) {
        if (Double.compare(x, 0.0) == 0) {
            return 1.0;
        }
        return FastMath.sin((double)(x * Math.PI)) / (x * Math.PI);
    }

    public static double hanning(double x, int windowLength) {
        if (x >= -0.5 * (double)windowLength && x <= 0.5 * (double)windowLength) {
            return 0.5 * (1.0 + FastMath.cos((double)(Math.PI * 2 * x / (double)(windowLength + 1))));
        }
        return 0.0;
    }

    public static double computePolynomialValue(double x, double[] coeff) {
        double v = 0.0;
        for (int i = coeff.length - 1; i > 0; --i) {
            v = (v + coeff[i]) * x;
        }
        return v + coeff[0];
    }

    public static void normalizeVector(double[] v) {
        double norm = Math.sqrt(Maths.innerProduct(v, v));
        v[0] = v[0] / norm;
        v[1] = v[1] / norm;
        v[2] = v[2] / norm;
    }

    public static double innerProduct(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static double[] polyFit(double[] t, double[] y, int degree) {
        Matrix A = Maths.createVandermondeMatrix(t, degree);
        Matrix b = new Matrix(y, y.length);
        Matrix x = A.solve(b);
        return x.getColumnPackedCopy();
    }

    public static double polyVal(double t, double[] coeff) {
        double val = 0.0;
        for (int i = coeff.length - 1; i >= 0; --i) {
            val = val * t + coeff[i];
        }
        return val;
    }
}

