/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.logging.BeamLogManager;

public class Config {
    private final PropertyMap appConfig = new PropertyMap();
    private final Map<String, PropertyMap> testPrefs = new HashMap<String, PropertyMap>(10);
    private static Config _instance = null;

    public static Config instance() {
        if (_instance == null) {
            _instance = new Config();
        }
        return _instance;
    }

    private Config() {
        Config.load(this.appConfig, new File(SystemUtils.getApplicationHomeDir(), "config" + File.separator + SystemUtils.getApplicationContextId() + ".config"));
    }

    public static void load(PropertyMap propMap, File file) {
        if (!file.exists()) {
            BeamLogManager.getSystemLogger().severe(file.getAbsolutePath() + " not found");
        }
        try {
            propMap.load(file);
        }
        catch (IOException e) {
            BeamLogManager.getSystemLogger().severe("Unable to load application config " + e.getMessage());
        }
    }

    private void loadTestConfigs() {
        File[] testFiles;
        for (File testFile : testFiles = Config.getTestFiles(new File(SystemUtils.getApplicationHomeDir(), "config"))) {
            try {
                PropertyMap testPref = new PropertyMap();
                testPref.load(testFile);
                this.testPrefs.put(testFile.getName(), testPref);
            }
            catch (IOException e) {
                BeamLogManager.getSystemLogger().severe("Unable to load test config " + e.getMessage());
            }
        }
    }

    private static File[] getTestFiles(File folder) {
        ArrayList<File> testFiles = new ArrayList<File>(10);
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().toLowerCase().endsWith(".tests")) continue;
                testFiles.add(file);
            }
        }
        return testFiles.toArray(new File[testFiles.size()]);
    }

    public static PropertyMap getAppConfigPropertyMap() {
        return Config.instance().appConfig;
    }

    public static PropertyMap getAutomatedTestConfigPropertyMap(String name) {
        if (Config.instance().testPrefs.isEmpty()) {
            Config.instance().loadTestConfigs();
        }
        return Config.instance().testPrefs.get(name);
    }
}

