/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import com.bc.ceres.core.ProgressMonitor;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.snap.gpf.OperatorUtils;

public final class TileGeoreferencing {
    final TiePointGrid latTPG;
    final TiePointGrid lonTPG;
    final GeoCoding geocoding;
    final int width;
    final int x1;
    final int y1;
    final int size;
    boolean isCached;
    float[] latPixels = null;
    float[] lonPixels = null;
    final boolean isCrossingMeridian;

    public TileGeoreferencing(Product product, int x1, int y1, int w, int h) {
        this.geocoding = product.getGeoCoding();
        this.isCrossingMeridian = this.geocoding.isCrossingMeridianAt180();
        this.latTPG = OperatorUtils.getLatitude(product);
        this.lonTPG = OperatorUtils.getLongitude(product);
        this.x1 = x1;
        this.y1 = y1;
        this.width = w;
        this.size = w * h;
        boolean isCrsGeoCoding = this.geocoding instanceof CrsGeoCoding;
        this.isCached = this.latTPG != null && this.lonTPG != null || isCrsGeoCoding;
        try {
            if (isCrsGeoCoding) {
                this.latPixels = new float[this.size];
                this.lonPixels = new float[this.size];
                ((CrsGeoCoding)this.geocoding).getPixels(x1, y1, w, h, this.latPixels, this.lonPixels);
            } else {
                if (this.latTPG != null) {
                    this.latPixels = new float[this.size];
                    this.latTPG.getPixels(x1, y1, w, h, this.latPixels, ProgressMonitor.NULL);
                }
                if (this.lonTPG != null) {
                    this.lonPixels = new float[this.size];
                    this.lonTPG.getPixels(x1, y1, w, h, this.lonPixels, ProgressMonitor.NULL);
                }
            }
        }
        catch (Exception e) {
            System.out.println("TileGeoreferencing tiepoint error " + e.getMessage());
            this.isCached = false;
        }
    }

    public void getGeoPos(int x, int y, GeoPos geo) {
        if (this.isCached) {
            int pos;
            int xx = x - this.x1;
            int yy = y - this.y1;
            if (xx >= 0 && yy >= 0 && (pos = yy * this.width + xx) < this.size) {
                geo.setLocation(this.latPixels[pos], this.lonPixels[pos]);
                return;
            }
        }
        this.geocoding.getGeoPos(new PixelPos((float)x + 0.5f, (float)y + 0.5f), geo);
    }

    public void getGeoPos(PixelPos pix, GeoPos geo) {
        if (this.isCached) {
            int xx = (int)pix.getX() - this.x1;
            int yy = (int)pix.getY() - this.y1;
            int pos = yy * this.width + xx;
            if (xx >= 0 && yy >= 0 && pos < this.size) {
                geo.setLocation(this.latPixels[pos], this.lonPixels[pos]);
                return;
            }
        }
        this.geocoding.getGeoPos(pix, geo);
    }

    public void getPixelPos(GeoPos geo, PixelPos pix) {
        if (this.isCrossingMeridian && geo.lon < 0.0f) {
            geo.lon += 360.0f;
        }
        this.geocoding.getPixelPos(geo, pix);
    }
}

