/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import java.util.ArrayList;
import java.util.List;

public class ThreadManager {
    private static int numCPU = Runtime.getRuntime().availableProcessors();
    private final List<Thread> threadList = new ArrayList<Thread>(numCPU);

    public void add(Thread worker) throws InterruptedException {
        this.threadList.add(worker);
        worker.start();
        if (this.threadList.size() >= numCPU) {
            for (Thread t : this.threadList) {
                t.join();
            }
            this.threadList.clear();
        }
    }

    public void finish() throws InterruptedException {
        if (!this.threadList.isEmpty()) {
            for (Thread t : this.threadList) {
                t.join();
            }
        }
    }

    public static void setNumCPU(int numCPU) {
        ThreadManager.numCPU = numCPU;
    }
}

