/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import com.bc.ceres.core.ProgressMonitor;
import org.esa.snap.gpf.ProgressMonitorList;
import org.esa.snap.gpf.StatusPresenter;

public final class StatusProgressMonitor {
    private final StatusPresenter statusPresenter;
    private final float max;
    private final String msg;
    private int lastPct = 0;
    private boolean allowStdOut = true;
    private int workInc = 0;

    public StatusProgressMonitor(float max, String msg) {
        this(null, max, msg);
    }

    public StatusProgressMonitor(StatusPresenter presenter, float max, String msg) {
        this.statusPresenter = presenter;
        this.max = max;
        this.msg = msg;
    }

    public synchronized void workedOne() {
        ++this.workInc;
        this.worked(this.workInc);
    }

    private boolean hasGUI() {
        return this.statusPresenter != null || !ProgressMonitorList.instance().isEmpty();
    }

    public synchronized void worked(int i) {
        int pct;
        if (this.hasGUI()) {
            int pct2 = (int)((float)i / this.max * 100.0f);
            if (pct2 >= this.lastPct + 1) {
                this.setText(this.msg + pct2 + '%');
                this.lastPct = pct2;
            }
        } else if (this.allowStdOut && (pct = (int)((float)i / this.max * 100.0f)) >= this.lastPct + 10) {
            if (this.lastPct == 0) {
                System.out.print(this.msg);
            }
            System.out.print(" " + pct + '%');
            this.lastPct = pct;
        }
    }

    public void working() {
        if (this.hasGUI()) {
            this.setText(this.msg);
        }
    }

    public void done() {
        if (this.hasGUI()) {
            this.setText(" ");
        } else if (this.allowStdOut) {
            System.out.println(" 100%");
        }
    }

    public void setAllowStdOut(boolean flag) {
        this.allowStdOut = flag;
    }

    private void setText(String msg) {
        if (!ProgressMonitorList.instance().isEmpty()) {
            ProgressMonitor[] pmList;
            for (ProgressMonitor pm : pmList = ProgressMonitorList.instance().getList()) {
                pm.setTaskName(msg);
            }
        } else {
            this.statusPresenter.setStatusBarMessage(msg);
        }
    }
}

