/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import java.util.ArrayList;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.StringUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUtils;

public final class StackUtils {
    public static boolean isCoregisteredStack(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        return absRoot != null && absRoot.getAttributeInt("coregistered_stack", 0) == 1;
    }

    public static String getBandTimeStamp(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        if (absRoot != null) {
            String dateString = OperatorUtils.getAcquisitionDate(absRoot);
            if (!dateString.isEmpty()) {
                dateString = '_' + dateString;
            }
            return StringUtils.createValidName((String)dateString, (char[])new char[]{'_', '.'}, (char)'_');
        }
        return "";
    }

    public static void saveMasterProductBandNames(Product targetProduct, String[] masterProductBands) {
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata(targetProduct.getMetadataRoot());
        StringBuilder value = new StringBuilder(255);
        for (String name : masterProductBands) {
            value.append(name);
            value.append(' ');
        }
        targetSlaveMetadataRoot.setAttributeString("Master_bands", value.toString().trim());
    }

    public static void saveSlaveProductBandNames(Product targetProduct, String slvProductName, String[] bandNames) {
        if (bandNames.length == 0) {
            return;
        }
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata(targetProduct.getMetadataRoot());
        MetadataElement elem = targetSlaveMetadataRoot.getElement(slvProductName);
        StringBuilder value = new StringBuilder(255);
        for (String name : bandNames) {
            value.append(name);
            value.append(' ');
        }
        elem.setAttributeString("Slave_bands", value.toString().trim());
    }

    public static String[] getMasterBandNames(Product sourceProduct) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            String mstBandNames = slaveMetadataRoot.getAttributeString("Master_bands", "");
            return StringUtils.stringToArray((String)mstBandNames, (String)" ");
        }
        return new String[0];
    }

    public static String[] getSlaveBandNames(Product sourceProduct, String slvProductName) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            MetadataElement elem = slaveMetadataRoot.getElement(slvProductName);
            String slvBandNames = elem.getAttributeString("Slave_bands", "");
            return StringUtils.stringToArray((String)slvBandNames, (String)" ");
        }
        return new String[0];
    }

    public static String[] getSlaveProductNames(Product sourceProduct) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            return slaveMetadataRoot.getElementNames();
        }
        return new String[0];
    }

    public static String getBandNameWithoutDate(String bandName) {
        if (bandName.contains("_mst")) {
            return bandName.substring(0, bandName.lastIndexOf("_mst"));
        }
        if (bandName.contains("_slv")) {
            return bandName.substring(0, bandName.lastIndexOf("_slv"));
        }
        if (bandName.contains("_")) {
            return bandName.substring(0, bandName.lastIndexOf(95));
        }
        return bandName;
    }

    public static String getSlaveProductName(Product sourceProduct, Band slvBand, String mstPol) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            String slvBandName = slvBand.getName();
            for (MetadataElement elem : slaveMetadataRoot.getElements()) {
                String slvBandNames = elem.getAttributeString("Slave_bands", "");
                if (mstPol == null && slvBandNames.contains(slvBandName)) {
                    return elem.getName();
                }
                if (mstPol == null) continue;
                String[] bandNames = StringUtils.toStringArray((String)slvBandNames, (String)" ");
                boolean polExist = false;
                for (String slvName : bandNames) {
                    String slvPol = OperatorUtils.getPolarizationFromBandName(slvName);
                    if (slvPol == null || !slvPol.equalsIgnoreCase(mstPol)) continue;
                    polExist = true;
                    if (!slvName.equals(slvBandName)) continue;
                    return elem.getName();
                }
                if (polExist || !slvBandNames.contains(slvBandName)) continue;
                return elem.getName();
            }
        }
        return null;
    }

    public static ProductData.UTC getSlaveTime(Product sourceProduct, Band slvBand) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            String slvBandName = slvBand.getName();
            for (MetadataElement elem : slaveMetadataRoot.getElements()) {
                String slvBandNames = elem.getAttributeString("Slave_bands", "");
                if (!slvBandNames.contains(slvBandName)) continue;
                return elem.getAttributeUTC("first_line_time");
            }
        }
        return null;
    }

    public static ProductData.UTC[] getProductTimes(Product sourceProduct) {
        ArrayList<ProductData.UTC> utcList = new ArrayList<ProductData.UTC>();
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(sourceProduct);
        if (absRoot != null) {
            utcList.add(absRoot.getAttributeUTC("first_line_time"));
            MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
            if (slaveMetadataRoot != null) {
                for (MetadataElement elem : slaveMetadataRoot.getElements()) {
                    utcList.add(elem.getAttributeUTC("first_line_time"));
                }
            }
        }
        return utcList.toArray(new ProductData.UTC[utcList.size()]);
    }

    public static String[] bandsToStringArray(Band[] bands) {
        String[] names = new String[bands.length];
        int i = 0;
        for (Band band : bands) {
            names[i++] = band.getName();
        }
        return names;
    }
}

