/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import java.io.File;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.snap.util.ProductFunctions;
import org.esa.snap.util.TestUtils;

public abstract class RecursiveProcessor {
    public int recurseProcessFolder(File folder, int iterations, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        File[] fileList;
        int maxIteration = TestUtils.getMaxIterations();
        for (File file : fileList = folder.listFiles(new ProductFunctions.ValidProductFileFilter(true))) {
            if (maxIteration > 0 && iterations >= maxIteration) break;
            if (file.isDirectory()) {
                if (file.getName().contains("skipTest")) continue;
                iterations = this.recurseProcessFolder(file, iterations, productTypeExemptions, exceptionExemptions);
                continue;
            }
            try {
                Product sourceProduct = ProductIO.readProduct((File)file);
                if (sourceProduct == null || productTypeExemptions != null && TestUtils.containsProductType(productTypeExemptions, sourceProduct.getProductType())) continue;
                this.process(sourceProduct);
                ++iterations;
            }
            catch (Exception e) {
                boolean ok = false;
                if (exceptionExemptions != null) {
                    for (String excemption : exceptionExemptions) {
                        if (!e.getMessage().contains(excemption)) continue;
                        ok = true;
                        System.out.println("Excemption for " + e.getMessage());
                        break;
                    }
                }
                if (ok) continue;
                System.out.println("Failed to process " + file.toString());
                throw e;
            }
        }
        return iterations;
    }

    protected abstract void process(Product var1);
}

