/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.math.MathUtils;
import org.esa.snap.datamodel.AbstractMetadata;

public final class ReaderUtils {
    public static void createVirtualPhaseBand(Product product, Band bandI, Band bandQ, String countStr) {
        String expression = "atan2(" + bandQ.getName() + ',' + bandI.getName() + ')';
        VirtualBand virtBand = new VirtualBand("Phase" + countStr, 30, bandI.getSceneRasterWidth(), bandI.getSceneRasterHeight(), expression);
        virtBand.setUnit("phase");
        virtBand.setDescription("Phase from complex data");
        virtBand.setNoDataValueUsed(true);
        product.addBand((Band)virtBand);
    }

    public static void createVirtualIntensityBand(Product product, Band bandI, Band bandQ, String countStr) {
        String expression = bandI.getName() + " * " + bandI.getName() + " + " + bandQ.getName() + " * " + bandQ.getName();
        VirtualBand virtBand = new VirtualBand("Intensity" + countStr, 30, bandI.getSceneRasterWidth(), bandI.getSceneRasterHeight(), expression);
        virtBand.setUnit("intensity");
        virtBand.setDescription("Intensity from complex data");
        virtBand.setNoDataValueUsed(true);
        product.addBand((Band)virtBand);
        if (bandI.getGeoCoding() != product.getGeoCoding()) {
            virtBand.setGeoCoding(bandI.getGeoCoding());
        }
        product.setQuicklookBandName(virtBand.getName());
    }

    public static File getFileFromInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        return null;
    }

    public static void addGeoCoding(Product product, float[] latCorners, float[] lonCorners) {
        if (latCorners == null || lonCorners == null) {
            return;
        }
        int gridWidth = 10;
        int gridHeight = 10;
        float[] fineLatTiePoints = new float[100];
        ReaderUtils.createFineTiePointGrid(2, 2, 10, 10, latCorners, fineLatTiePoints);
        float subSamplingX = (float)product.getSceneRasterWidth() / 9.0f;
        float subSamplingY = (float)product.getSceneRasterHeight() / 9.0f;
        if (subSamplingX == 0.0f || subSamplingY == 0.0f) {
            return;
        }
        TiePointGrid latGrid = new TiePointGrid("latitude", 10, 10, 0.5f, 0.5f, subSamplingX, subSamplingY, fineLatTiePoints);
        latGrid.setUnit("deg");
        float[] fineLonTiePoints = new float[100];
        ReaderUtils.createFineTiePointGrid(2, 2, 10, 10, lonCorners, fineLonTiePoints);
        TiePointGrid lonGrid = new TiePointGrid("longitude", 10, 10, 0.5f, 0.5f, subSamplingX, subSamplingY, fineLonTiePoints, TiePointGrid.DISCONT_AT_180);
        lonGrid.setUnit("deg");
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid, Datum.WGS_84);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setGeoCoding((GeoCoding)tpGeoCoding);
    }

    public static void createFineTiePointGrid(int coarseGridWidth, int coarseGridHeight, int fineGridWidth, int fineGridHeight, float[] coarseTiePoints, float[] fineTiePoints) {
        if (coarseTiePoints == null || coarseTiePoints.length != coarseGridWidth * coarseGridHeight) {
            throw new IllegalArgumentException("coarse tie point array size does not match 'coarseGridWidth' x 'coarseGridHeight'");
        }
        if (fineTiePoints == null || fineTiePoints.length != fineGridWidth * fineGridHeight) {
            throw new IllegalArgumentException("fine tie point array size does not match 'fineGridWidth' x 'fineGridHeight'");
        }
        int k = 0;
        for (int r = 0; r < fineGridHeight; ++r) {
            float lambdaR = (float)r / (float)(fineGridHeight - 1);
            float betaR = lambdaR * (float)(coarseGridHeight - 1);
            int j0 = (int)betaR;
            int j1 = Math.min(j0 + 1, coarseGridHeight - 1);
            float wj = betaR - (float)j0;
            for (int c = 0; c < fineGridWidth; ++c) {
                float lambdaC = (float)c / (float)(fineGridWidth - 1);
                float betaC = lambdaC * (float)(coarseGridWidth - 1);
                int i0 = (int)betaC;
                int i1 = Math.min(i0 + 1, coarseGridWidth - 1);
                float wi = betaC - (float)i0;
                fineTiePoints[k++] = MathUtils.interpolate2D((float)wi, (float)wj, (float)coarseTiePoints[i0 + j0 * coarseGridWidth], (float)coarseTiePoints[i1 + j0 * coarseGridWidth], (float)coarseTiePoints[i0 + j1 * coarseGridWidth], (float)coarseTiePoints[i1 + j1 * coarseGridWidth]);
            }
        }
    }

    public static double getLineTimeInterval(ProductData.UTC startUTC, ProductData.UTC endUTC, int sceneHeight) {
        if (startUTC == null || endUTC == null) {
            return 0.0;
        }
        double startTime = startUTC.getMJD() * 24.0 * 3600.0;
        double stopTime = endUTC.getMJD() * 24.0 * 3600.0;
        return (stopTime - startTime) / (double)(sceneHeight - 1);
    }

    public static void addMetadataProductSize(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        if (absRoot != null) {
            AbstractMetadata.setAttribute(absRoot, "total_size", ReaderUtils.getTotalSize(product));
        }
    }

    public static int getTotalSize(Product product) {
        return (int)((float)product.getRawStorageSize() / 1048576.0f);
    }

    public static void addMetadataIncidenceAngles(Product product) {
        TiePointGrid tpg = product.getTiePointGrid("incident_angle");
        if (tpg == null) {
            return;
        }
        int midAz = product.getSceneRasterHeight() / 2;
        float inc1 = tpg.getPixelFloat(0, midAz);
        float inc2 = tpg.getPixelFloat(product.getSceneRasterWidth(), midAz);
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        AbstractMetadata.setAttribute(absRoot, "incidence_near", Math.min(inc1, inc2));
        AbstractMetadata.setAttribute(absRoot, "incidence_far", Math.max(inc1, inc2));
    }

    public static ProductData.UTC getTime(MetadataElement elem, String tag, DateFormat timeFormat) {
        if (elem == null) {
            return AbstractMetadata.NO_METADATA_UTC;
        }
        String timeStr = ReaderUtils.createValidUTCString(elem.getAttributeString(tag, " ").toUpperCase(), new char[]{':', '.', '-'}, ' ').trim();
        return AbstractMetadata.parseUTC(timeStr, timeFormat);
    }

    private static String createValidUTCString(String name, char[] validChars, char replaceChar) {
        Guardian.assertNotNull((String)"name", (Object)name);
        char[] sortedValidChars = null;
        sortedValidChars = validChars == null ? new char[5] : (char[])validChars.clone();
        Arrays.sort(sortedValidChars);
        StringBuilder validName = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isDigit(ch)) {
                validName.append(ch);
                continue;
            }
            if (Arrays.binarySearch(sortedValidChars, ch) >= 0) {
                validName.append(ch);
                continue;
            }
            validName.append(replaceChar);
        }
        return validName.toString();
    }

    public static String findExtensionForFormat(String formatName) {
        ProductWriter writer = ProductIO.getProductWriter((String)formatName);
        return writer.getWriterPlugIn().getDefaultFileExtensions()[0];
    }
}

