/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public final class ProcessTimeMonitor {
    private Date executeStartTime = null;

    public void start() {
        this.executeStartTime = Calendar.getInstance().getTime();
    }

    public long stop() {
        return this.getCurrentDuration();
    }

    public long getCurrentDuration() {
        Date now = Calendar.getInstance().getTime();
        return (now.getTime() - this.executeStartTime.getTime()) / 1000L;
    }

    public static String formatDuration(long dur) {
        DecimalFormat df = new DecimalFormat("#.##");
        if (dur > 120L) {
            float minutes = (float)dur / 60.0f;
            return df.format(minutes) + " minutes";
        }
        return df.format(dur) + " seconds";
    }
}

